/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack.ONode;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;
import org.noear.water.dso.CallSevUtil;
import org.noear.water.log.Level;
import org.noear.water.log.LogEvent;
import org.noear.water.log.Logger;
import org.noear.water.log.WaterLogger;
import org.noear.water.utils.GzipUtils;
import org.noear.water.utils.TextUtils;
import org.noear.water.utils.ThrowableUtils;

public class LogApi {
    private Map<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Logger logger(String logger) {
        Logger l;
        Logger tmp = this.loggerMap.get(logger);
        if (tmp == null && (l = this.loggerMap.putIfAbsent(logger, tmp = WaterLogger.get(logger))) != null) {
            tmp = l;
        }
        return tmp;
    }

    public void append(String logger, Level level, Map<String, Object> map) {
        this.append(logger, level, (String)map.get("tag"), (String)map.get("tag1"), (String)map.get("tag2"), (String)map.get("tag3"), (String)map.get("summary"), map.get("content"));
    }

    public void append(String logger, Level level, String summary, Object content) {
        this.append(logger, level, null, null, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String summary, Object content) {
        this.append(logger, level, tag, null, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String summary, Object content) {
        this.append(logger, level, tag, tag1, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String summary, Object content) {
        this.append(logger, level, tag, tag1, tag2, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.append(logger, level, tag, tag1, tag2, tag3, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content, boolean async) {
        String trace_id = WaterClient.waterTraceId();
        if (async) {
            WaterSetting.pools.submit(() -> this.appendDo(logger, trace_id, level, tag, tag1, tag2, tag3, summary, content));
        } else {
            this.appendDo(logger, trace_id, level, tag, tag1, tag2, tag3, summary, content);
        }
    }

    private void appendDo(String logger, String trace_id, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        String content_str;
        if (TextUtils.isEmpty((CharSequence)logger)) {
            return;
        }
        if (logger.indexOf(".") > 0) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logger", logger);
        if (TextUtils.isNotEmpty((CharSequence)trace_id)) {
            params.put("trace_id", trace_id);
        }
        params.put("level", String.valueOf(level.code));
        if (tag != null) {
            params.put("tag", tag);
        }
        if (tag1 != null) {
            params.put("tag1", tag1);
        }
        if (tag2 != null) {
            params.put("tag2", tag2);
        }
        if (tag3 != null) {
            params.put("tag3", tag3);
        }
        if (summary != null) {
            params.put("summary", summary);
        }
        if (WaterClient.localServiceHost() != null) {
            params.put("from", WaterClient.localServiceHost());
        }
        if ((content_str = this.content_str(content)) != null) {
            params.put("content", content_str);
        }
        try {
            CallSevUtil.post("/log/add/", params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String content_str(Object content) {
        if (content != null) {
            if (content instanceof String) {
                return (String)content;
            }
            if (content instanceof Throwable) {
                return ThrowableUtils.getString((Throwable)((Throwable)content));
            }
            return ONode.load((Object)content).toJson();
        }
        return null;
    }

    public void appendAll(List<LogEvent> list, boolean async) {
        if (async) {
            WaterSetting.pools.submit(() -> this.appendAllDo(list));
        } else {
            this.appendAllDo(list);
        }
    }

    private void appendAllDo(List<LogEvent> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (LogEvent log : list) {
            log.content = this.content_str(log.content);
        }
        String json = ONode.serialize(list);
        try {
            if (WaterLogger.isGzip()) {
                CallSevUtil.postBody("/log/add2/", GzipUtils.compress((String)json), "application/x-gzip");
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("list", json);
                CallSevUtil.post("/log/add2/", map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

