/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.water.WaterClient;
import org.noear.water.dso.CallCfgUtil;
import org.noear.water.model.DiscoverM;

public class RegistryApi {
    public void register(String service, String address, String meta, boolean is_unstable) {
        this.register(service, address, meta, "", 1, "", is_unstable);
    }

    public void register(String service, String address, String check_url, String alarm_mobile, boolean is_unstable) {
        this.register(service, address, check_url, 0, alarm_mobile, is_unstable);
    }

    public void register(String service, String address, String check_url, int check_type, String alarm_mobile, boolean is_unstable) {
        this.register(service, address, "", check_url, check_type, alarm_mobile, is_unstable);
    }

    public void register(String service, String address, String meta, String check_url, int check_type, String alarm_mobile, boolean is_unstable) {
        String code_location = WaterClient.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        this.register(service, address, meta, check_url, check_type, alarm_mobile, code_location, is_unstable);
    }

    public void register(String service, String address, String meta, String check_url, int check_type, String alarm_mobile, String code_location, boolean is_unstable) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("address", address);
        params.put("meta", meta);
        params.put("alarm_mobile", alarm_mobile);
        params.put("is_unstable", is_unstable ? "1" : "0");
        params.put("code_location", code_location);
        params.put("check_url", check_url);
        params.put("check_type", check_type + "");
        try {
            CallCfgUtil.post("/sev/reg/", params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void unregister(String service, String address, String meta) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("address", address);
        params.put("meta", meta);
        try {
            CallCfgUtil.post("/sev/unreg/", params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void set(String service, String address, String meta, boolean enabled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("address", address);
        params.put("meta", meta);
        params.put("enabled", enabled ? "1" : "0");
        try {
            CallCfgUtil.post("/sev/set/", params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public DiscoverM discover(String service, String consumer, String consumer_address) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("consumer", consumer);
        params.put("consumer_address", consumer_address);
        try {
            String json = CallCfgUtil.post("/sev/discover/", params);
            ONode rst = ONode.loadStr((String)json);
            if (rst.get("code").getInt() != 1) {
                return null;
            }
            ONode data = rst.get("data");
            if (data.isObject()) {
                DiscoverM cfg = new DiscoverM();
                cfg.url = data.get("url").getString();
                cfg.policy = data.get("policy").getString();
                if (data.contains("list")) {
                    for (ONode n : data.get("list").ary()) {
                        cfg.add(n.get("protocol").getString(), n.get("address").getString(), n.get("meta").getString(), n.get("weight").getInt());
                    }
                }
                return cfg;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

