/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;
import org.noear.water.dso.ApiCaller;
import org.noear.water.track.TrackBuffer;
import org.noear.water.track.TrackNames;
import org.noear.water.utils.RedisX;
import org.noear.water.utils.TextUtils;
import org.noear.weed.Command;

public class TrackApi {
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getTrackApiUrl());
    public static RedisX rd_track = WaterSetting.redis_track_cfg().getRd(5);
    public static RedisX rd_track_md5 = WaterSetting.redis_track_cfg().getRd(6);

    public String getNameMd5(String name) {
        return TrackNames.singleton().getNameMd5(name);
    }

    public String getName(String nameMd5) {
        return TrackNames.singleton().getName(nameMd5);
    }

    public void track(String service, String tag, String name, long timespan) {
        this.track(service, tag, name, timespan, null, null);
    }

    public void track(String service, String tag, String name, long timespan, String _node) {
        this.track(service, tag, name, timespan, _node, null);
    }

    public void track(String service, String tag, String name, long timespan, String _node, String _from) {
        String nameMd5 = this.getNameMd5(name);
        TrackBuffer.singleton().append(service, tag, nameMd5, timespan, _node, _from);
    }

    public void track(String service, Command cmd, long thresholdValue) {
        long timespan = cmd.timespan();
        if (timespan > thresholdValue) {
            this.track0(service, cmd, null, null, null, null, null);
        }
    }

    public void track(String service, Command cmd, String ua, String path, String operator, String operator_ip) {
        this.track0(service, cmd, ua, path, operator, operator_ip, null);
    }

    private void track0(String service, Command cmd, String ua, String path, String operator, String operator_ip, String note) {
        long interval = cmd.timespan();
        String trace_id = WaterClient.waterTraceId();
        WaterSetting.pools.submit(() -> this.track0Do(service, trace_id, cmd, interval, ua, path, operator, operator_ip, note));
    }

    private void track0Do(String service, String trace_id, Command cmd, long interval, String ua, String path, String operator, String operator_ip, String note) {
        Map map = cmd.paramMap();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("schema", cmd.context.schema());
        params.put("interval", String.valueOf(interval));
        params.put("cmd_sql", cmd.text);
        params.put("cmd_arg", ONode.loadObj((Object)map).toJson());
        if (!TextUtils.isEmpty((CharSequence)operator)) {
            params.put("operator", operator);
        }
        if (!TextUtils.isEmpty((CharSequence)operator_ip)) {
            params.put("operator_ip", operator_ip);
        }
        if (!TextUtils.isEmpty((CharSequence)path)) {
            params.put("path", path);
        }
        if (!TextUtils.isEmpty((CharSequence)ua)) {
            params.put("ua", ua);
        }
        if (!TextUtils.isEmpty((CharSequence)note)) {
            params.put("note", note);
        }
        try {
            this.apiCaller.post("/mot/track/sql/", params, trace_id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        TrackBuffer.singleton().bind(rd_track);
        TrackNames.singleton().bind(rd_track_md5);
    }
}

