/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;
import org.noear.water.dso.ApiCaller;
import org.noear.water.dso.LogPipeline;
import org.noear.water.log.Level;
import org.noear.water.log.LogEvent;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.GzipUtils;
import org.noear.water.utils.LogHelper;
import org.noear.water.utils.TextUtils;

public class LogApi {
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getLogApiUrl());

    public void append(String logger, Level level, Map<String, Object> map) {
        this.append(logger, level, (String)map.get("tag"), (String)map.get("tag1"), (String)map.get("tag2"), (String)map.get("tag3"), (String)map.get("summary"), map.get("content"));
    }

    public void append(String logger, Level level, String summary, Object content) {
        this.append(logger, level, null, null, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String summary, Object content) {
        this.append(logger, level, tag, null, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String summary, Object content) {
        this.append(logger, level, tag, tag1, null, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String summary, Object content) {
        this.append(logger, level, tag, tag1, tag2, null, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        this.append(logger, level, tag, tag1, tag2, tag3, summary, content, true);
    }

    public void append(String logger, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content, boolean async) {
        String trace_id = WaterClient.waterTraceId();
        this.appendDo(logger, trace_id, level, tag, tag1, tag2, tag3, summary, content);
    }

    private void appendDo(String logger, String trace_id, Level level, String tag, String tag1, String tag2, String tag3, String summary, Object content) {
        if (TextUtils.isEmpty((CharSequence)logger)) {
            return;
        }
        if (logger.indexOf(".") > 0) {
            return;
        }
        Datetime datetime = Datetime.Now();
        LogEvent log = new LogEvent();
        log.logger = logger;
        log.level = level.code;
        log.tag = tag;
        log.tag1 = tag1;
        log.tag2 = tag2;
        log.tag3 = tag3;
        log.summary = summary;
        log.content = LogHelper.contentAsString((Object)content);
        log.trace_id = trace_id;
        log.from = WaterClient.localServiceHost();
        log.thread_name = Thread.currentThread().getName();
        log.log_date = datetime.getDate();
        log.log_fulltime = datetime.getFulltime();
        LogPipeline.singleton().add(log);
    }

    public void appendAll(List<LogEvent> list, boolean async) {
        if (async) {
            WaterSetting.pools.submit(() -> this.appendAllDo(list));
        } else {
            this.appendAllDo(list);
        }
    }

    private void appendAllDo(List<LogEvent> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        String json = ONode.serialize(list);
        try {
            if (WaterSetting.water_logger_gzip()) {
                this.apiCaller.postBody("/log/add2/", GzipUtils.gZip((String)json), "water/glog");
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("list", json);
                this.apiCaller.post("/log/add2/", map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

