/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.noear.water.WaterClient;
import org.noear.water.model.LoadBalanceM;
import org.noear.water.utils.HttpUtils;

class ApiCaller {
    private LoadBalanceM urlLb;
    private boolean asLongHttp;

    public ApiCaller(LoadBalanceM serverLb) {
        this.urlLb = serverLb;
        this.asLongHttp = false;
    }

    public ApiCaller asLongHttp() {
        this.asLongHttp = true;
        return this;
    }

    public ApiCaller asShortHttp() {
        this.asLongHttp = false;
        return this;
    }

    public HttpUtils http(String path) {
        String server = this.urlLb.get();
        String url = server.endsWith("/") ? (path.startsWith("/") ? server + path.substring(1) : server + path) : (path.startsWith("/") ? server + path : server + "/" + path);
        HttpUtils httpUtils = HttpUtils.http((String)url);
        if (this.asLongHttp) {
            httpUtils.asLongHttp();
        } else {
            httpUtils.asShortHttp();
        }
        return httpUtils.headerAdd("Water-Access-Token", WaterClient.waterAclToken()).headerAdd("Water-Version", "v2.10.3").headerAdd("Water-Trace-Id", WaterClient.waterTraceId()).headerAdd("Water-From", WaterClient.localServiceHost());
    }

    public String post(String path, Map<String, String> data, String trace_id) throws IOException {
        return this.http(path).header("Water-Trace-Id", trace_id).data(data).post();
    }

    public String post(String path, Map<String, String> data) throws IOException {
        return this.http(path).data(data).post();
    }

    public String postBody(String path, byte[] bytes, String contentType) throws IOException {
        return this.http(path).bodyRaw((InputStream)new ByteArrayInputStream(bytes), contentType).post();
    }

    public String postBody(String path, String text, String contentType) throws IOException {
        return this.http(path).bodyTxt(text, contentType).post();
    }

    public void postAsync(String path, Map<String, String> data) {
        try {
            this.http(path).data(data).postAsync(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String get(String path) throws IOException {
        return this.http(path).get();
    }
}

