/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import org.noear.snack.ONode;
import org.noear.water.WaterClient;
import org.noear.water.model.LogM;
import org.noear.wood.Command;

public class BehaviorUtils {
    public static void trackOfPerformance(String service, Command cmd, long thresholdValue) {
        long timespan = cmd.timespan();
        if (timespan > thresholdValue) {
            BehaviorUtils.track0(service, cmd, null, null, null, WaterClient.localHost());
        }
    }

    public static void trackOfBehavior(String service, Command cmd, String ua, String path, String operator, String operator_ip) {
        BehaviorUtils.track0(service, cmd, ua, path, operator, operator_ip);
    }

    private static void track0(String service, Command cmd, String ua, String path, String operator, String operator_ip) {
        long interval = cmd.timespan();
        String trace_id = WaterClient.waterTraceId();
        BehaviorUtils.track0Do(service, trace_id, cmd, interval, ua, path, operator, operator_ip);
    }

    private static void track0Do(String service, String trace_id, Command cmd, long interval, String ua, String path, String operator, String operator_ip) {
        int seconds = (int)(interval / 1000L);
        String schema = cmd.context.schema();
        String sqlUp = cmd.text.toUpperCase();
        String method = "OTHER";
        if (sqlUp.indexOf("SELECT ") >= 0) {
            method = "SELECT";
        } else if (sqlUp.indexOf("UPDATE ") >= 0) {
            method = "UPDATE";
        } else if (sqlUp.indexOf("DELETE ") >= 0) {
            method = "DELETE";
        } else if (sqlUp.indexOf("INSERT INTO ") >= 0) {
            method = "INSERT";
        }
        LogM logM = new LogM();
        logM.logger = path == null ? "water_log_sql_p" : "water_log_sql_b";
        logM.trace_id = trace_id;
        logM.level = 1;
        logM.tag = String.valueOf(seconds);
        logM.tag1 = path;
        logM.tag2 = operator;
        logM.tag3 = method;
        logM.tag4 = "";
        logM.weight = interval;
        logM.group = schema;
        logM.service = service;
        StringBuilder content = new StringBuilder();
        content.append(schema).append("::").append(cmd.text);
        content.append("<n-l>$$$").append(ONode.stringify((Object)cmd.paramMap())).append("</n-l>");
        logM.content = content.toString();
        logM.from = operator_ip;
        WaterClient.Log.append(logM);
    }
}

