/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.dso.ApiCaller;
import org.noear.water.model.KeyM;

public class KeyApi {
    protected final ApiCaller apiCaller;
    Map<String, KeyM> keyMap = Collections.synchronizedMap(new HashMap());
    Map<Integer, KeyM> keyMap2 = Collections.synchronizedMap(new HashMap());

    public KeyApi() {
        this.apiCaller = new ApiCaller(WaterAddress.getCfgApiUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyM getKeyByAccessKey(String accessKey) throws IOException {
        KeyM keyM = this.keyMap.get(accessKey);
        if (keyM == null) {
            String string = accessKey.intern();
            synchronized (string) {
                keyM = this.keyMap.get(accessKey);
                if (keyM == null) {
                    keyM = this.loadDo(accessKey, 0);
                }
                this.keyMap2.put(keyM.key_id(), keyM);
                this.keyMap.put(accessKey, keyM);
            }
        }
        return keyM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyM getKeyById(Integer keyId) throws IOException {
        KeyM keyM = this.keyMap2.get(keyId);
        if (keyM == null) {
            Integer n = keyId;
            synchronized (n) {
                keyM = this.keyMap.get(keyId);
                if (keyM == null) {
                    keyM = this.loadDo("", keyId);
                }
                this.keyMap2.put(keyId, keyM);
                this.keyMap.put(keyM.access_key(), keyM);
            }
        }
        return keyM;
    }

    public void refresh(String accessKey, int orKeyId) throws IOException {
        KeyM keyM = this.loadDo(accessKey, orKeyId);
        if (keyM.key_id() > 0) {
            this.keyMap2.put(keyM.key_id(), keyM);
            this.keyMap.put(keyM.access_key(), keyM);
        }
    }

    protected KeyM loadDo(String accessKey, int orKeyId) throws IOException {
        String json = this.apiCaller.http("/key/get/").data("accessKey", accessKey).data("keyId", String.valueOf(orKeyId)).post();
        ONode oNode = ONode.loadStr((String)json);
        int code = oNode.get("code").getInt();
        KeyM keyM = code == 200 ? (KeyM)oNode.get("data").toObject(KeyM.class) : new KeyM();
        return keyM;
    }
}

