/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;
import org.noear.water.dso.ApiCaller;
import org.noear.water.dso.LogPipeline;
import org.noear.water.model.LogLevel;
import org.noear.water.model.LogM;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.GzipUtils;
import org.noear.water.utils.LogHelper;
import org.noear.water.utils.TextUtils;

public class LogApi {
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getLogApiUrl());

    @Deprecated
    public void append(String logger, LogLevel level, Map<String, Object> map) {
        if (TextUtils.isEmpty((CharSequence)logger)) {
            return;
        }
        if (logger.indexOf(".") > 0) {
            return;
        }
        LogM log = new LogM();
        log.logger = logger;
        log.level = level.code;
        log.tag = map.getOrDefault("tag", "").toString();
        log.tag1 = map.getOrDefault("tag1", "").toString();
        log.tag2 = map.getOrDefault("tag2", "").toString();
        log.tag3 = map.getOrDefault("tag3", "").toString();
        log.tag4 = map.getOrDefault("tag4", "").toString();
        log.content = LogHelper.contentAsString((Object)map.get("content"));
        this.append(log);
    }

    public void append(LogM log) {
        if (TextUtils.isEmpty((CharSequence)log.logger)) {
            return;
        }
        if (log.logger.contains(".")) {
            return;
        }
        if (log.level == 0) {
            log.level = LogLevel.ERROR.code;
        }
        if (log.trace_id == null) {
            log.trace_id = WaterClient.waterTraceId();
        }
        log.from = WaterClient.localServiceHost();
        log.thread_name = Thread.currentThread().getName();
        if (log.log_date == 0) {
            Datetime datetime = Datetime.Now();
            log.log_date = datetime.getDate();
            log.log_fulltime = datetime.getFulltime();
        }
        LogPipeline.singleton().add(log);
    }

    public void appendAll(List<LogM> list, boolean async) {
        if (async) {
            WaterSetting.pools.submit(() -> this.appendAllDo(list));
        } else {
            this.appendAllDo(list);
        }
    }

    private void appendAllDo(List<LogM> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        String json = ONode.serialize(list);
        try {
            if (WaterSetting.water_logger_gzip()) {
                this.apiCaller.postBody("/log/add2/", GzipUtils.gZip((String)json), "water/glog");
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("list", json);
                this.apiCaller.post("/log/add2/", map);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

