/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.Date;
import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.dso.ApiCaller;
import org.noear.water.dso.MessageHandler;
import org.noear.water.model.MessageM;
import org.noear.water.utils.EncryptUtils;
import org.noear.water.utils.IDUtils;
import org.noear.water.utils.TextUtils;
import org.noear.water.utils.ext.Fun1;

public class MessageApi {
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getMessageApiUrl());

    public boolean subscribeTopic(String broker, String subscriber_key, String subscriber_name, String subscriber_tag, String receive_url, String receive_key, String alarm_mobile, int receive_way, boolean is_unstable, String[] topics) throws Exception {
        String topics_str = String.join((CharSequence)",", topics);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        params.put("note", subscriber_name);
        if (TextUtils.isNotEmpty((CharSequence)broker)) {
            params.put("broker", broker);
        }
        params.put("subscriber_key", subscriber_key);
        params.put("subscriber_name", subscriber_name);
        params.put("subscriber_tag", subscriber_tag);
        params.put("topic", topics_str);
        params.put("receiver_url", receive_url);
        params.put("receive_url", receive_url);
        params.put("receive_way", receive_way + "");
        params.put("receive_key", receive_key);
        params.put("access_key", receive_key);
        params.put("alarm_mobile", alarm_mobile);
        params.put("is_unstable", is_unstable ? "1" : "0");
        String txt = this.apiCaller.post("/msg/subscribe/", params);
        int code = ONode.loadStr((String)txt).get("code").getInt();
        return code == 1 || code == 200;
    }

    public boolean unSubscribeTopic(String broker, String subscriber_key, String[] topics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", subscriber_key);
        if (TextUtils.isNotEmpty((CharSequence)broker)) {
            params.put("broker", broker);
        }
        params.put("subscriber_key", subscriber_key);
        params.put("topic", String.join((CharSequence)",", topics));
        String txt = this.apiCaller.post("/msg/unsubscribe/", params);
        int code = ONode.loadStr((String)txt).get("code").getInt();
        return code == 1 || code == 200;
    }

    public boolean sendMessage(String broker, String topic, String message) throws Exception {
        return this.sendMessage(broker, null, topic, message, null);
    }

    public boolean sendMessage(String broker, String msg_key, String topic, String message) throws Exception {
        return this.sendMessage(broker, msg_key, topic, message, null);
    }

    public boolean sendMessage(String broker, String msg_key, String topic, String message, Date planTime) throws Exception {
        return this.sendMessageAndTags(broker, msg_key, topic, message, planTime, null);
    }

    public boolean sendMessageAndTags(String broker, String topic, String message, String tags) throws Exception {
        return this.sendMessageAndTags(broker, null, topic, message, tags);
    }

    public boolean sendMessageAndTags(String broker, String msg_key, String topic, String message, String tags) throws Exception {
        return this.sendMessageAndTags(broker, msg_key, topic, message, null, tags);
    }

    public boolean sendMessageAndTags(String broker, String msg_key, String topic, String message, Date planTime, String tags) throws Exception {
        String txt;
        ONode data;
        int code;
        HashMap<String, String> params = new HashMap<String, String>();
        if (TextUtils.isNotEmpty((CharSequence)broker)) {
            params.put("broker", broker);
        }
        params.put("topic", topic);
        params.put("message", message);
        if (msg_key != null) {
            params.put("key", msg_key);
        }
        if (tags != null) {
            params.put("tags", tags);
        }
        if (planTime != null) {
            params.put("plan_time", String.valueOf(planTime.getTime()));
        }
        if ((code = (data = ONode.loadStr((String)(txt = this.apiCaller.post("/msg/send/", params)))).get("code").getInt()) == 1 || code == 200) {
            return true;
        }
        throw new RuntimeException("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public boolean sendMessageCallback(String broker, String message, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageCallback(broker, null, message, null, receiver_url, receiver_cehck);
    }

    public boolean sendMessageCallback(String broker, String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck) throws Exception {
        return this.sendMessageAndTagsCallback(broker, msg_key, message, planTime, receiver_url, receiver_cehck, null);
    }

    public boolean sendMessageAndTagsCallback(String broker, String message, String receiver_url, String receiver_cehck, String tags) throws Exception {
        return this.sendMessageAndTagsCallback(broker, null, message, null, receiver_url, receiver_cehck, tags);
    }

    public boolean sendMessageAndTagsCallback(String broker, String msg_key, String message, Date planTime, String receiver_url, String receiver_cehck, String tags) throws Exception {
        String txt;
        ONode data;
        int code;
        if (TextUtils.isEmpty((CharSequence)msg_key)) {
            msg_key = IDUtils.guid();
        }
        if (tags == null) {
            tags = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (TextUtils.isNotEmpty((CharSequence)broker)) {
            params.put("broker", broker);
        }
        params.put("key", msg_key);
        params.put("tags", tags);
        params.put("message", message);
        params.put("receiver_url", receiver_url);
        params.put("receiver_cehck", receiver_cehck);
        if (planTime != null) {
            params.put("plan_time", String.valueOf(planTime.getTime()));
        }
        if ((code = (data = ONode.loadStr((String)(txt = this.apiCaller.post("/msg/send/", params)))).get("code").getInt()) == 1 || code == 200) {
            return true;
        }
        throw new RuntimeException("\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + data.toJson());
    }

    public boolean cancelMessage(String broker, String msg_key) throws Exception {
        return this.cancelMessage(broker, msg_key, null);
    }

    public boolean cancelMessage(String broker, String msg_key, String subscriber_key) throws Exception {
        String txt;
        int code;
        HashMap<String, String> params = new HashMap<String, String>();
        if (TextUtils.isNotEmpty((CharSequence)broker)) {
            params.put("broker", broker);
        }
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        return (code = ONode.loadStr((String)(txt = this.apiCaller.post("/msg/cancel/", params))).get("code").getInt()) == 1 || code == 200;
    }

    public boolean succeedMessage(String broker, String msg_key) throws Exception {
        return this.succeedMessage(broker, msg_key, null);
    }

    public boolean succeedMessage(String broker, String msg_key, String subscriber_key) throws Exception {
        String txt;
        int code;
        HashMap<String, String> params = new HashMap<String, String>();
        if (TextUtils.isNotEmpty((CharSequence)broker)) {
            params.put("broker", broker);
        }
        params.put("key", msg_key);
        if (!TextUtils.isEmpty((CharSequence)subscriber_key)) {
            params.put("subscriber_key", subscriber_key);
        }
        return (code = ONode.loadStr((String)(txt = this.apiCaller.post("/msg/succeed/", params))).get("code").getInt()) == 1 || code == 200;
    }

    public boolean checkMessage(MessageM msg, String receive_key) {
        if (TextUtils.isEmpty((CharSequence)msg.topic)) {
            return false;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append(msg.key).append("#");
        sb.append(msg.topic).append("#");
        sb.append(msg.message).append("#");
        sb.append(receive_key);
        String sgin_slf = EncryptUtils.md5((String)sb.toString());
        return sgin_slf.equals(msg.sgin);
    }

    public String receiveMessage(Fun1<String, String> paramS, String service_secretKey, MessageHandler consumer) throws Throwable {
        MessageM msg = new MessageM(paramS);
        if (!this.checkMessage(msg, service_secretKey)) {
            return "CHECK ERROR";
        }
        boolean isOk = consumer.handle(msg);
        return isOk ? "OK" : "ERROR";
    }
}

