/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.util.HashMap;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.dso.ApiCaller;
import org.noear.water.utils.Datetime;
import org.noear.water.utils.TextUtils;

public class NoticeApi {
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getDefApiUrl());

    public String heihei(String target, String msg) {
        return this.heiheiDo(target, msg);
    }

    public String heihei(String target, String msg, String sign) {
        if (TextUtils.isEmpty((CharSequence)sign)) {
            return this.heiheiDo(target, msg);
        }
        return this.heiheiDo(target, msg + "\n\n" + sign);
    }

    private String heiheiDo(String target, String msg) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("target", target);
        params.put("msg", msg);
        try {
            return this.apiCaller.post("/run/push/", params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void updateCache(String ... cacheTags) {
        StringBuilder sb = new StringBuilder();
        for (String tag : cacheTags) {
            sb.append(tag).append(";");
        }
        try {
            WaterClient.Message.sendMessageAndTags(null, "water.cache.update", sb.toString(), WaterClient.localService());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateCacheByDelay(int delay, String ... cacheTags) {
        StringBuilder sb = new StringBuilder();
        for (String tag : cacheTags) {
            sb.append(tag).append(";");
        }
        try {
            WaterClient.Message.sendMessageAndTags(null, null, "water.cache.update", sb.toString(), new Datetime().addSecond(3).getFulltime(), WaterClient.localService());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateConfig(String tag, String name) {
        try {
            WaterClient.Message.sendMessageAndTags(null, null, "water.config.update", tag + "::" + name, new Datetime().addSecond(3).getFulltime(), tag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

