/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.dso.ApiCaller;

public class I18nApi {
    protected final ApiCaller apiCaller;
    Map<String, Map> i18nMap = Collections.synchronizedMap(new HashMap());

    public I18nApi() {
        this.apiCaller = new ApiCaller(WaterAddress.getCfgApiUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getI18n(String tag, String bundle, String lang) throws IOException {
        String i18nKey = String.format("%s:%s:%s", tag, bundle, lang);
        Map<String, String> map = this.i18nMap.get(i18nKey);
        if (map == null) {
            String string = i18nKey.intern();
            synchronized (string) {
                map = this.i18nMap.get(i18nKey);
                if (map == null) {
                    map = this.loadDo(tag, bundle, lang);
                }
                this.i18nMap.put(i18nKey, map);
            }
        }
        return map;
    }

    public Map getI18nNoCache(String tag, String bundle, String lang) throws IOException {
        Map<String, String> map = this.loadDo(tag, bundle, lang);
        if (map.size() > 0) {
            String i18nKey = String.format("%s:%s:%s", tag, bundle, lang);
            this.i18nMap.put(i18nKey, map);
        }
        return map;
    }

    protected Map<String, String> loadDo(String tag, String bundle, String lang) throws IOException {
        String json = this.apiCaller.http("/i18n/get/").data("tag", tag).data("bundle", bundle).data("lang", lang).post();
        ONode oNode = ONode.loadStr((String)json);
        int code = oNode.get("code").getInt();
        Map<String, String> map = code == 200 ? (Map)oNode.get("data").toObject(Map.class) : new LinkedHashMap<String, String>();
        return map;
    }
}

