/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dso;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.noear.snack.ONode;
import org.noear.water.WaterAddress;
import org.noear.water.dso.ApiCaller;
import org.noear.water.dso.ConfigHandler;
import org.noear.water.model.ConfigM;
import org.noear.water.model.ConfigSetM;

public class ConfigApi {
    private Map<String, ConfigSetM> _cfgMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<ConfigHandler>> _cfgSubMap = new HashMap<String, Set<ConfigHandler>>();
    protected final ApiCaller apiCaller = new ApiCaller(WaterAddress.getCfgApiUrl());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String tag) {
        Map<String, ConfigSetM> map = this._cfgMap;
        synchronized (map) {
            if (!this._cfgMap.containsKey(tag)) {
                return;
            }
            this.load0(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String tag) {
        Map<String, ConfigSetM> map = this._cfgMap;
        synchronized (map) {
            if (this._cfgMap.containsKey(tag)) {
                return;
            }
            this.load0(tag);
        }
    }

    private void load0(String tag) {
        ConfigSetM cfgSet;
        block2: {
            cfgSet = new ConfigSetM(tag);
            try {
                String temp = this.apiCaller.get("/cfg/get/?v=2&tag=" + tag);
                cfgSet.load(ONode.loadStr((String)temp));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!this._cfgMap.containsKey(tag)) break block2;
                return;
            }
        }
        this._cfgMap.put(tag, cfgSet);
        this.noticeTry(tag, cfgSet);
    }

    @Deprecated
    public Properties getProperties(String tag) {
        this.load(tag);
        return this._cfgMap.get(tag).getPropSet();
    }

    public ConfigM getByTagKey(String tagKey) {
        String[] ss = tagKey.split("/");
        return this.get(ss[0], ss[1]);
    }

    public ConfigM get(String tag, String key) {
        this.load(tag);
        return this._cfgMap.get(tag).get(key);
    }

    private void noticeTry(String target, ConfigSetM cfgSet) {
        Set<ConfigHandler> tmp = this._cfgSubMap.get(target);
        if (tmp != null) {
            for (ConfigHandler r : tmp) {
                r.handle(cfgSet);
            }
        }
    }

    public void subscribe(String tag, ConfigHandler callback) {
        Set<ConfigHandler> tmp = this._cfgSubMap.get(tag);
        if (tmp == null) {
            tmp = new HashSet<ConfigHandler>();
            this._cfgSubMap.put(tag, tmp);
        }
        tmp.add(callback);
        if (this._cfgMap.containsKey(tag)) {
            callback.handle(this._cfgMap.get(tag));
        }
    }

    public void setByTagKey(String tagKey, String value) throws IOException {
        String[] ss = tagKey.split("/");
        this.set(ss[0], ss[1], value);
    }

    public void set(String tag, String key, String value) throws IOException {
        this.apiCaller.http("/cfg/set/").data("tag", tag).data("key", key).data("value", value).post();
        if (this._cfgMap.containsKey(tag)) {
            this._cfgMap.get(tag).set(key, value);
        }
    }
}

