/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration;

import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.water.WaterClient;
import org.noear.water.utils.BehaviorUtils;
import org.noear.water.utils.TextUtils;
import org.noear.wood.Command;
import org.noear.wood.WoodConfig;

public class ServerPlugin
implements Plugin {
    static final String clz_GritUtil = "org.noear.grit.client.GritUtil";

    public void start(AopContext context) {
        this.initWood();
    }

    private void initWood() {
        Class gritClz = Utils.loadClass((String)clz_GritUtil);
        boolean isDebugMode = Solon.cfg().isDebugMode() || Solon.cfg().isFilesMode();
        boolean isWoodStyle2 = "text2".equals(Solon.cfg().get("water.wood.log.style"));
        boolean isTrackEnable = Solon.cfg().getBool("water.wood.track.enable", false);
        if (gritClz == null) {
            WoodConfig.onExecuteAft(cmd -> {
                if (cmd.isLog < 0) {
                    return;
                }
                if (isDebugMode) {
                    if (isWoodStyle2) {
                        System.out.println(cmd.toSqlString());
                    } else {
                        System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                    }
                }
                BehaviorUtils.trackOfPerformance((String)this.service_name(), (Command)cmd, (long)1000L);
                if (isTrackEnable || cmd.isLog > 0) {
                    String tag = cmd.context.schema();
                    if (TextUtils.isEmpty((CharSequence)tag)) {
                        tag = "sql";
                    }
                    WaterClient.Track.addMeterAndMd5(this.service_name() + "_sql", tag, cmd.text, cmd.timespan());
                }
            });
        } else {
            WoodConfig.onExecuteAft(cmd -> {
                Context context;
                if (cmd.isLog < 0) {
                    return;
                }
                if (isDebugMode) {
                    if (isWoodStyle2) {
                        System.out.println(cmd.toSqlString());
                    } else {
                        System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                    }
                }
                String sqlUp = cmd.text.toUpperCase();
                String chkUp = "User_Id=? AND Pass_Wd=? AND Is_Disabled=0".toUpperCase();
                if ((cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.indexOf("INSERT INTO ") >= 0 || sqlUp.indexOf("UPDATE ") >= 0 || sqlUp.indexOf("DELETE ") >= 0 || sqlUp.indexOf(chkUp) >= 0) && (context = Context.current()) != null) {
                    BehaviorUtils.trackOfBehavior((String)this.service_name(), (Command)cmd, (String)context.userAgent(), (String)context.path(), (String)(this.user_puid() + "." + this.user_name()), (String)context.realIp());
                }
                if (isTrackEnable || cmd.isLog > 0) {
                    String tag = cmd.context.schema();
                    if (TextUtils.isEmpty((CharSequence)tag)) {
                        tag = "sql";
                    }
                    WaterClient.Track.trackAndMd5(this.service_name() + "_sql", tag, cmd.text, cmd.timespan());
                }
            });
        }
    }

    private String service_name() {
        return Solon.cfg().appName();
    }

    private int user_puid() {
        if (Context.current() != null) {
            String tmp = (String)Context.current().attr("user_puid", (Object)"0");
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    private String user_name() {
        if (Context.current() != null) {
            return (String)Context.current().attr("user_name", null);
        }
        return null;
    }
}

