/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water;

import java.util.Map;
import org.noear.solon.cloud.utils.http.HttpUtils;
import org.noear.water.WaterClient;
import org.noear.water.config.ServerConfig;
import org.noear.water.model.LogLevel;
import org.noear.weed.cache.CacheUsing;

public class WaterProxy {
    static final String SERVICE_WATER_FAAS = "waterfaas";
    static final String SERVICE_WATER_RAAS = "waterraas";

    public static String call(String service, String path) throws Exception {
        return WaterProxy.call(service, path, null);
    }

    public static String call(String service, String path, Map<String, Object> args) throws Exception {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (args == null || args.size() == 0) {
            return HttpUtils.http((String)service, (String)path).get();
        }
        return HttpUtils.http((String)service, (String)path).data(args).post();
    }

    public static String callAndCache(String service, String path, Map<String, Object> args, CacheUsing cacheUsing) throws Exception {
        if (cacheUsing == null) {
            return WaterProxy.call(service, path, args);
        }
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(service).append("_");
        cacheKey.append(path).append("_");
        args.forEach((k, v) -> cacheKey.append((String)k).append("_").append(v.toString()).append("_"));
        return (String)cacheUsing.getEx(cacheKey.toString(), () -> WaterProxy.call(service, path, args));
    }

    public static String raas(String type, String tag, String name, Map<String, Object> args) throws Exception {
        String path = "/" + type + "/" + tag + "/" + name;
        return WaterProxy.raas(path, args);
    }

    public static String raas(String path, Map<String, Object> args) throws Exception {
        return WaterProxy.call(SERVICE_WATER_RAAS, path, args);
    }

    public static final String faas(String path) throws Exception {
        return WaterProxy.faas(path, null);
    }

    public static final String faas(String path, Map<String, Object> args) throws Exception {
        return WaterProxy.call(SERVICE_WATER_FAAS, path, args);
    }

    private static HttpUtils http(String url) {
        return HttpUtils.http((String)url);
    }

    public static String task(String service, String name) throws Exception {
        return HttpUtils.http((String)service, (String)"/run/job/").data("name", name).header("Water-Access-Token", ServerConfig.taskToken).post();
    }

    @Deprecated
    public static String job(String service, String name) throws Exception {
        return WaterProxy.task(service, name);
    }

    public static void logTrace(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, LogLevel.TRACE, map);
    }

    public static void logDebug(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, LogLevel.DEBUG, map);
    }

    public static void logInfo(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, LogLevel.INFO, map);
    }

    public static void logWarn(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, LogLevel.WARN, map);
    }

    public static void logError(String logger, Map<String, Object> map) {
        WaterClient.Log.append(logger, LogLevel.ERROR, map);
    }
}

