/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.integration;

import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Context;
import org.noear.water.WaterClient;
import org.noear.water.utils.TextUtils;
import org.noear.weed.WeedConfig;

public class ServerPlugin
implements Plugin {
    static final String clz_BcfClient = "org.noear.bcf.BcfClient";

    public void start(AopContext context) {
        this.initWeed();
    }

    private void initWeed() {
        Class bcfClz = Utils.loadClass((String)clz_BcfClient);
        boolean isDebugMode = Solon.cfg().isDebugMode() || Solon.cfg().isFilesMode();
        boolean isWeedStyle2 = "text2".equals(Solon.cfg().get("water.weed.log.style"));
        boolean isTrackEnable = Solon.cfg().getBool("water.weed.track.enable", false);
        if (bcfClz == null) {
            WeedConfig.onExecuteAft(cmd -> {
                if (cmd.isLog < 0) {
                    return;
                }
                if (isDebugMode) {
                    if (isWeedStyle2) {
                        System.out.println(cmd.toSqlString());
                    } else {
                        System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                    }
                }
                WaterClient.Track.trackOfPerformance(this.service_name(), cmd, 1000L);
                if (isTrackEnable) {
                    String tag = cmd.context.schema();
                    if (TextUtils.isEmpty((CharSequence)tag)) {
                        tag = "sql";
                    }
                    WaterClient.Track.track(this.service_name() + "_sql", tag, cmd.text, cmd.timespan());
                }
            });
        } else {
            WeedConfig.onExecuteAft(cmd -> {
                if (cmd.isLog < 0) {
                    return;
                }
                if (isDebugMode) {
                    if (isWeedStyle2) {
                        System.out.println(cmd.text2());
                    } else {
                        System.out.println(cmd.text + "\n" + ONode.stringify((Object)cmd.paramMap()));
                    }
                }
                Context context = Context.current();
                String sqlUp = cmd.text.toUpperCase();
                String chkUp = "User_Id=? AND Pass_Wd=? AND Is_Disabled=0".toUpperCase();
                if (cmd.timespan() > 2000L || cmd.isLog > 0 || sqlUp.indexOf("INSERT INTO ") >= 0 || sqlUp.indexOf("UPDATE ") >= 0 || sqlUp.indexOf("DELETE ") >= 0 || sqlUp.indexOf(chkUp) >= 0) {
                    WaterClient.Track.trackOfBehavior(this.service_name(), cmd, context.userAgent(), context.path(), this.user_puid() + "." + this.user_name(), context.realIp());
                }
                if (isTrackEnable) {
                    String tag = cmd.context.schema();
                    if (TextUtils.isEmpty((CharSequence)tag)) {
                        tag = "sql";
                    }
                    WaterClient.Track.track(this.service_name() + "_sql", tag, cmd.text, cmd.timespan());
                }
            });
        }
    }

    private String service_name() {
        return Solon.cfg().appName();
    }

    private int user_puid() {
        if (Context.current() != null) {
            String tmp = (String)Context.current().attr("user_puid", (Object)"0");
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    private String user_name() {
        if (Context.current() != null) {
            return (String)Context.current().attr("user_name", null);
        }
        return null;
    }
}

