/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.generator.xml;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.noear.weed.generator.utils.IOUtils;
import org.noear.weed.generator.utils.StringUtils;
import org.noear.weed.generator.xml.JavaCodeBlock;
import org.noear.weed.generator.xml.TypeBlock;
import org.noear.weed.generator.xml.XmlSqlBlock;
import org.noear.weed.generator.xml.XmlSqlVar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSqlMapperGenerator {
    private static DocumentBuilderFactory dbf = null;
    private static DocumentBuilder db = null;

    public static void generate(File baseDir, File sourceDir) {
        try {
            String path = baseDir.getAbsolutePath() + "/src/main/resources/weed3";
            File dic = new File(path);
            if (dic.isDirectory()) {
                File[] tmps;
                for (File tmp : tmps = dic.listFiles()) {
                    if (!tmp.getName().endsWith(".xml")) continue;
                    XmlSqlMapperGenerator.generateFile(sourceDir, tmp);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void generateFile(File sourceDir, File xmlFile) throws Exception {
        JavaCodeBlock block = XmlSqlMapperGenerator.parse(xmlFile);
        if (block == null) {
            return;
        }
        String dic_path = sourceDir.getAbsolutePath() + "/" + block._namespace.replace(".", "/");
        new File(dic_path).mkdirs();
        String file_path = dic_path + "/" + block._classname + ".java";
        File file = new File(file_path);
        if (!file.exists()) {
            file.createNewFile();
        }
        IOUtils.fileWrite(file, block._code);
        System.out.println("Generated : " + file.getAbsolutePath());
    }

    public static JavaCodeBlock parse(File xmlFile) throws Exception {
        if (xmlFile == null) {
            return null;
        }
        Document doc = XmlSqlMapperGenerator.parseDoc(xmlFile);
        Element nm = doc.getDocumentElement();
        HashSet<String> importSet = new HashSet<String>();
        String namespace = XmlSqlMapperGenerator.attr(nm, "namespace");
        String db = XmlSqlMapperGenerator.attr(nm, ":db");
        String classname = xmlFile.getName().split("\\.")[0];
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(namespace).append(";\n\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.sql.SQLException;\n");
        sb.append("import java.util.*;\n\n");
        sb.append("import org.noear.weed.DataItem;\n");
        sb.append("import org.noear.weed.DataList;\n");
        sb.append("import org.noear.weed.xml.Namespace;\n\n");
        StringBuilder sb2 = new StringBuilder();
        HashMap<String, Node> node_map = new HashMap<String, Node>();
        NodeList sql_list = doc.getElementsByTagName("sql");
        int len = sql_list.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = sql_list.item(i);
            String id = XmlSqlMapperGenerator.attr(n, "id");
            if (id == null) continue;
            node_map.put(id, n);
        }
        sb2.append("@Namespace(\"").append(namespace).append("\")\n");
        sb2.append("public interface ").append(classname).append("{");
        StringBuilder sb_tmp = new StringBuilder();
        int len2 = sql_list.getLength();
        for (int i = 0; i < len2; ++i) {
            Node n = sql_list.item(i);
            XmlSqlBlock block = XmlSqlMapperGenerator.parseSqlNode(node_map, sb_tmp, n, namespace, db, classname);
            XmlSqlMapperGenerator.writerBlock(sb2, block);
            if (i < len2 - 1) {
                sb2.append("\n");
            }
            importSet.addAll(block.impTypeSet);
        }
        sb2.append("\n}\n");
        for (String type : importSet.stream().sorted().collect(Collectors.toList())) {
            sb.append("import ").append(type).append(";\n");
        }
        if (importSet.size() > 0) {
            XmlSqlMapperGenerator.newLine(sb, 0);
        }
        sb.append((CharSequence)sb2);
        node_map.clear();
        JavaCodeBlock codeBlock = new JavaCodeBlock();
        codeBlock._namespace = namespace;
        codeBlock._classname = classname;
        codeBlock._code = sb.toString();
        return codeBlock;
    }

    private static void writerBlock(StringBuilder sb, XmlSqlBlock block) {
        if (block._note != null && block._note.length() > 0) {
            XmlSqlMapperGenerator.newLine(sb, 2).append("//").append(block._note);
        }
        XmlSqlMapperGenerator.newLine(sb, 2);
        if (StringUtils.isEmpty(block._return)) {
            sb.append("void");
        } else if ("Map".equals(block._return)) {
            sb.append("Map<String,Object>");
        } else if ("MapList".equals(block._return)) {
            sb.append("List<Map<String,Object>>");
        } else {
            sb.append(block._return);
        }
        sb.append(" ").append(block._id).append("(");
        for (String k : block.varMap.keySet()) {
            XmlSqlVar v = block.varMap.get(k);
            sb.append(v.type).append(" ").append(v.name).append(", ");
        }
        if (block.varMap.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(") throws Exception;");
    }

    private static XmlSqlBlock parseSqlNode(Map<String, Node> nodeMap, StringBuilder sb, Node n, String namespace, String db, String classname) {
        String db_tmp;
        int depth = 1;
        XmlSqlBlock dblock = new XmlSqlBlock();
        dblock.__nodeMap = nodeMap;
        dblock._namespace = namespace;
        dblock._classname = classname;
        dblock._classcode = sb;
        dblock._id = XmlSqlMapperGenerator.attr(n, "id");
        dblock._note = XmlSqlMapperGenerator.attr(n, ":note");
        dblock._declare = XmlSqlMapperGenerator.attr(n, ":declare");
        dblock._return = XmlSqlMapperGenerator.attr(n, ":return");
        if (dblock._return != null) {
            TypeBlock tBlock = new TypeBlock(dblock._return);
            dblock._return = tBlock.newType;
            if (tBlock.impType != null) {
                dblock.impTypeSet.add(tBlock.impType);
            }
        }
        dblock._db = StringUtils.isEmpty(db_tmp = XmlSqlMapperGenerator.attr(n, ":db")) ? db : db_tmp;
        dblock._caching = XmlSqlMapperGenerator.attr(n, ":caching");
        dblock._usingCache = XmlSqlMapperGenerator.attr(n, ":usingCache");
        dblock._cacheTag = XmlSqlMapperGenerator.attr(n, ":cacheTag");
        dblock._cacheClear = XmlSqlMapperGenerator.attr(n, ":cacheClear");
        XmlSqlMapperGenerator._parseDeclare(dblock);
        XmlSqlMapperGenerator.newLine(sb, depth).append("public SQLBuilder ").append(dblock._id).append("(Map map){");
        StringBuilder sb2 = new StringBuilder();
        XmlSqlMapperGenerator.newLine(sb2, depth + 1).append("SQLBuilder sb = new SQLBuilder();\n");
        XmlSqlMapperGenerator._parseNodeList(n.getChildNodes(), sb2, dblock, depth + 1);
        int var_num = 0;
        for (XmlSqlVar dv : dblock.varMap.values()) {
            if (dv.type == null || dv.type.length() <= 0) continue;
            ++var_num;
            XmlSqlMapperGenerator.newLine(sb, depth + 1).append(dv.type).append(" ").append(dv.name).append("=").append("(").append(dv.type).append(")map.get(\"").append(dv.name).append("\");");
        }
        if (var_num > 0) {
            sb.append("\n");
        }
        sb.append((CharSequence)sb2);
        sb.append("\n");
        XmlSqlMapperGenerator.newLine(sb, depth + 1).append("return sb;");
        XmlSqlMapperGenerator.newLine(sb, depth).append("}\n");
        dblock.__nodeMap = null;
        return dblock;
    }

    private static void _parseDeclare(XmlSqlBlock dblock) {
        if (dblock._declare == null) {
            return;
        }
        String[] ss = dblock._declare.split(",");
        int len = ss.length;
        for (int i = 0; i < len; ++i) {
            String tmp = ss[i].trim();
            if (tmp.indexOf(":") <= 0 || tmp.length() <= 3) continue;
            String[] kv = tmp.split(":");
            XmlSqlVar dv = new XmlSqlVar(tmp, kv[0].trim(), kv[1].trim());
            dblock.varPut(dv);
        }
    }

    private static void _parseNodeList(NodeList nl, StringBuilder sb, XmlSqlBlock dblock, int depth) {
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            XmlSqlMapperGenerator._parseNode(n, sb, dblock, depth);
        }
    }

    private static void _parseNode(Node n, StringBuilder sb, XmlSqlBlock dblock, int depth) {
        String text;
        short type = n.getNodeType();
        if ((type == 3 || type == 4) && (text = n.getTextContent().trim()).length() > 0) {
            XmlSqlMapperGenerator.newLine(sb, depth).append("sb.append(");
            XmlSqlMapperGenerator.parseTxt(sb, dblock, text);
            sb.append(");");
        }
        if (type == 1) {
            String tagName = n.getNodeName();
            if ("if".equals(tagName)) {
                XmlSqlMapperGenerator.parseIfNode(sb, dblock, n, depth);
                return;
            }
            if ("for".equals(tagName)) {
                XmlSqlMapperGenerator.parseForNode(sb, dblock, n, depth);
                return;
            }
            if ("ref".equals(tagName)) {
                XmlSqlMapperGenerator.parseRefNode(sb, dblock, n, depth);
                return;
            }
            XmlSqlMapperGenerator._parseNodeList(n.getChildNodes(), sb, dblock, depth);
        }
    }

    private static void parseIfNode(StringBuilder sb, XmlSqlBlock dblock, Node n, int depth) {
        String _test = XmlSqlMapperGenerator.attr(n, "test");
        XmlSqlMapperGenerator.newLine(sb, depth).append("if(").append(_test).append("){");
        XmlSqlMapperGenerator._parseNodeList(n.getChildNodes(), sb, dblock, depth + 1);
        XmlSqlMapperGenerator.newLine(sb, depth).append("}");
    }

    private static void parseRefNode(StringBuilder sb, XmlSqlBlock dblock, Node n, int depth) {
        String _sql_id = XmlSqlMapperGenerator.attr(n, "sql");
        if (!StringUtils.isEmpty(_sql_id)) {
            Node ref_n = dblock.__nodeMap.get(_sql_id);
            if (ref_n == null) {
                throw new RuntimeException("sql node @" + _sql_id + " can't find");
            }
            XmlSqlMapperGenerator._parseNode(ref_n, sb, dblock, depth);
        }
    }

    private static void parseForNode(StringBuilder sb, XmlSqlBlock dblock, Node n, int depth) {
        String _var_str = XmlSqlMapperGenerator.attr(n, "var").trim();
        if (_var_str.indexOf(":") < 0 || _var_str.length() < 3) {
            StringBuilder eb = new StringBuilder();
            eb.append(dblock._namespace).append("/").append(dblock._id).append("::").append("for/var(").append(_var_str).append(") must declare the type");
            throw new RuntimeException(eb.toString());
        }
        String[] kv = _var_str.split(":");
        XmlSqlVar _var = new XmlSqlVar(_var_str, kv[0].trim(), kv[1].trim());
        String _items = XmlSqlMapperGenerator.attr(n, "items");
        XmlSqlMapperGenerator.newLine(sb, depth).append("for(").append(_var.type).append(" ").append(_var.name).append(" : ").append(_items).append("){");
        XmlSqlMapperGenerator._parseNodeList(n.getChildNodes(), sb, dblock, depth + 1);
        XmlSqlVar _itemsVar = new XmlSqlVar(_items, _items, "Collection<" + _var.type + ">");
        dblock.varPut(_itemsVar);
        XmlSqlMapperGenerator.newLine(sb, depth).append("}");
    }

    private static StringBuilder newLine(StringBuilder sb, int depth) {
        sb.append("\n");
        while (depth > 0) {
            sb.append("  ");
            --depth;
        }
        return sb;
    }

    private static String attr(Node n, String name) {
        Node tmp = n.getAttributes().getNamedItem(name);
        if (tmp == null) {
            return null;
        }
        return tmp.getNodeValue();
    }

    private static Document parseDoc(File xmlFile) throws Exception {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
        }
        return db.parse(xmlFile);
    }

    private static void parseTxt(StringBuilder sb, XmlSqlBlock dblock, String txt0) {
        String[] kv;
        Object dv;
        String txt2 = null;
        LinkedHashMap<String, Object> tmpList = new LinkedHashMap<String, Object>();
        txt2 = txt0.replace("\n", " ").replace("\"", "\\\"");
        tmpList.clear();
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher m = pattern.matcher(txt2);
        while (m.find()) {
            dv = new XmlSqlVar();
            ((XmlSqlVar)dv).mark = m.group(0);
            ((XmlSqlVar)dv).name = m.group(1).trim().replace("[", "<").replace("]", ">");
            if (((XmlSqlVar)dv).name.indexOf(":") > 0) {
                kv = ((XmlSqlVar)dv).name.split(":");
                ((XmlSqlVar)dv).name = kv[0].trim();
                ((XmlSqlVar)dv).type = kv[1].trim();
            }
            tmpList.put(((XmlSqlVar)dv).name, dv);
            dblock.varPut((XmlSqlVar)dv);
        }
        for (XmlSqlVar dv2 : tmpList.values()) {
            txt2 = txt2.replace(dv2.mark, "\"+" + dv2.name + "+\"");
        }
        tmpList.clear();
        pattern = Pattern.compile("@\\{(.+?)\\}");
        m = pattern.matcher(txt2);
        while (m.find()) {
            dv = new XmlSqlVar();
            ((XmlSqlVar)dv).mark = m.group(0);
            ((XmlSqlVar)dv).name = m.group(1).trim().replace("[", "<").replace("]", ">");
            if (((XmlSqlVar)dv).name.indexOf(":") > 0) {
                kv = ((XmlSqlVar)dv).name.split(":");
                ((XmlSqlVar)dv).name = kv[0].trim();
                ((XmlSqlVar)dv).type = kv[1].trim();
            }
            tmpList.put(((XmlSqlVar)dv).name, dv);
            dblock.varPut((XmlSqlVar)dv);
        }
        for (XmlSqlVar dv2 : tmpList.values()) {
            if (dv2.type != null && dv2.type.indexOf(">") > 0) {
                txt2 = txt2.replace(dv2.mark, "?...");
                continue;
            }
            txt2 = txt2.replace(dv2.mark, "?");
        }
        sb.append("\"").append(txt2).append(" \"");
        for (String k : tmpList.keySet()) {
            XmlSqlVar v = (XmlSqlVar)tmpList.get(k);
            sb.append(",").append(v.name);
        }
    }
}

