/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.generator.entity;

import java.io.File;
import org.noear.weed.DbContext;
import org.noear.weed.generator.entity.EntityGenerator;
import org.noear.weed.generator.entity.MapperGenerator;
import org.noear.weed.generator.entity.XmlSourceBlock;
import org.noear.weed.generator.utils.StringUtils;
import org.noear.weed.generator.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEntityGenerator {
    public static void generate(File baseDir, File sourceDir) {
        try {
            String path = baseDir.getAbsolutePath() + "/src/main/resources/weed3-generator.xml";
            File file = new File(path);
            if (!file.exists()) {
                System.err.println("No configuration file: weed3-generator.xml");
            }
            XmlEntityGenerator.generate0(file, sourceDir);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void generate0(File file, File sourceDir) throws Exception {
        Document doc = XmlUtils.parseDoc(file);
        Element nm = doc.getDocumentElement();
        NodeList nl = nm.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n1 = nl.item(i);
            if (n1.getNodeType() != 1) continue;
            XmlEntityGenerator.generateJavaFile(n1, sourceDir);
        }
    }

    private static void generateJavaFile(Node n1, File sourceDir) throws Exception {
        if (!"source".equals(n1.getNodeName())) {
            return;
        }
        Element e1 = (Element)n1;
        XmlSourceBlock source = new XmlSourceBlock();
        source.schema = XmlUtils.attr(n1, "schema");
        source.url = XmlUtils.attr(n1, "url");
        source.username = XmlUtils.attr(n1, "username");
        source.password = XmlUtils.attr(n1, "password");
        source.driverClassName = XmlUtils.attr(n1, "driverClassName");
        NodeList n2l = n1.getChildNodes();
        int len = n2l.getLength();
        for (int i = 0; i < len; ++i) {
            Node n2 = n2l.item(i);
            if (n2.getNodeType() != 1) continue;
            if ("entity".equals(n2.getNodeName())) {
                source.entity_basePackage = XmlUtils.attr(n2, "basePackage");
                source.entity_entityName = XmlUtils.attr(n2, "entityName");
                source.entity_fieldStyle = XmlUtils.attr(n2, "fieldStyle");
            }
            if ("dao".equals(n2.getNodeName())) {
                source.dao_basePackage = XmlUtils.attr(n2, "basePackage");
                source.dao_entityName = XmlUtils.attr(n2, "entityName");
                source.dao_db = XmlUtils.attr(n2, "db");
            }
            if (!"service".equals(n2.getNodeName())) continue;
            source.service_basePackage = XmlUtils.attr(n2, "basePackage");
            source.service_entityName = XmlUtils.attr(n2, "entityName");
        }
        if (StringUtils.isEmpty(source.entity_entityName)) {
            source.entity_entityName = "${table}";
        }
        if (StringUtils.isEmpty(source.dao_entityName)) {
            source.dao_entityName = source.entity_entityName;
        }
        if (StringUtils.isEmpty(source.service_entityName)) {
            source.service_entityName = source.entity_entityName;
        }
        if (!StringUtils.isEmpty(source.driverClassName)) {
            Class.forName(source.driverClassName);
        }
        DbContext db = new DbContext(source.schema, source.url, source.username, source.password);
        XmlEntityGenerator.tryGenerateEntityFiles(db, source, sourceDir);
        XmlEntityGenerator.tryGenerateDaoFiles(db, source, sourceDir);
    }

    private static void tryGenerateEntityFiles(DbContext db, XmlSourceBlock source, File sourceDir) {
        if (StringUtils.isEmpty(source.entity_basePackage)) {
            return;
        }
        String packDir = sourceDir.getAbsolutePath() + "/" + source.entity_basePackage.replace(".", "/") + "/";
        try {
            EntityGenerator.createByDb(packDir, source.entity_basePackage, db, source.entity_entityName, "camel".equals(source.entity_fieldStyle));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void tryGenerateDaoFiles(DbContext db, XmlSourceBlock source, File sourceDir) {
        if (StringUtils.isEmpty(source.dao_basePackage)) {
            return;
        }
        String packDir = sourceDir.getAbsolutePath() + "/" + source.dao_basePackage.replace(".", "/") + "/";
        try {
            MapperGenerator.createByDb(source.entity_basePackage, packDir, source.dao_basePackage, db, source.dao_entityName, source.dao_db);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

