/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.generator.entity;

import java.util.HashMap;
import java.util.Map;
import org.noear.weed.generator.entity.SqlTypeEntity;
import org.noear.weed.wrap.ColumnWrap;

class SqlTypeMap {
    public static Map<Integer, SqlTypeEntity> mapping = new HashMap<Integer, SqlTypeEntity>();
    public static final String NUMERIC = "NUMERIC";

    SqlTypeMap() {
    }

    private static void put(Integer sqlType, String javaType, String javaType2) {
        mapping.put(sqlType, new SqlTypeEntity(sqlType, javaType, javaType2));
    }

    public static String getType(ColumnWrap cw, boolean style2) {
        SqlTypeEntity type = SqlTypeMap.getType(cw.getType(), cw.getSize(), cw.getDigit());
        if (type == null) {
            return "Unknown";
        }
        if (style2) {
            return type.javaType2;
        }
        return type.javaType;
    }

    private static SqlTypeEntity getType(Integer sqlType, Integer size, Integer digit) {
        SqlTypeEntity type = mapping.get(sqlType);
        if (type != null && type.javaType.equals(NUMERIC)) {
            type = digit != null && digit != 0 ? mapping.get(8) : (size >= 9 ? mapping.get(-5) : mapping.get(4));
        }
        return type;
    }

    static {
        SqlTypeMap.put(-5, "Long", "long");
        SqlTypeMap.put(-2, "byte[]", "byte[]");
        SqlTypeMap.put(-7, "Boolean", "boolean");
        SqlTypeMap.put(2004, "byte[]", "byte[]");
        SqlTypeMap.put(16, "Boolean", "boolean");
        SqlTypeMap.put(1, "String", "String");
        SqlTypeMap.put(2005, "String", "String");
        SqlTypeMap.put(91, "Date", "Date");
        SqlTypeMap.put(3, "BigDecimal", "BigDecimal");
        SqlTypeMap.put(8, "Double", "double");
        SqlTypeMap.put(6, "Float", "float");
        SqlTypeMap.put(4, "Integer", "int");
        SqlTypeMap.put(2000, "Object", "Object");
        SqlTypeMap.put(-16, "String", "String");
        SqlTypeMap.put(-4, "byte[]", "byte[]");
        SqlTypeMap.put(-1, "String", "String");
        SqlTypeMap.put(-15, "String", "String");
        SqlTypeMap.put(-9, "String", "String");
        SqlTypeMap.put(2011, "String", "String");
        SqlTypeMap.put(2, NUMERIC, NUMERIC);
        SqlTypeMap.put(1111, "Object", "Object");
        SqlTypeMap.put(7, "Float", "float");
        SqlTypeMap.put(5, "Integer", "int");
        SqlTypeMap.put(2009, "SQLXML", "SQLXML");
        SqlTypeMap.put(92, "Date", "Date");
        SqlTypeMap.put(93, "Date", "Date");
        SqlTypeMap.put(-6, "Integer", "int");
        SqlTypeMap.put(-3, "byte[]", "byte[]");
        SqlTypeMap.put(12, "String", "String");
        SqlTypeMap.put(2014, "Date", "Date");
        SqlTypeMap.put(2013, "Date", "Date");
    }
}

