/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.solon.plugin.tran;

import org.noear.solon.XUtil;
import org.noear.solon.annotation.XTran;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Tran;
import org.noear.solon.core.TranFactory;
import org.noear.solon.core.TranPolicy;
import org.noear.weed.DbContext;
import org.noear.weed.solon.plugin.tran.TranGroupImp;
import org.noear.weed.solon.plugin.tran.TranImp;
import org.noear.weed.solon.plugin.tran.TranMandatoryImp;
import org.noear.weed.solon.plugin.tran.TranNeverImp;
import org.noear.weed.solon.plugin.tran.TranNewImp;
import org.noear.weed.solon.plugin.tran.TranNotImp;

public final class TranFactoryImp
implements TranFactory {
    private static TranFactory _singleton;
    private Tran tranNever = new TranNeverImp();
    private Tran tranMandatory = new TranMandatoryImp();
    private Tran tranNot = new TranNotImp();

    public static TranFactory singleton() {
        if (_singleton == null) {
            _singleton = new TranFactoryImp();
        }
        return _singleton;
    }

    private TranFactoryImp() {
    }

    public Tran create(XTran anno) {
        if (anno.group()) {
            return new TranGroupImp();
        }
        if (anno.policy() == TranPolicy.exclude) {
            return this.tranNot;
        }
        if (anno.policy() == TranPolicy.never) {
            return this.tranNever;
        }
        if (anno.policy() == TranPolicy.mandatory) {
            return this.tranMandatory;
        }
        DbContext tmp = null;
        tmp = XUtil.isEmpty((String)anno.value()) ? (DbContext)Aop.get(DbContext.class) : (DbContext)Aop.get((String)anno.value());
        if (tmp == null) {
            throw new RuntimeException("@XTran annotation failed");
        }
        if (anno.policy() == TranPolicy.requires_new || anno.policy() == TranPolicy.nested) {
            return new TranNewImp(tmp);
        }
        return new TranImp(tmp);
    }

    public Tran createNot() {
        return this.tranNot;
    }
}

