/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.cache.ehcache;

import java.util.concurrent.TimeUnit;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.noear.weed.cache.ICacheServiceEx;
import org.noear.weed.utils.EncryptUtils;

public class EhCache
implements ICacheServiceEx {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private Cache<String, Object> _cache = null;

    public EhCache(String keyHeader, int defSeconds) {
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(1000L, (ResourceUnit)EntryUnit.ENTRIES).offheap(100L, MemoryUnit.MB).disk(500L, MemoryUnit.MB, false)).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)defSeconds, (TimeUnit)TimeUnit.SECONDS))).withExpiry(Expirations.timeToIdleExpiration((Duration)Duration.of((long)60L, (TimeUnit)TimeUnit.SECONDS))).build();
        CacheManager manager = CacheManagerBuilder.newCacheManagerBuilder().withCache("defaultCache", cacheConfiguration).build(true);
        this._cache = manager.getCache("defaultCache", String.class, Object.class);
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
    }

    public void store(String key, Object obj, int seconds) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                this._cache.put((Object)newKey, obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Object get(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                return this._cache.get((Object)newKey);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void remove(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            this._cache.remove((Object)newKey);
        }
    }

    public int getDefalutSeconds() {
        return this._defaultSeconds;
    }

    public String getCacheKeyHead() {
        return this._cacheKeyHead;
    }

    private String newKey(String key) {
        return this._cacheKeyHead + "$" + EncryptUtils.md5((String)key);
    }
}

