/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.render.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import org.noear.weed.IRender;
import org.noear.weed.utils.IOUtils;

public class SQLFreemarkerRender
implements IRender {
    private static SQLFreemarkerRender _global;
    Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
    private String _baseUri = "/weed3/";

    public static SQLFreemarkerRender global() {
        if (_global == null) {
            _global = new SQLFreemarkerRender();
        }
        return _global;
    }

    public SQLFreemarkerRender() {
        boolean isDebugMode = "1".equals(System.getProperty("debug"));
        if (isDebugMode) {
            this.forRelease();
        } else {
            this.forDebug();
        }
        this.cfg.setNumberFormat("#");
        this.cfg.setDefaultEncoding("utf-8");
    }

    private void forDebug() {
        String dirroot = IOUtils.getResource((String)"/").toString().replace("target/classes/", "");
        String dir_str = dirroot + "src/main/resources" + this._baseUri;
        File dir = new File(URI.create(dir_str));
        if (!dir.exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir.exists()) {
                this.cfg.setDirectoryForTemplateLoading(dir);
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void forRelease() {
        try {
            this.cfg.setClassForTemplateLoading(this.getClass(), this._baseUri);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.cfg.setCacheStorage((CacheStorage)new MruCacheStorage(0, Integer.MAX_VALUE));
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.cfg.setSharedVariable(name, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String render(String path, Map<String, Object> args) throws Throwable {
        if (path == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        Template template = this.cfg.getTemplate(path, "utf-8");
        template.process(args, (Writer)writer);
        return writer.toString();
    }
}

