/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.render.velocity;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.noear.weed.IRender;
import org.noear.weed.utils.IOUtils;

public class SQLVelocityRender
implements IRender {
    private static SQLVelocityRender _global;
    private VelocityEngine velocity = new VelocityEngine();
    private Map<String, Object> _sharedVariable = new HashMap<String, Object>();
    private String _baseUri = "/weed3/";

    public static SQLVelocityRender global() {
        if (_global == null) {
            _global = new SQLVelocityRender();
        }
        return _global;
    }

    public SQLVelocityRender() {
        boolean isDebugMode = "1".equals(System.getProperty("debug"));
        if (isDebugMode) {
            this.forDebug();
        } else {
            this.forRelease();
        }
        this.velocity.setProperty("UTF-8", (Object)this.getEncoding());
        this.velocity.setProperty("input.encoding", (Object)this.getEncoding());
        this.velocity.init();
    }

    private void forDebug() {
        String dirroot = IOUtils.getResource((String)"/").toString().replace("target/classes/", "");
        String dir_str = dirroot + "src/main/resources" + this._baseUri;
        File dir = new File(URI.create(dir_str));
        if (!dir.exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir.exists()) {
                this.velocity.setProperty("file.resource.loader.path", (Object)(dir.getAbsolutePath() + File.separatorChar));
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void forRelease() {
        String root_path = IOUtils.getResource((String)this._baseUri).getPath();
        this.velocity.setProperty("file.resource.loader.cache", (Object)true);
        this.velocity.setProperty("file.resource.loader.path", (Object)root_path);
    }

    public void loadDirective(Object obj) {
        this.velocity.loadDirective(obj.getClass().getName());
    }

    public void setSharedVariable(String key, Object obj) {
        this._sharedVariable.put(key, obj);
    }

    public String getEncoding() {
        return "utf-8";
    }

    public String render(String path, Map<String, Object> args) throws Throwable {
        Template t = this.velocity.getTemplate(path, this.getEncoding());
        VelocityContext vc = new VelocityContext(args);
        this._sharedVariable.forEach((k, v) -> vc.put(k, v));
        StringWriter writer = new StringWriter();
        t.merge((Context)vc, (Writer)writer);
        return writer.toString();
    }
}

