/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.template.beetl;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.noear.weed.IRender;
import org.noear.weed.utils.IOUtils;

public class SQLBeetlRender
implements IRender {
    private static SQLBeetlRender _global;
    Configuration cfg;
    GroupTemplate gt;
    private String _baseUri;

    public static SQLBeetlRender global() {
        if (_global == null) {
            _global = new SQLBeetlRender();
        }
        return _global;
    }

    public SQLBeetlRender() {
        block8: {
            this.cfg = null;
            this.gt = null;
            this._baseUri = "/weed3/";
            try {
                this.cfg = Configuration.defaultConfiguration();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.cfg.setStatementStart("--");
            this.cfg.setStatementEnd(null);
            this.cfg.setStatementStart2("#");
            this.cfg.setStatementEnd2(null);
            this.cfg.setPlaceholderStart("${");
            this.cfg.setPlaceholderEnd("}");
            boolean isDebugMode = "1".equals(System.getProperty("debug"));
            if (isDebugMode) {
                String dirroot = IOUtils.getResource((String)"/").toString().replace("target/classes/", "");
                String dir_str = dirroot + "src/main/resources" + this._baseUri;
                File dir = new File(URI.create(dir_str));
                if (!dir.exists()) {
                    dir_str = dirroot + "src/main/webapp" + this._baseUri;
                    dir = new File(URI.create(dir_str));
                }
                try {
                    if (dir.exists()) {
                        FileResourceLoader loader = new FileResourceLoader(dir.getAbsolutePath(), "utf-8");
                        this.gt = new GroupTemplate((ResourceLoader)loader, this.cfg);
                        break block8;
                    }
                    this.initForRuntime();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.initForRuntime();
            }
        }
    }

    private void initForRuntime() {
        try {
            ClasspathResourceLoader loader = new ClasspathResourceLoader(this.getClass().getClassLoader(), this._baseUri);
            this.gt = new GroupTemplate((ResourceLoader)loader, this.cfg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void registerTag(String name, Class<?> tag) {
        try {
            this.gt.registerTag(name, tag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.gt.getSharedVars().put(name, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String render(String path, Map<String, Object> args) throws Exception {
        if (path == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        Template template = this.gt.getTemplate(path);
        template.binding(args);
        template.renderTo((Writer)writer);
        return writer.toString();
    }
}

