/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.tool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.noear.weed.DbContext;
import org.noear.weed.utils.StringUtils;
import org.noear.weed.wrap.TableWrap;

public class MapperGenerator {
    public static void createByDb(String modelPck, String packDir, String packName, DbContext db, String clzNameTml) throws IOException {
        File dir = new File(packDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        StringBuilder nameSb = new StringBuilder();
        for (TableWrap tw : db.dbTables()) {
            if (clzNameTml == null) {
                clzNameTml = "${table}";
            }
            nameSb.setLength(0);
            String tmp = clzNameTml.replace("${table}", tw.getName());
            for (String s : tmp.split("_")) {
                if (s.length() > 0) {
                    nameSb.append(s.substring(0, 1).toUpperCase());
                }
                if (s.length() <= 1) continue;
                nameSb.append(s.substring(1));
            }
            String clzName = nameSb.toString();
            String code = MapperGenerator.buildByTable(modelPck, packName, tw, clzName);
            String fileFullName = packDir + clzName + "Mapper.java";
            File file = new File(fileFullName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter fw = new FileWriter(file);
            Throwable throwable = null;
            try {
                fw.write(code);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fw == null) continue;
                if (throwable != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fw.close();
            }
        }
    }

    public static void createByDb(String modelPck, String packDir, String packName, DbContext db) throws IOException {
        MapperGenerator.createByDb(modelPck, packDir, packName, db, "${table}");
    }

    public static void createByDb(String modelPck, String packName, DbContext db) throws IOException {
        if (packName == null) {
            throw new RuntimeException("Please enter @packName");
        }
        String classesDir = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        int targetIdx = classesDir.indexOf("/target/");
        String javaDir = classesDir.substring(0, targetIdx) + "/src/main/java/";
        String packDir = javaDir + packName.replace(".", "/") + "/";
        MapperGenerator.createByDb(modelPck, packDir, packName, db);
    }

    public static String buildByTable(String modelPck, String packName, TableWrap tw, String clzName) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)packName)) {
            sb.append("package ").append(packName).append(";").append("\n\n");
        }
        sb.append("import ").append(modelPck).append(".").append(clzName).append(";\n");
        sb.append("import org.noear.weed.BaseMapper;").append("\n\n");
        if (!StringUtils.isEmpty((String)tw.getRemarks())) {
            sb.append("/** ").append(tw.getRemarks()).append(" Mapper */\n");
        }
        sb.append("public interface ").append(clzName).append("Mapper extends BaseMapper<").append(clzName).append("> {").append("\n");
        sb.append("}");
        return sb.toString();
    }
}

