/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.noear.wood.utils.StringUtils;
import org.noear.wood.xml.CompilerUtil;
import org.noear.wood.xml.XmlSqlBlock;
import org.noear.wood.xml.XmlSqlFactory;
import org.noear.wood.xml.XmlSqlVar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlSqlCompiler {
    private static DocumentBuilderFactory docBf = null;
    private static DocumentBuilder docB = null;

    public static String parse(URL xmlFile) throws Exception {
        Node n;
        int i;
        if (xmlFile == null) {
            return null;
        }
        Document doc = XmlSqlCompiler.parseDoc(xmlFile);
        Element nm = doc.getDocumentElement();
        String namespace = XmlSqlCompiler.attr(nm, "namespace");
        String _import = XmlSqlCompiler.attr(nm, "import");
        int sepindex = namespace.lastIndexOf(46);
        String packagename = namespace.substring(0, sepindex);
        String classname = namespace.substring(sepindex + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(packagename).append(";\n\n");
        sb.append("import java.math.*;\n");
        sb.append("import java.util.*;\n");
        sb.append("import org.noear.wood.utils.*;\n");
        sb.append("import org.noear.wood.SQLBuilder;\n");
        sb.append("import org.noear.wood.xml.XmlSqlFactory;\n");
        if (!StringUtils.isEmpty((String)_import)) {
            String[] ss;
            for (String s : ss = _import.split(";")) {
                if (s.length() <= 2) continue;
                sb.append("import ").append(s).append(";\n");
            }
        }
        sb.append("\n");
        HashMap<String, Node> node_map = new HashMap<String, Node>();
        NodeList sql_list = doc.getElementsByTagName("sql");
        int len = sql_list.getLength();
        for (i = 0; i < len; ++i) {
            n = sql_list.item(i);
            String id = XmlSqlCompiler.attr(n, "id");
            if (id == null) continue;
            node_map.put(id, n);
        }
        sb.append("public class ").append(classname).append("{");
        XmlSqlCompiler.newLine(sb, 1).append("private static final String _namespace=\"").append(namespace).append("\";");
        XmlSqlCompiler.newLine(sb, 1).append("public ").append(classname).append("(){");
        len = sql_list.getLength();
        for (i = 0; i < len; ++i) {
            n = sql_list.item(i);
            String id_str = XmlSqlCompiler.attr(n, "id");
            if (id_str == null) continue;
            XmlSqlCompiler.newLine(sb, 2).append("XmlSqlFactory.register(_namespace + \".").append(id_str).append("\",").append("this::").append(id_str).append(");");
        }
        XmlSqlCompiler.newLine(sb, 1).append("}");
        len = sql_list.getLength();
        for (i = 0; i < len; ++i) {
            n = sql_list.item(i);
            XmlSqlCompiler.parseSqlNode(node_map, sb, n, _import, namespace, classname);
        }
        sb.append("}\n");
        node_map.clear();
        return sb.toString();
    }

    private static Document parseDoc(URL xmlFile) throws Exception {
        if (docBf == null) {
            docBf = DocumentBuilderFactory.newInstance();
            docBf.setValidating(false);
            docB = docBf.newDocumentBuilder();
            docB.setEntityResolver((publicId, systemId) -> {
                if (systemId.contains("wood-mapper.dtd")) {
                    InputStream dtdStream = XmlSqlBlock.class.getResourceAsStream("/org/noear/wood/xml/wood-mapper.dtd");
                    return new InputSource(dtdStream);
                }
                if (systemId.contains("wood-generator.dtd")) {
                    InputStream dtdStream = XmlSqlBlock.class.getResourceAsStream("/org/noear/wood/xml/wood-generator.dtd");
                    return new InputSource(dtdStream);
                }
                return null;
            });
        }
        return docB.parse(xmlFile.openStream());
    }

    private static void parseSqlNode(Map<String, Node> nodeMap, StringBuilder sb, Node n, String _import, String namespace, String classname) {
        int depth = 1;
        XmlSqlBlock dblock = new XmlSqlBlock();
        dblock.__nodeMap = nodeMap;
        if (_import != null) {
            for (String s : _import.split(";")) {
                dblock._import.add(s.trim());
            }
        }
        dblock._namespace = namespace;
        dblock._classname = classname;
        dblock._classcode = sb;
        dblock._id = XmlSqlCompiler.attr(n, "id");
        dblock._param = XmlSqlCompiler.attr(n, ":param");
        dblock._declare = XmlSqlCompiler.attr(n, ":declare");
        dblock._return = XmlSqlCompiler.attr(n, ":return");
        if (dblock._return != null && dblock._return.indexOf("[") > 0) {
            dblock._return = CompilerUtil.varTypeParse(dblock._return);
            int start = dblock._return.indexOf("<");
            int end = dblock._return.indexOf(">");
            if (start >= 0 && end > start) {
                dblock._return_item = dblock._return.substring(start + 1, end);
            }
        }
        dblock._caching = XmlSqlCompiler.attr(n, ":caching");
        dblock._usingCache = XmlSqlCompiler.attr(n, ":usingCache");
        dblock._cacheTag = XmlSqlCompiler.attr(n, ":cacheTag");
        dblock._cacheClear = XmlSqlCompiler.attr(n, ":cacheClear");
        XmlSqlCompiler._parseSqlDeclare(dblock);
        XmlSqlCompiler._parseSqlCachaTag(dblock);
        XmlSqlCompiler.newLine(sb, depth).append("public SQLBuilder ").append(dblock._id).append("(Map map) throws Exception{");
        StringBuilder sb2 = new StringBuilder();
        XmlSqlCompiler.newLine(sb2, depth + 1).append("SQLBuilder sb = new SQLBuilder();\n");
        XmlSqlCompiler._parseNodeList(n.getChildNodes(), "sb", sb2, dblock, depth + 1);
        int var_num = 0;
        for (XmlSqlVar dv : dblock.varList()) {
            ++var_num;
            if (dv.type != null && dv.type.length() > 0) {
                XmlSqlCompiler.newLine(sb, depth + 1).append(dv.type).append(" ").append(dv.name).append(" = ").append("(").append(dv.type).append(")map.get(\"").append(dv.name).append("\");");
                continue;
            }
            if (dv.name.indexOf(".") >= 0) continue;
            XmlSqlCompiler.newLine(sb, depth + 1).append("Object ").append(dv.name).append(" = ").append("map.get(\"").append(dv.name).append("\");");
        }
        if (var_num > 0) {
            sb.append("\n");
        }
        sb.append((CharSequence)sb2);
        if (dblock.tagMap.size() > 0) {
            sb.append("\n");
        }
        for (XmlSqlVar dv : dblock.tagMap.values()) {
            if (dv.name.indexOf(".") <= 0) continue;
            XmlSqlCompiler.newLine(sb, depth + 1).append("map.put(\"").append(dv.name).append("\", ").append(dv.name).append(");");
        }
        sb.append("\n");
        XmlSqlCompiler.newLine(sb, depth + 1).append("return sb;");
        XmlSqlCompiler.newLine(sb, depth).append("}\n");
        dblock.__nodeMap = null;
        String txt2 = dblock._texts.insert(0, "# ").toString().trim().toUpperCase();
        if (dblock._action == null && txt2.indexOf(" INSERT ") > 0) {
            dblock._action = "INSERT";
        }
        if (dblock._action == null && txt2.indexOf(" DELETE ") > 0) {
            dblock._action = "DELETE";
        }
        if (dblock._action == null && txt2.indexOf(" UPDATE ") > 0) {
            dblock._action = "UPDATE";
        }
        if (dblock._action == null && txt2.indexOf(" SELECT ") > 0) {
            dblock._action = "SELECT";
        }
        dblock._texts = null;
        String tmp = dblock._return_item;
        dblock._return_item = dblock.newType(dblock._return_item);
        dblock._return = dblock.newType(dblock._return);
        if (tmp != null && !tmp.equals(dblock._return_item)) {
            dblock._return = dblock._return.replace("<" + tmp + ">", "<" + dblock._return_item + ">");
        }
        XmlSqlFactory.register(namespace + "." + dblock._id, dblock);
    }

    private static void _parseSqlDeclare(XmlSqlBlock dblock) {
        XmlSqlVar dv;
        String[] kv;
        String tmp;
        int i;
        int len;
        String[] ss;
        if (dblock._param != null) {
            ss = dblock._param.split(",");
            len = ss.length;
            for (i = 0; i < len; ++i) {
                tmp = ss[i].trim();
                if (tmp.indexOf(":") <= 0 || tmp.length() <= 3) continue;
                kv = tmp.split(":");
                dv = new XmlSqlVar(tmp, kv[0].trim(), kv[1].trim());
                dblock.varPut(dv);
            }
        }
        if (dblock._declare != null) {
            ss = dblock._declare.split(",");
            len = ss.length;
            for (i = 0; i < len; ++i) {
                tmp = ss[i].trim();
                if (tmp.indexOf(":") <= 0 || tmp.length() <= 3) continue;
                kv = tmp.split(":");
                dv = new XmlSqlVar(tmp, kv[0].trim(), kv[1].trim());
                dblock.varPut(dv);
            }
        }
    }

    private static void _parseSqlCachaTag(XmlSqlBlock dblock) {
        XmlSqlVar dv;
        Matcher m;
        if (dblock._cacheClear != null) {
            m = XmlSqlVar.varRepExp.matcher(dblock._cacheClear);
            while (m.find()) {
                dv = XmlSqlCompiler.parseTxtVar(m);
                dv.label = 0;
                dblock.tagMap.put(dv.mark, dv);
            }
        }
        if (dblock._cacheTag != null) {
            m = XmlSqlVar.varRepExp.matcher(dblock._cacheTag);
            while (m.find()) {
                dv = XmlSqlCompiler.parseTxtVar(m);
                dv.label = 1;
                dblock.tagMap.put(dv.mark, dv);
            }
        }
    }

    private static void _parseNodeList(NodeList nl, String sqlBuilderName, StringBuilder sb, XmlSqlBlock dblock, int depth) {
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            XmlSqlCompiler._parseNode(n, sqlBuilderName, sb, dblock, depth);
        }
    }

    private static void _parseNode(Node n, String sqlBuilderName, StringBuilder sb, XmlSqlBlock dblock, int depth) {
        String text;
        short type = n.getNodeType();
        if ((type == 3 || type == 4) && (text = n.getTextContent().trim()).length() > 0) {
            text = " " + text;
            XmlSqlCompiler.newLine(sb, depth).append(sqlBuilderName).append(".append(");
            XmlSqlCompiler.parseTxt(sb, dblock, text);
            sb.append(");");
        }
        if (type == 1) {
            String tagName = n.getNodeName();
            if ("if".equals(tagName)) {
                XmlSqlCompiler.parseIfNode(sb, sqlBuilderName, dblock, n, depth);
                return;
            }
            if ("for".equals(tagName)) {
                XmlSqlCompiler.parseForNode(sb, sqlBuilderName, dblock, n, depth);
                return;
            }
            if ("ref".equals(tagName)) {
                XmlSqlCompiler.parseRefNode(sb, sqlBuilderName, dblock, n, depth);
                return;
            }
            if ("trim".equals(tagName)) {
                XmlSqlCompiler.parseTrimNode(sb, sqlBuilderName, dblock, n, depth);
                return;
            }
            XmlSqlCompiler._parseNodeList(n.getChildNodes(), sqlBuilderName, sb, dblock, depth);
        }
    }

    private static void parseTrimNode(StringBuilder sb, String sqlBuilderName, XmlSqlBlock dblock, Node n, int depth) {
        String _trimStart = XmlSqlCompiler.attr(n, "trimStart");
        String _trimEnd = XmlSqlCompiler.attr(n, "trimEnd");
        String _prefix = XmlSqlCompiler.attr(n, "prefix");
        String _suffix = XmlSqlCompiler.attr(n, "suffix");
        ++dblock.varNum;
        String varName = "sb" + dblock.varNum;
        sb.append("\n");
        XmlSqlCompiler.newLine(sb, depth).append("SQLBuilder ").append(varName).append(" = new SQLBuilder();  /*trim node*/");
        XmlSqlCompiler._parseNodeList(n.getChildNodes(), varName, sb, dblock, depth);
        if (!StringUtils.isEmpty((String)_trimStart)) {
            XmlSqlCompiler.newLine(sb, depth).append(varName).append(".trimStart(\"").append(_trimStart).append("\");");
        }
        if (!StringUtils.isEmpty((String)_trimEnd)) {
            XmlSqlCompiler.newLine(sb, depth).append(varName).append(".trimEnd(\"").append(_trimEnd).append("\");");
        }
        if (!StringUtils.isEmpty((String)_prefix)) {
            XmlSqlCompiler.newLine(sb, depth).append(varName).append(".addPrefix(\"").append(_prefix).append("\", false);");
        }
        if (!StringUtils.isEmpty((String)_suffix)) {
            XmlSqlCompiler.newLine(sb, depth).append(varName).append(".addSuffix(\"").append(_suffix).append("\", false);");
        }
        XmlSqlCompiler.newLine(sb, depth).append(sqlBuilderName).append(".append(").append(varName).append(");\n");
    }

    private static void parseIfNode(StringBuilder sb, String sqlBuilderName, XmlSqlBlock dblock, Node n, int depth) {
        String _test = XmlSqlCompiler.attr(n, "test").replace(" lt ", " < ").replace(" lte ", " <= ").replace(" gt ", " > ").replace(" gte ", " >= ").replace(" and ", " && ").replace(" or ", " || ").replace("'", "\"");
        if (_test.indexOf("?") > 0) {
            _test = XmlSqlCompiler.parseIfTestExpr(_test);
        }
        XmlSqlCompiler.newLine(sb, depth).append("if(").append(_test).append("){ /*if node*/");
        XmlSqlCompiler._parseNodeList(n.getChildNodes(), sqlBuilderName, sb, dblock, depth + 1);
        XmlSqlCompiler.newLine(sb, depth).append("}");
    }

    private static String parseIfTestExpr(String test) {
        Pattern r = Pattern.compile("([\\w\\.]*?)\\s*\\?(\\?|\\!|\\w*)");
        Matcher m = r.matcher(test);
        while (m.find()) {
            String newStr;
            String vname = m.group(1);
            String vfun = "?" + m.group(2);
            if ("??".equals(vfun)) {
                newStr = vname + " != null";
                test = test.replace(m.group(), newStr);
            }
            if (!"?!".equals(vfun)) continue;
            newStr = "StringUtils.isEmpty(" + vname + ") == false";
            test = test.replace(m.group(), newStr);
        }
        return test;
    }

    private static void parseRefNode(StringBuilder sb, String sqlBuilderName, XmlSqlBlock dblock, Node n, int depth) {
        String _sql_id = XmlSqlCompiler.attr(n, "sql");
        if (!StringUtils.isEmpty((String)_sql_id)) {
            Node ref_n = dblock.__nodeMap.get(_sql_id);
            if (ref_n == null) {
                throw new RuntimeException("sql node @" + _sql_id + " can't find");
            }
            XmlSqlCompiler._parseNode(ref_n, sqlBuilderName, sb, dblock, depth);
        }
    }

    private static void parseForNode(StringBuilder sb, String sqlBuilderName, XmlSqlBlock dblock, Node n, int depth) {
        String _items = XmlSqlCompiler.attr(n, "items");
        String _sep_str = XmlSqlCompiler.attr(n, "sep");
        String _var_str = XmlSqlCompiler.attr(n, "var").trim();
        if (_var_str.indexOf(":") < 0 || _var_str.length() < 3) {
            StringBuilder eb = new StringBuilder();
            eb.append(dblock._namespace).append("/").append(dblock._id).append("::").append("for/var(").append(_var_str).append(") must declare the type");
            throw new RuntimeException(eb.toString());
        }
        String[] kv = _var_str.split(":");
        XmlSqlVar _var = new XmlSqlVar(_var_str, kv[0].trim(), kv[1].trim());
        int depth0 = depth++;
        XmlSqlCompiler.newLine(sb, depth0).append("{ /*for node*/");
        XmlSqlCompiler.newLine(sb, depth).append("int ").append(_var.name).append("_index = 0;");
        XmlSqlCompiler.newLine(sb, depth).append("Iterator<").append(_var.type).append("> ").append(_var.name).append("_iterator").append(" = ").append(_items).append(".iterator();");
        XmlSqlCompiler.newLine(sb, depth).append("while (").append(_var.name).append("_iterator.hasNext()){");
        XmlSqlCompiler.newLine(sb, depth + 1).append(_var.type).append(" ").append(_var.name).append(" = ").append(_var.name).append("_iterator.next();\n");
        XmlSqlCompiler._parseNodeList(n.getChildNodes(), sqlBuilderName, sb, dblock, depth + 1);
        sb.append("\n");
        if (!StringUtils.isEmpty((String)_sep_str)) {
            XmlSqlCompiler.newLine(sb, depth + 1).append("if(").append(_var.name).append("_iterator.hasNext()").append("){");
            XmlSqlCompiler.newLine(sb, depth + 2).append(sqlBuilderName).append(".append(\"").append(_sep_str).append("\");");
            XmlSqlCompiler.newLine(sb, depth + 1).append("}");
        }
        XmlSqlCompiler.newLine(sb, depth + 1).append(_var.name).append("_index++;");
        XmlSqlCompiler.newLine(sb, depth).append("}");
        XmlSqlCompiler.newLine(sb, depth0).append("}");
        if (_items.indexOf(".") < 0) {
            XmlSqlVar _itemsVar = new XmlSqlVar(_items, _items, "Collection<" + _var.type + ">");
            dblock.varPut(_itemsVar);
        }
    }

    private static void parseTxt(StringBuilder sb, XmlSqlBlock dblock, String txt0) {
        Object dv;
        ArrayList<Object> tmpList = new ArrayList<Object>();
        String txt2 = txt0.replace("\n", " ");
        dblock._texts.append(txt2);
        tmpList.clear();
        Matcher m = XmlSqlVar.varRepExp.matcher(txt2);
        while (m.find()) {
            dv = XmlSqlCompiler.parseTxtVar(m);
            tmpList.add(dv);
            dblock.varPut((XmlSqlVar)dv);
        }
        for (XmlSqlVar xmlSqlVar : tmpList) {
            txt2 = txt2.replace(xmlSqlVar.mark, "\"+ " + xmlSqlVar.name + " +\"");
        }
        tmpList.clear();
        m = XmlSqlVar.varComExp.matcher(txt2);
        while (m.find()) {
            dv = XmlSqlCompiler.parseTxtVar(m);
            tmpList.add(dv);
            dblock.varPut((XmlSqlVar)dv);
        }
        for (XmlSqlVar xmlSqlVar : tmpList) {
            if (xmlSqlVar.type != null && xmlSqlVar.type.indexOf(">") > 0) {
                txt2 = txt2.replace(xmlSqlVar.mark, "?...");
                continue;
            }
            txt2 = txt2.replace(xmlSqlVar.mark, "?");
        }
        sb.append("\"").append(txt2).append(" \"");
        tmpList.forEach(v -> sb.append(",").append(v.name));
    }

    private static XmlSqlVar parseTxtVar(Matcher m) {
        XmlSqlVar dv = new XmlSqlVar();
        dv.mark = m.group(0);
        dv.name = CompilerUtil.varTypeParse(m.group(1).trim());
        if (dv.name.indexOf(":") > 0) {
            String[] kv = dv.name.split(":");
            dv.name = kv[0].trim();
            dv.type = kv[1].trim();
        }
        return dv;
    }

    private static StringBuilder newLine(StringBuilder sb, int depth) {
        sb.append("\n");
        while (depth > 0) {
            sb.append("  ");
            --depth;
        }
        return sb;
    }

    private static String attr(Node n, String name) {
        if (name.startsWith(":")) {
            return XmlSqlCompiler.attr(n, name, name.substring(1));
        }
        return XmlSqlCompiler.attr(n, name, null);
    }

    private static String attr(Node n, String name, String name2) {
        Node tmp = n.getAttributes().getNamedItem(name);
        if (tmp == null && name2 != null) {
            tmp = n.getAttributes().getNamedItem(name2);
        }
        if (tmp == null) {
            return null;
        }
        return tmp.getNodeValue();
    }
}

