/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.noear.wood.DbContext;
import org.noear.wood.IMapperInvoke;
import org.noear.wood.mapper.MapperInvokeForAnn;
import org.noear.wood.mapper.MapperInvokeForBas;
import org.noear.wood.mapper.MapperInvokeForXml;
import org.noear.wood.utils.InvocationHandlerUtils;
import org.noear.wood.utils.ThrowableUtils;
import org.noear.wood.wrap.MethodWrap;
import org.noear.wood.xml.Namespace;

class MapperHandler
implements InvocationHandler {
    protected DbContext db;
    protected Class<?> mapperClz;
    private static IMapperInvoke annInvoke = new MapperInvokeForAnn();
    private static IMapperInvoke xmlInvoke = new MapperInvokeForXml();
    private static IMapperInvoke basInvoke = new MapperInvokeForBas();
    protected static UnsupportedOperationException UOE = new UnsupportedOperationException();

    protected MapperHandler(DbContext db, Class<?> mapperClz) {
        this.db = db;
        this.mapperClz = mapperClz;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.invoke0(proxy, method, args);
        }
        catch (Throwable ex) {
            ex = ThrowableUtils.throwableUnwrap((Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw ex;
            }
            if (ex instanceof SQLException) {
                throw ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public Object invoke0(Object proxy, Method method, Object[] args) throws Throwable {
        MethodWrap mWrap;
        Class<?> caller = method.getDeclaringClass();
        if (method.isDefault()) {
            return InvocationHandlerUtils.invokeDefault((Object)proxy, (Method)method, (Object[])args);
        }
        if (caller == Object.class) {
            return InvocationHandlerUtils.invokeObject(this.mapperClz, (Object)proxy, (Method)method, (Object[])args);
        }
        String sqlid = MapperHandler.getSqlid(caller, method);
        Object tmp = annInvoke.call(proxy, this.db, sqlid, caller, mWrap = MethodWrap.get((Method)method), args);
        if (UOE.equals(tmp) && UOE.equals(tmp = xmlInvoke.call(proxy, this.db, sqlid, caller, mWrap, args)) && UOE.equals(tmp = basInvoke.call(proxy, this.db, sqlid, caller, mWrap, args))) {
            throw new RuntimeException("Xmlsql does not exist:@" + sqlid);
        }
        return tmp;
    }

    public static String getSqlid(Class<?> mapperClz, Method method) {
        Namespace c_meta = mapperClz.getAnnotation(Namespace.class);
        String fun_name = method.getName();
        if (c_meta == null) {
            return mapperClz.getPackage().getName() + "." + fun_name;
        }
        return c_meta.value() + "." + fun_name;
    }
}

