/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.xml;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import org.noear.liquor.DynamicCompiler;
import org.noear.liquor.DynamicCompilerException;

class CompilerUtil {
    static CompilerUtil _instance;
    DynamicCompiler dynamicCompiler = new DynamicCompiler();
    Map<String, Class<?>> dynamicClassMap;

    public static CompilerUtil instance() {
        if (_instance == null) {
            _instance = new CompilerUtil();
        }
        return _instance;
    }

    private CompilerUtil() {
    }

    public boolean compiler(List<String> codes) {
        long startTime = System.currentTimeMillis();
        for (String code : codes) {
            this.dynamicCompiler.addSource(CompilerUtil.getFullClassName(code), code);
        }
        try {
            this.dynamicClassMap = this.dynamicCompiler.build();
            System.out.println("[Wood] compiler time::" + (System.currentTimeMillis() - startTime) + "ms");
            return true;
        }
        catch (DynamicCompilerException e) {
            return false;
        }
    }

    public String getCompilerMessage() {
        StringBuilder sb = new StringBuilder();
        for (Diagnostic diagnostic : this.dynamicCompiler.getOriginalErrors()) {
            sb.append(diagnostic.toString()).append("\r\n");
        }
        return sb.toString();
    }

    public static String getFullClassName(String sourceCode) {
        String className = "";
        Pattern pattern = Pattern.compile("package\\s+(.*?);");
        Matcher matcher = pattern.matcher(sourceCode);
        if (matcher.find()) {
            className = matcher.group(1).trim() + ".";
        }
        if ((matcher = (pattern = Pattern.compile("class\\s+(.*?)\\{")).matcher(sourceCode)).find()) {
            className = className + matcher.group(1).trim();
        }
        return className;
    }

    public void loadClassAll(boolean instantiation) {
        this.dynamicClassMap.forEach((k, v) -> {
            try {
                Class<?> cls = this.dynamicClassMap.get(k);
                if (instantiation && cls != null) {
                    cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                System.out.println("[Wood] String class loaded::" + k);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
    }

    public static String varTypeParse(String str) {
        if (str.contains("[")) {
            return str.replace("[", "<").replace("]", ">");
        }
        return str;
    }
}

