/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.wood.BaseMapper;
import org.noear.wood.mapper.BaseMapperWrap;
import org.noear.wood.wrap.ClassWrap;
import org.noear.wood.wrap.FieldWrap;

public class BaseEntityWrap {
    public Class<?> entityClz;
    public String tableName;
    public String pkName;
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private static Map<BaseMapper, BaseEntityWrap> _lib = new HashMap<BaseMapper, BaseEntityWrap>();

    public static BaseEntityWrap get(BaseMapper bm) {
        BaseEntityWrap tmp = _lib.get(bm);
        if (tmp == null) {
            SYNC_LOCK.lock();
            try {
                tmp = _lib.get(bm);
                if (tmp == null) {
                    tmp = new BaseEntityWrap(bm);
                    _lib.put(bm, tmp);
                }
            }
            finally {
                SYNC_LOCK.unlock();
            }
        }
        return tmp;
    }

    private BaseEntityWrap(BaseMapper baseMapper) {
        if (baseMapper instanceof BaseMapperWrap) {
            this.entityClz = ((BaseMapperWrap)baseMapper).entityType();
        } else {
            Type type = baseMapper.getClass().getInterfaces()[0].getGenericInterfaces()[0];
            this.entityClz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (this.entityClz == Object.class) {
            throw new RuntimeException("There is no entity type declaration, baseMapper\uff1a" + baseMapper.getClass().getName());
        }
        ClassWrap classWrap = ClassWrap.get(this.entityClz);
        this.tableName = classWrap.tableName;
        if (this.tableName == null) {
            this.tableName = this.entityClz.getSimpleName();
        }
        for (FieldWrap f1 : classWrap.fieldWraps) {
            if (!f1.pk) continue;
            this.pkName = f1.name;
            break;
        }
        if (this.pkName == null) {
            throw new RuntimeException("There is no primary key declaration\uff0centity: " + this.entityClz.getName());
        }
    }
}

