/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.wood.BaseMapper;
import org.noear.wood.DataItem;
import org.noear.wood.DataItemBase;
import org.noear.wood.DataReader;
import org.noear.wood.DbContext;
import org.noear.wood.DbTableQuery;
import org.noear.wood.IDataItem;
import org.noear.wood.IDataReader;
import org.noear.wood.IPage;
import org.noear.wood.MapperWhereQ;
import org.noear.wood.ext.Act1;
import org.noear.wood.ext.Act2;
import org.noear.wood.impl.IPageImpl;
import org.noear.wood.mapper.BaseEntityWrap;
import org.noear.wood.utils.RunUtils;
import org.noear.wood.utils.StringUtils;
import org.noear.wood.wrap.Property;
import org.noear.wood.wrap.PropertyWrap;

public class BaseMapperWrap<T>
implements BaseMapper<T> {
    private DbContext _db;
    private BaseEntityWrap _table;
    private String _tabelName;
    private Class<?> _entityType;

    protected Class<?> entityType() {
        return this._entityType;
    }

    public BaseMapperWrap(DbContext db, Class<?> entityType, String tableName) {
        this._db = db;
        this._entityType = entityType;
        this._table = BaseEntityWrap.get(this);
        this._tabelName = StringUtils.isEmpty((String)tableName) ? this._table.tableName : tableName;
    }

    public BaseMapperWrap(DbContext db, BaseMapper<T> baseMapper) {
        this._db = db;
        this._table = BaseEntityWrap.get(baseMapper);
        this._tabelName = this._table.tableName;
    }

    public DbContext db() {
        return this._db;
    }

    public String tableName() {
        return this._tabelName;
    }

    public String tablePk() {
        return this._table.pkName;
    }

    public Class<?> entityClz() {
        return this._table.entityClz;
    }

    public Long insert(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        return (Long)RunUtils.call(() -> ((DbTableQuery)this.getQr().usingNull(!excludeNull)).insert((IDataItem)data));
    }

    public Long insert(T entity, Act2<T, DataItem> dataBuilder) {
        DataItem data = new DataItem();
        dataBuilder.run(entity, (Object)data);
        return (Long)RunUtils.call(() -> this.getQr().insert((IDataItem)data));
    }

    public void insertList(List<T> list) {
        ArrayList<DataItemBase> list2 = new ArrayList<DataItemBase>();
        for (T d : list) {
            list2.add(new DataItem().setEntityIf(d, (k, v) -> true));
        }
        RunUtils.call(() -> this.getQr().insertList(list2));
    }

    public void insertList(List<T> list, Act2<T, DataItem> dataBuilder) {
        ArrayList<DataItem> list2 = new ArrayList<DataItem>();
        for (T d : list) {
            DataItem data = new DataItem();
            dataBuilder.run(d, (Object)data);
            list2.add(data);
        }
        RunUtils.call(() -> this.getQr().insertList(list2));
    }

    public Integer deleteById(Object id) {
        return (Integer)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.tablePk(), id)).delete());
    }

    public Integer deleteByIds(Iterable idList) {
        return (Integer)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereIn(this.tablePk(), idList)).delete());
    }

    public Integer deleteByMap(Map<String, Object> columnMap) {
        return (Integer)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereMap(columnMap)).delete());
    }

    public Integer delete(Act1<MapperWhereQ> c) {
        return (Integer)RunUtils.call(() -> this.getQr(c).delete());
    }

    public Integer updateById(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        Object id = data.get(this.tablePk());
        return (Integer)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEq(this.tablePk(), id)).usingNull(!excludeNull)).update((IDataItem)data));
    }

    public Integer updateById(T entity, Act2<T, DataItem> dataBuilder) {
        DataItem data = new DataItem();
        dataBuilder.run(entity, (Object)data);
        Object id = data.get(this.tablePk());
        return (Integer)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.tablePk(), id)).update((IDataItem)data));
    }

    public Integer update(T entity, boolean excludeNull, Act1<MapperWhereQ> c) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        return (Integer)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).usingNull(!excludeNull)).update((IDataItem)data));
    }

    public Integer update(T entity, Act2<T, DataItem> dataBuilder, Act1<MapperWhereQ> c) {
        DataItem data = new DataItem();
        dataBuilder.run(entity, (Object)data);
        return (Integer)RunUtils.call(() -> this.getQr(c).update((IDataItem)data));
    }

    public int[] updateList(List<T> list, Act2<T, DataItem> dataBuilder, Property<T, ?> ... conditionFields) {
        if (conditionFields.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        StringBuilder buf = new StringBuilder();
        for (Property<T, ?> p : conditionFields) {
            buf.append(PropertyWrap.get(p).name).append(",");
        }
        buf.setLength(buf.length() - 1);
        return (int[])RunUtils.call(() -> this.getQr().updateList((Collection)list, dataBuilder, buf.toString()));
    }

    public Long upsert(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        Object id = data.get(this.tablePk());
        if (id == null) {
            return (Long)RunUtils.call(() -> ((DbTableQuery)this.getQr().usingNull(!excludeNull)).insert((IDataItem)data));
        }
        return (Long)RunUtils.call(() -> ((DbTableQuery)this.getQr().usingNull(!excludeNull)).upsertBy((IDataItem)data, this.tablePk()));
    }

    public Long upsert(T entity, Act2<T, DataItem> dataBuilder) {
        DataItem data = new DataItem();
        dataBuilder.run(entity, (Object)data);
        Object id = data.get(this.tablePk());
        if (id == null) {
            return (Long)RunUtils.call(() -> this.getQr().insert((IDataItem)data));
        }
        return (Long)RunUtils.call(() -> this.getQr().upsertBy((IDataItem)data, this.tablePk()));
    }

    public Long upsertBy(T entity, boolean excludeNull, String conditionFields) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntityIf(entity, (k, v) -> true);
        }
        return (Long)RunUtils.call(() -> ((DbTableQuery)this.getQr().usingNull(!excludeNull)).upsertBy((IDataItem)data, conditionFields));
    }

    public Long upsertBy(T entity, Act2<T, DataItem> dataBuilder, String conditionFields) {
        DataItem data = new DataItem();
        dataBuilder.run(entity, (Object)data);
        return (Long)RunUtils.call(() -> this.getQr().upsertBy((IDataItem)data, conditionFields));
    }

    public boolean existsById(Object id) {
        return (Boolean)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.tablePk(), id)).selectExists());
    }

    public boolean exists(Act1<MapperWhereQ> c) {
        return (Boolean)RunUtils.call(() -> this.getQr(c).selectExists());
    }

    public T selectById(Object id) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEq(this.tablePk(), id)).limit(1)).selectItem("*", clz));
    }

    public List<T> selectByIds(Iterable idList) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereIn(this.tablePk(), idList)).selectList("*", clz));
    }

    public List<T> selectByMap(Map<String, Object> columnMap) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr().whereMap(columnMap)).selectList("*", clz));
    }

    public T selectItem(T entity) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEntity(entity)).limit(1)).selectItem("*", clz));
    }

    public T selectItem(Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> this.getQr(c).selectItem("*", clz));
    }

    public Object selectValue(String column, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).selectValue(column));
    }

    public Map<String, Object> selectMap(Act1<MapperWhereQ> c) {
        return (Map)RunUtils.call(() -> this.getQr(c).selectMap("*"));
    }

    public Long selectCount(Act1<MapperWhereQ> c) {
        return (Long)RunUtils.call(() -> this.getQr(c).selectCount());
    }

    public List<T> selectList(Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> this.getQr(c).selectList("*", clz));
    }

    public List<Map<String, Object>> selectMapList(Act1<MapperWhereQ> c) {
        return (List)RunUtils.call(() -> this.getQr(c).selectMapList("*"));
    }

    public List<Object> selectArray(String column, Act1<MapperWhereQ> c) {
        return (List)RunUtils.call(() -> this.getQr(c).selectArray(column));
    }

    public List<T> selectList(int start, int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectList("*", clz));
    }

    public List<Map<String, Object>> selectMapList(int start, int size, Act1<MapperWhereQ> c) {
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectMapList("*"));
    }

    public List<Object> selectArray(String column, int start, int size, Act1<MapperWhereQ> c) {
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectArray(column));
    }

    public IDataReader<T> selectReader(Act1<MapperWhereQ> c) {
        return this.selectReader(0, c);
    }

    public IDataReader<T> selectReader(int fetchSize, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        DataReader reader = (DataReader)RunUtils.call(() -> this.getQr(c).selectDataReader("*", fetchSize));
        return reader.toEntityReader(clz);
    }

    public IPage<T> selectPage(int start, int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        List list = (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectList("*", clz));
        long total = (Long)RunUtils.call(() -> this.getQr(c).selectCount());
        IPageImpl page = new IPageImpl(list, total, size);
        return page;
    }

    public IPage<Map<String, Object>> selectMapPage(int start, int size, Act1<MapperWhereQ> c) {
        List list = (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectMapList("*"));
        long total = (Long)RunUtils.call(() -> this.getQr(c).selectCount());
        IPageImpl page = new IPageImpl(list, total, size);
        return page;
    }

    public List<T> selectTop(int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).top(size)).selectList("*", clz));
    }

    public List<Map<String, Object>> selectMapTop(int size, Act1<MapperWhereQ> c) {
        return (List)RunUtils.call(() -> ((DbTableQuery)this.getQr(c).top(size)).selectMapList("*"));
    }

    protected DbTableQuery getQr() {
        return this.db().table(this.tableName());
    }

    protected DbTableQuery getQr(Act1<MapperWhereQ> c) {
        DbTableQuery qr = this.db().table(this.tableName());
        if (c != null) {
            c.run((Object)new MapperWhereQ(qr));
        }
        return qr;
    }
}

