/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.xxljob;

import com.xxl.job.core.executor.XxlJobExecutor;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.utils.LocalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
public class XxlJobAutoConfig {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobAutoConfig.class);
    @Inject(value="${xxl.job.admin.addresses}", required=false)
    private String adminAddresses;
    @Inject(value="${xxl.job.accessToken}", required=false)
    private String accessToken;
    @Inject(value="${xxl.job.executor.appname}", required=false)
    private String appname;
    @Inject(value="${xxl.job.executor.address}", required=false)
    private String address;
    @Inject(value="${xxl.job.executor.ip}", required=false)
    private String ip;
    @Inject(value="${xxl.job.executor.port}", required=false)
    private int port;
    @Inject(value="${xxl.job.executor.logpath}", required=false)
    private String logPath;
    @Inject(value="${xxl.job.executor.logretentiondays}", required=false)
    private int logRetentionDays;
    @Inject(value="xxljob-cloudProps")
    CloudProps cloudProps;

    @Bean
    public XxlJobExecutor xxlJobExecutor() {
        logger.info(">>>>>>>>>>> xxl-job config init.");
        if (Utils.isEmpty((String)this.adminAddresses)) {
            this.adminAddresses = this.cloudProps.getJobServer();
        }
        if (Utils.isEmpty((String)this.appname)) {
            this.appname = Solon.cfg().appName();
        }
        if (Utils.isEmpty((String)this.ip)) {
            this.ip = LocalUtils.getLocalAddress();
        }
        if (this.port < 1000) {
            this.port = 9999;
        }
        if (this.logRetentionDays < 1) {
            this.logRetentionDays = 30;
        }
        if (Utils.isEmpty((String)this.logPath)) {
            this.logPath = "/data/applogs/xxl-job/jobhandler";
        }
        if (Utils.isEmpty((String)this.accessToken)) {
            this.accessToken = this.cloudProps.getToken();
            if (Utils.isEmpty((String)this.accessToken)) {
                this.accessToken = this.cloudProps.getPassword();
            }
        }
        XxlJobExecutor executor = new XxlJobExecutor();
        executor.setAdminAddresses(this.adminAddresses);
        executor.setAppname(this.appname);
        executor.setAddress(this.address);
        executor.setIp(this.ip);
        executor.setPort(this.port);
        executor.setAccessToken(this.accessToken);
        executor.setLogPath(this.logPath);
        executor.setLogRetentionDays(this.logRetentionDays);
        return executor;
    }
}

