/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.zookeeper;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.zookeeper.service.CloudConfigServiceZkImp;
import org.noear.solon.cloud.extend.zookeeper.service.CloudDiscoveryServiceZkImp;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;

public class XPluginImp
implements Plugin {
    CloudConfigServiceZkImp configServiceZkImp;
    CloudDiscoveryServiceZkImp discoveryServiceZkImp;

    public void start(AopContext context) {
        CloudProps cloudProps = new CloudProps(context, "zookeeper");
        if (Utils.isEmpty((String)cloudProps.getServer())) {
            return;
        }
        if (cloudProps.getConfigEnable()) {
            this.configServiceZkImp = new CloudConfigServiceZkImp(cloudProps);
            CloudManager.register((CloudConfigService)this.configServiceZkImp);
            CloudClient.configLoad((String)cloudProps.getConfigLoad());
        }
        if (cloudProps.getDiscoveryEnable()) {
            this.discoveryServiceZkImp = new CloudDiscoveryServiceZkImp(cloudProps);
            CloudManager.register((CloudDiscoveryService)this.discoveryServiceZkImp);
        }
    }

    public void stop() throws Throwable {
        if (this.configServiceZkImp != null) {
            this.configServiceZkImp.close();
        }
        if (this.discoveryServiceZkImp != null) {
            this.discoveryServiceZkImp.close();
        }
    }
}

