/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.zookeeper.service;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.zookeeper.impl.ZkClient;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;

public class CloudConfigServiceZkImp
implements CloudConfigService {
    private static final String PATH_ROOT = "/solon/config";
    private ZkClient client;

    public CloudConfigServiceZkImp(CloudProps cloudProps) {
        String sessionTimeout = cloudProps.getDiscoveryHealthCheckInterval("3000");
        this.client = new ZkClient(cloudProps.getDiscoveryServer(), Integer.parseInt(sessionTimeout));
        this.client.connectServer();
        this.client.createNode("/solon");
        this.client.createNode(PATH_ROOT);
    }

    public Config pull(String group, String key) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        String value = this.client.getNodeData(String.format("%s/%s/%s", PATH_ROOT, group, key));
        return new Config(group, key, value, 0L);
    }

    public boolean push(String group, String key, String value) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        this.client.createNode(String.format("%s/%s", PATH_ROOT, group));
        this.client.setNodeData(String.format("%s/%s/%s", PATH_ROOT, group, key), value);
        return true;
    }

    public boolean remove(String group, String key) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        this.client.removeNode(String.format("%s/%s/%s", PATH_ROOT, group, key));
        return true;
    }

    public void attention(String group, String key, CloudConfigHandler observer) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, key, observer);
        this.client.watchNodeData(String.format("%s/%s/%s", PATH_ROOT, group, key), event -> entity.handle(this.pull(entity.group, entity.key)));
    }

    public void close() throws InterruptedException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

