/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.zookeeper.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZkClient {
    private CountDownLatch latch = new CountDownLatch(1);
    private String server;
    private int sessionTimeout;
    private ZooKeeper real;
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public ZkClient(String server, int sessionTimeout) {
        this.server = server;
        this.sessionTimeout = sessionTimeout;
    }

    public void connectServer() {
        this.SYNC_LOCK.lock();
        try {
            if (this.real != null) {
                return;
            }
            this.connectServer0();
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    private void connectServer0() {
        try {
            this.real = new ZooKeeper(this.server, this.sessionTimeout, event -> {
                switch (event.getState()) {
                    case SyncConnected: {
                        this.latch.countDown();
                        break;
                    }
                    case Expired: {
                        this.connectServer0();
                    }
                }
            });
            this.latch.await();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void createNode(String path) {
        this.createNode(path, "", true);
    }

    public void createNode(String path, String data, boolean isPersistent) {
        try {
            if (this.real.exists(path, null) == null) {
                this.real.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, isPersistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeNode(String path) {
        try {
            this.real.delete(path, -1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setNodeData(String path, String data) {
        try {
            if (this.real.exists(path, false) == null) {
                this.createNode(path, data, true);
            } else {
                this.real.setData(path, data.getBytes(), -1);
            }
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNodeData(String path) {
        try {
            byte[] bytes = this.real.getData(path, false, null);
            return new String(bytes);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void watchNodeData(String path, Watcher watcher) {
        try {
            this.real.getData(path, event -> {
                if (event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                    watcher.process(event);
                }
            }, null);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> findChildrenNode(String parentPath) {
        try {
            List nodeList = this.real.getChildren(parentPath, null);
            ArrayList<String> nodeDataList = new ArrayList<String>();
            for (String node : nodeList) {
                String nodeData = this.getNodeData(parentPath + "/" + node);
                nodeDataList.add(nodeData);
            }
            return nodeDataList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void watchChildrenNode(String parentPath, Watcher watcher) {
        try {
            this.real.getChildren(parentPath, event -> {
                if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                    watcher.process(event);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws InterruptedException {
        if (this.real != null) {
            this.real.close();
        }
    }
}

