/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.bankgiro;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.camel.Header;
import org.notima.bg.BgMaxFile;
import org.notima.bg.LbFile;

public class BankgiroFileUtil {
    public String getBgMaxRecipient(@Header(value="fullFileName") String fullFileName, @Header(value="Charset") String charset) throws Exception {
        if (charset == null || charset.trim().length() == 0) {
            charset = "Cp850";
        }
        Charset cs = Charset.forName(charset);
        BgMaxFile inFile = new BgMaxFile();
        inFile.readFromFile(new File(fullFileName), cs);
        Set recipients = inFile.getBgRecipients();
        if (recipients.isEmpty()) {
            return null;
        }
        return (String)recipients.iterator().next();
    }

    public void splitLbFiles(@Header(value="fullFileName") String fullFileName, @Header(value="destDir") String destDir, @Header(value="Charset") String charset) throws Exception {
        if (charset == null || charset.trim().length() == 0) {
            charset = "Cp850";
        }
        Charset cs = Charset.forName(charset);
        LbFile.splitToFiles((File)new File(fullFileName), (File)new File(destDir), (Charset)cs);
    }
}

