/*
 * Decompiled with CFR 0.152.
 */
package org.notima.api.fortnox;

import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBException;
import org.notima.api.fortnox.FortnoxClient3;
import org.notima.api.fortnox.clients.FortnoxClientList;
import org.notima.api.fortnox.entities3.Customer;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.api.fortnox.entities3.InvoiceRow;
import org.notima.api.fortnox.entities3.InvoiceRows;
import org.notima.api.fortnox.entities3.InvoiceSubset;
import org.notima.api.fortnox.entities3.Invoices;

public class FortnoxUtil {
    public static String allowedPatternStr = "[\\p{L}\\\u2019\\\\\\x{0308}\\x{030a}a-z\u00e5\u00e4\u00f6\u00e9\u00e1\u0153\u00e6\u00f8\u00fcA-Z\u00c5\u00c4\u00d6\u00c9\u00c1\u00dc\u0152\u00c6\u00d80-9 \u2013:\\.`\u00b4\u2019,;\\^\u00a4#%\u00a7\u00a3$\u20ac\u00a2\u00a5\u00a9\u2122\u00b0&\\/\\(\\)=\\+\\-\\*_\\!?\u00b2\u00b3\u00ae\u00bd\\@\\x{00a0}\\n\\r]";
    public static Pattern allowedPattern = Pattern.compile(allowedPatternStr);
    public static Pattern allowedChars = Pattern.compile("^" + allowedPatternStr + "*$");

    public static String removeNonAllowedCharacters(String src) {
        if (src == null) {
            return null;
        }
        Matcher matcher = allowedPattern.matcher(src);
        if (matcher.matches()) {
            return src;
        }
        StringBuffer dst = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            String c = src.substring(i, i + 1);
            Matcher cMatcher = allowedChars.matcher(c);
            if (cMatcher.matches()) {
                dst.append(c);
            } else {
                dst.append(" ");
            }
            ++i;
        }
        return dst.toString();
    }

    public static FortnoxClientList readFortnoxClientListFromFile(String fileName) throws JAXBException {
        FortnoxClientList result = null;
        URL url = ClassLoader.getSystemResource(fileName);
        if (url != null) {
            fileName = url.getFile();
        }
        File f = new File(fileName);
        result = (FortnoxClientList)JAXB.unmarshal((File)f, FortnoxClientList.class);
        return result;
    }

    public static int copyCustomerInvoices(FortnoxClient3 clSrc, FortnoxClient3 clDst, Date fromDate, Date untilDate, PrintStream os) throws Exception {
        int invoiceCount = 0;
        Invoices src = clSrc.getAllCustomerInvoicesByDateRange(fromDate, untilDate);
        List<InvoiceSubset> subset = src.getInvoiceSubset();
        for (InvoiceSubset is : subset) {
            Invoice i = clSrc.getInvoice(is.getDocumentNumber());
            String custNo = i.getCustomerNumber();
            Customer customer = clSrc.getCustomerByCustNo(custNo);
            Customer dstCustomer = clDst.getCustomerByCustNo(custNo);
            if (dstCustomer == null) {
                if (os != null) {
                    os.println("Creating new customer " + customer.getCustomerNumber() + " : " + customer.getName());
                }
                customer.setCountry(null);
                customer.setDeliveryCountry(null);
                dstCustomer = clDst.setCustomer(customer);
            }
            i.setCustomerNumber(dstCustomer.getCustomerNumber());
            String invoiceNo = i.getDocumentNumber();
            Invoice existingInvoice = clDst.getInvoice(invoiceNo);
            if (existingInvoice == null) {
                i.setDocumentNumber(null);
            }
            FortnoxUtil.purgeInvoice(i, true, true, true);
            clDst.setInvoice(i);
            ++invoiceCount;
            if (os == null) continue;
            os.println("Invoice No " + invoiceNo + " copied");
        }
        return invoiceCount;
    }

    public static Invoice purgeInvoice(Invoice src, boolean removeArticleNo, boolean removeCostCenter, boolean removeProject) {
        src.setAdministrationFeeVAT(null);
        src.setBasisTaxReduction(null);
        src.setBalance(null);
        src.setBooked(null);
        src.setCancelled(null);
        src.setCredit(null);
        src.setCreditInvoiceReference(null);
        src.setContributionPercent(null);
        src.setContributionValue(null);
        src.setFreightVAT(null);
        src.setGross(null);
        src.setHouseWork(null);
        src.setInvoicePeriodStart(null);
        src.setInvoicePeriodEnd(null);
        src.setLastRemindDate(null);
        src.setNet(null);
        src.setOfferReference(null);
        src.setOrderReference(null);
        src.setInvoiceReference(null);
        src.setOrganisationNumber(null);
        src.setReminders(null);
        src.setRoundOff(null);
        src.setSent(null);
        src.setTaxReduction(null);
        src.setTotal(null);
        src.setTotalVAT(null);
        src.setVoucherNumber(null);
        src.setVoucherSeries(null);
        src.setVoucherYear(null);
        src.setEdiInformation(null);
        src.setTotalToPay(null);
        if (removeProject) {
            src.setProject(null);
        }
        if (removeCostCenter) {
            src.setCostCenter(null);
        }
        InvoiceRows rows = src.getInvoiceRows();
        for (InvoiceRow r : rows.getInvoiceRow()) {
            r.setContributionPercent(null);
            r.setContributionValue(null);
            if (removeArticleNo) {
                r.setArticleNumber(null);
            }
            if (removeProject) {
                r.setProject(null);
            }
            if (!removeCostCenter) continue;
            r.setCostCenter(null);
        }
        return src;
    }
}

