/*
 * Decompiled with CFR 0.152.
 */
package org.notima.api.fortnox.clients;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.notima.api.fortnox.clients.FortnoxApiClient;
import org.notima.api.fortnox.clients.FortnoxClientInfo;
import org.notima.api.fortnox.clients.ListOfApiClient;
import org.notima.api.fortnox.clients.ListOfClientInfo;

@XmlRootElement(name="FortnoxClientList")
public class FortnoxClientList {
    private ListOfApiClient apiClients;
    private ListOfClientInfo clients;
    private Map<String, FortnoxApiClient> apiClientMap;
    private Map<String, FortnoxClientInfo> clientMap;

    @XmlElement(name="FortnoxApiClients")
    public ListOfApiClient getApiClients() {
        return this.apiClients;
    }

    public void setApiClients(ListOfApiClient apiClients) {
        this.apiClients = apiClients;
    }

    @XmlElement(name="FortnoxClients")
    public ListOfClientInfo getClients() {
        return this.clients;
    }

    public void setClients(ListOfClientInfo clients) {
        this.clients = clients;
    }

    public void generateApiMap(boolean regenerate) {
        if (this.apiClientMap != null) {
            if (regenerate) {
                this.apiClientMap.clear();
            }
        } else {
            this.apiClientMap = new TreeMap<String, FortnoxApiClient>();
        }
        if (this.apiClients == null || this.apiClients.getApiClient() == null || this.apiClients.getApiClient().size() == 0) {
            return;
        }
        for (FortnoxApiClient fac : this.apiClients.getApiClient()) {
            this.apiClientMap.put(fac.getClientId(), fac);
        }
    }

    public void generateFortnoxClientMap(boolean regenerate) {
        if (this.clientMap != null) {
            if (regenerate) {
                this.clientMap.clear();
            }
        } else {
            this.clientMap = new TreeMap<String, FortnoxClientInfo>();
        }
        if (this.clients == null || this.clients.getFortnoxClient() == null || this.clients.getFortnoxClient().size() == 0) {
            return;
        }
        for (FortnoxClientInfo fci : this.clients.getFortnoxClient()) {
            this.clientMap.put(fci.getOrgNo(), fci);
        }
    }

    public FortnoxApiClient getApiClientById(String clientId) {
        this.generateApiMap(false);
        return this.apiClientMap.get(clientId);
    }

    public FortnoxClientInfo getClientInfoByOrgNo(String orgNo) {
        this.generateFortnoxClientMap(false);
        return this.clientMap.get(orgNo);
    }
}

