/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.fortnox;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.camel.Header;
import org.notima.api.fortnox.FortnoxUtil;
import org.notima.api.fortnox.clients.FortnoxApiClient;
import org.notima.api.fortnox.clients.FortnoxClientInfo;
import org.notima.api.fortnox.clients.FortnoxClientList;
import org.notima.api.fortnox.clients.ListOfClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortnoxClientManager {
    private Logger log = LoggerFactory.getLogger(FortnoxClientManager.class);
    private FortnoxClientList clientList;

    public FortnoxClientManager() {
    }

    public FortnoxClientManager(String fortnoxClientsFile) {
        this.readClientsFromFile(fortnoxClientsFile);
    }

    public Boolean readClientsFromFile(String fortnoxClientsFile) {
        try {
            this.clientList = FortnoxUtil.readFortnoxClientListFromFile(fortnoxClientsFile);
            return this.clientList != null ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (JAXBException e) {
            this.log.warn("Can't read Fortnox Client file: {} ", (Object)fortnoxClientsFile);
            this.log.debug(e.getMessage());
            return Boolean.FALSE;
        }
    }

    public List<FortnoxClientInfo> getFortnoxClients() {
        ArrayList<FortnoxClientInfo> list = new ArrayList<FortnoxClientInfo>();
        if (this.clientList == null) {
            return list;
        }
        ListOfClientInfo ll = this.clientList.getClients();
        if (ll == null) {
            return list;
        }
        List<FortnoxClientInfo> tmpList = ll.getFortnoxClient();
        for (FortnoxClientInfo ii : tmpList) {
            FortnoxClientInfo fi = this.getClientInfoByOrgNo(ii.getOrgNo());
            if (fi == null) continue;
            list.add(fi);
        }
        return list;
    }

    public FortnoxClientList getClientList() {
        return this.clientList;
    }

    public void setClientList(FortnoxClientList clientList) {
        this.clientList = clientList;
    }

    public FortnoxClientInfo getClientInfoByOrgNo(@Header(value="orgNo") String orgNo) {
        FortnoxApiClient apic;
        if (this.clientList == null) {
            this.log.warn("No Fortnox Clients available.");
            return null;
        }
        FortnoxClientInfo result = this.clientList.getClientInfoByOrgNo(orgNo);
        if (result != null && (result.getClientSecret() == null || result.getClientSecret().trim().length() == 0) && (apic = this.clientList.getApiClientById(result.getClientId())) != null) {
            result.setClientSecret(apic.getClientSecret());
        }
        return result;
    }
}

