/*
 * Decompiled with CFR 0.152.
 */
package org.notima.api.fortnox;

import java.util.Map;
import org.notima.api.fortnox.FortnoxClient3;
import org.notima.api.fortnox.entities3.Supplier;
import org.notima.piggyback.FieldRider;
import org.notima.piggyback.FieldRiderKeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fortnox4JSettings {
    private Logger log = LoggerFactory.getLogger(Fortnox4JSettings.class);
    private FortnoxClient3 client;

    public Fortnox4JSettings(FortnoxClient3 fc3) {
        this.client = fc3;
    }

    public String getSettingFromSupplierByOrgNo(String supplierOrgNo, String settingKey) throws Exception {
        Map<String, String> map = this.getSettingsFromSupplierByOrgNo(supplierOrgNo);
        if (map != null) {
            return map.get(settingKey);
        }
        return null;
    }

    public String getSettingFromSupplierNo(String supplierNo, String settingKey) throws Exception {
        Map<String, String> map = this.getSettingsFromSupplierNo(supplierNo);
        if (map != null) {
            return map.get(settingKey);
        }
        return null;
    }

    public Map<String, String> getSettingsFromSupplierByOrgNo(String supplierOrgNo) throws Exception {
        Supplier supplier = this.client.getSupplierByTaxId(supplierOrgNo, true);
        if (supplier == null) {
            this.log.warn("Supplier with tax id {} doesn't exist.", (Object)supplierOrgNo);
            return null;
        }
        String comment = supplier.getComments();
        FieldRider rider = new FieldRider(comment);
        return rider.getSettingsMap();
    }

    public Map<String, String> getSettingsFromSupplierNo(String supplierNo) throws Exception {
        Supplier supplier = this.client.getSupplierBySupplierNo(supplierNo);
        if (supplier == null) {
            this.log.warn("Supplier with no {} doesn't exist.", (Object)supplierNo);
            return null;
        }
        FieldRider rider = new FieldRider(supplier.getComments());
        return rider.getSettingsMap();
    }

    public Supplier writeSettingToSupplierByOrgNo(String supplierOrgNo, String settingKey, String settingValue) throws Exception {
        Supplier supplier = this.client.getSupplierByTaxId(supplierOrgNo, true);
        if (supplier == null) {
            this.log.warn("Supplier with tax id {} doesn't exist.", (Object)supplierOrgNo);
            return null;
        }
        String comment = supplier.getComments();
        FieldRider rider = new FieldRider(comment);
        FieldRiderKeyValuePair kvp = rider.lookupKeyValuePair(settingKey);
        if (kvp == null) {
            kvp = new FieldRiderKeyValuePair(settingKey, settingValue);
            rider.addKeyValuePair(kvp);
        } else {
            kvp.setValue(settingValue);
        }
        StringBuffer newContent = rider.updateContent();
        supplier.setComments(newContent.toString());
        supplier = this.client.setSupplier(supplier, false);
        return supplier;
    }
}

