/*
 * Decompiled with CFR 0.152.
 */
package org.notima.api.fortnox;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.notima.api.fortnox.FortnoxException;
import org.notima.api.fortnox.FortnoxUtil;
import org.notima.api.fortnox.entities3.AccountSubset;
import org.notima.api.fortnox.entities3.Accounts;
import org.notima.api.fortnox.entities3.Authorization;
import org.notima.api.fortnox.entities3.CompanySetting;
import org.notima.api.fortnox.entities3.Customer;
import org.notima.api.fortnox.entities3.CustomerSubset;
import org.notima.api.fortnox.entities3.Customers;
import org.notima.api.fortnox.entities3.ErrorInformation;
import org.notima.api.fortnox.entities3.FinancialYearSubset;
import org.notima.api.fortnox.entities3.FinancialYears;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.api.fortnox.entities3.InvoicePayment;
import org.notima.api.fortnox.entities3.InvoiceRow;
import org.notima.api.fortnox.entities3.Invoices;
import org.notima.api.fortnox.entities3.Order;
import org.notima.api.fortnox.entities3.Orders;
import org.notima.api.fortnox.entities3.PreDefinedAccount;
import org.notima.api.fortnox.entities3.PreDefinedAccounts;
import org.notima.api.fortnox.entities3.Supplier;
import org.notima.api.fortnox.entities3.SupplierSubset;
import org.notima.api.fortnox.entities3.Suppliers;
import org.notima.api.fortnox.entities3.Voucher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortnoxClient3 {
    public static final String FILTER_CANCELLED = "cancelled";
    public static final String FILTER_FULLY_PAID = "fullypaid";
    public static final String FILTER_UNPAID = "unpaid";
    public static final String FILTER_UNPAID_OVERDUE = "unpaidoverdue";
    public static final String FILTER_UNBOOKED = "unbooked";
    public static final String FILTER_EXPIRED = "expired";
    public static final String FILTER_INVOICECREATED = "invoicecreated";
    public static final String FILTER_INVOICENOTCREATED = "invoicenotcreated";
    public static final String ACTION_INVOICE_BOOKKEEP = "bookkeep";
    public static final String ACTION_INVOICE_CANCEL = "cancel";
    public static final String ACTION_INVOICE_CREDIT = "credit";
    public static final String ACTION_INVOICE_EMAIL = "email";
    public static final String ACTION_INVOICE_PRINT = "print";
    public static final String ACTION_INVOICE_PRINTREMINDER = "printreminder";
    public static final String ACTION_INVOICE_EXTERNALPRINT = "externalprint";
    public static final String ACTION_INVOICE_PREVIEW = "preview";
    public static final String ACTION_ORDER_CREATEINVOICE = "createinvoice";
    public static final String ACTION_ORDER_CANCEL = "cancel";
    public static final String ACTION_ORDER_EMAIL = "email";
    public static final String ACTION_ORDER_PRINT = "print";
    public static final String ACTION_ORDER_EXTERNALPRINT = "externalprint";
    public static final String ACTION_ORDER_PREVIEW = "preview";
    public static final String ACCT_SALES_MP1 = "SALES";
    public static final String ACCT_SALES_SERVICE_MP1 = "SALES2";
    public static final String ACCT_SALES_MP2 = "SALES_MP2";
    public static final String ACCT_SALES_MP3 = "SALES_MP3";
    public static final String ACCT_SALES_MP0 = "SALES_MP0";
    public static final String ACCT_SALES_NO_VAT = "SALES_NOVAT";
    public static final String ACCT_SALES_EU = "SALESEUREV";
    public static final String ACCT_SALES_EU_SERVICE = "SALESEUREV2";
    public static final String ACCT_SALES_EXPORT = "SALESEXPORT";
    public static final String ACCT_SALES_EXPORT_SERVICE = "SALESEXPORT2";
    public static final String ACCT_SALES_EU_W_VAT = "SALESEUVAT";
    public static final String ACCT_SALES_EU_W_VAT_SERVICE = "SALESEUVAT2";
    public static final String ACCT_SALES_SE_REV = "SALESCONSTR2";
    public static final String ACCT_ROUNDING = "ROUNDOFF";
    public static String[] PREDEFINED_REV_ACCT = new String[]{"CURRENCYWIN", "CURRENCYLOSS", "ADMFEE", "FREIGHT", "ROUNDOFF", "SALES", "SALES2", "SALESEUREV", "SALESEUREV2", "SALESEXPORT", "SALESEUVAT", "SALESEUVAT2", "SALESCONSTR2"};
    public static String[] PREDEFINED_REVENUE_VAT_ACCT = new String[]{"SALES_MP2", "SALES_MP3", "SALES_MP0", "SALES_NOVAT", "SALESEXPORT2"};
    public static final String ERROR_CANT_FIND_CUSTOMER = "2000433";
    public static final String ERROR_CANT_FIND_INVOICE = "2000434";
    public static final String DFortnox4JFile = "Fortnox4JFile";
    public static final String ENV_CONFIG_FILE = "Fortnox4JFile".toUpperCase();
    private String m_clientSecret;
    private String m_authCode;
    private String m_accessToken;
    private String m_baseUrl = "https://api.fortnox.se/3";
    public static DateFormat s_dfmt = new SimpleDateFormat("yyyy-MM-dd");
    private Map<String, CustomerSubset> m_customerTaxIdLookupMap;
    private Map<String, SupplierSubset> m_supplierTaxIdLookupMap;
    protected Logger logger = LoggerFactory.getLogger(FortnoxClient3.class);
    private boolean useArticles = true;

    public FortnoxClient3() {
        this.initFromFile(null);
    }

    public FortnoxClient3(String accessToken, String clientSecret) {
        this.setAccessToken(accessToken, clientSecret);
    }

    public FortnoxClient3(String configFile) {
        this.initFromFile(configFile);
    }

    private void initFromFile(String configFile) {
        URL url;
        File f;
        if (configFile == null || configFile.trim().length() == 0) {
            String defaultFile = System.getProperty(DFortnox4JFile);
            if (defaultFile == null) {
                defaultFile = System.getenv(ENV_CONFIG_FILE);
            }
            if (defaultFile != null) {
                configFile = defaultFile;
                this.logger.debug("Trying config from environment: {}", (Object)configFile);
            }
        }
        File file = f = configFile != null ? new File(configFile) : null;
        if (!(f == null || f.exists() || (f = (url = ClassLoader.getSystemResource(configFile)) != null ? new File(url.getFile()) : null) != null && f.exists())) {
            this.logger.warn("Configuration file {} not found.", (Object)configFile);
            return;
        }
        if (f == null) {
            this.logger.debug("Not using configuration file to init FortnoxClient");
            return;
        }
        XMLConfiguration fc = new XMLConfiguration();
        fc.setFile(f);
        try {
            this.logger.debug("Using configuration file {}.", (Object)configFile);
            fc.load();
        }
        catch (ConfigurationException e) {
            this.logger.error("Problem with reading configuration file {}.", (Object)configFile);
            e.printStackTrace();
            return;
        }
        String clientSecret = fc.getString("clientSecret");
        String accessToken = fc.getString("accessToken");
        this.setAccessToken(accessToken, clientSecret);
    }

    public void setAccessToken(String accessToken, String clientSecret) {
        this.m_accessToken = accessToken;
        this.m_clientSecret = clientSecret;
        if (accessToken == null || accessToken.trim().length() == 0) {
            this.logger.warn("Empty accessToken");
        }
        if (clientSecret == null || clientSecret.trim().length() == 0) {
            this.logger.warn("Empty clientSecret");
        }
    }

    public String getAccessToken(String authCode, String clientSecret) throws Exception {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Authorization-Code", authCode);
        headers.put("Client-Secret", clientSecret);
        StringBuffer result = this.callFortnox("", "", null, headers, null);
        StringReader strReader = new StringReader(result.toString());
        ErrorInformation err = this.checkIfError(result);
        if (err != null) {
            throw new FortnoxException(err);
        }
        Authorization auth = (Authorization)JAXB.unmarshal((Reader)strReader, Authorization.class);
        this.m_accessToken = auth.getAccessToken();
        return this.m_accessToken;
    }

    public StringBuffer postFortnox(String route, StringBuffer postContents) throws Exception {
        return this.callFortnox(route, null, postContents, null, "POST");
    }

    public StringBuffer putFortnox(String route, StringBuffer putContents) throws Exception {
        return this.callFortnox(route, null, putContents, null, "PUT");
    }

    public StringBuffer getFortnox(String route, StringBuffer putContents) throws Exception {
        return this.callFortnox(route, null, putContents, null, "GET");
    }

    public StringBuffer deleteFortnox(String route, StringBuffer deleteContents) throws Exception {
        return this.callFortnox(route, null, deleteContents, null, "DELETE");
    }

    private StringBuffer callFortnox(String cmd, String getStr, StringBuffer postContents) throws Exception {
        return this.callFortnox(cmd, getStr, postContents, null, null);
    }

    private StringBuffer callFortnox(String cmd, String getStr, StringBuffer postContents, Map<String, String> headers, String method) throws Exception {
        String line;
        Object request;
        StringBuffer result = new StringBuffer();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String urlStr = this.m_baseUrl;
        if (cmd != null) {
            urlStr = String.valueOf(urlStr) + cmd;
        }
        if (getStr != null) {
            urlStr = String.valueOf(urlStr) + getStr;
        }
        if (headers == null) {
            headers = new TreeMap<String, String>();
        }
        boolean put = "PUT".equalsIgnoreCase(method);
        boolean delete = "DELETE".equalsIgnoreCase(method);
        if (postContents != null) {
            request = put ? new HttpPut(urlStr) : (delete ? new HttpDelete(urlStr) : new HttpPost(urlStr));
            StringEntity entity = new StringEntity(postContents.toString(), "UTF-8");
            if (!put) {
                ((HttpPost)request).setEntity((HttpEntity)entity);
            } else {
                request.setEntity((HttpEntity)entity);
            }
            headers.put("Content-Type", "application/xml");
            this.logger.debug("Posting: \n" + postContents + "\nto " + urlStr);
        } else {
            request = put ? new HttpPut(urlStr) : new HttpGet(urlStr);
            this.logger.debug(String.valueOf(put ? "Putting" : "Getting url") + ": " + urlStr);
        }
        if (this.m_accessToken != null && !headers.containsKey("Access-Token")) {
            headers.put("Access-Token", this.m_accessToken);
        }
        if (this.m_clientSecret != null && !headers.containsKey("Client-Secret")) {
            headers.put("Client-Secret", this.m_clientSecret);
        }
        if (headers != null) {
            for (String s : headers.keySet()) {
                request.setHeader(s, headers.get(s));
            }
        }
        request.setHeader("Accept", "application/xml");
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        BufferedReader rd = new BufferedReader(new InputStreamReader(entity.getContent()));
        while ((line = rd.readLine()) != null) {
            result.append(String.valueOf(line) + "\n");
        }
        entity.consumeContent();
        this.logger.debug("Received reply: \n" + result.toString());
        Thread.sleep(100L);
        return result;
    }

    public Order getOrder(String orderNo) throws Exception {
        Order o = new Order();
        String getStr = URLEncoder.encode(orderNo, "UTF-8");
        StringBuffer result = this.callFortnox("/orders/" + getStr, null, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            o = (Order)JAXB.unmarshal((Reader)in, o.getClass());
            return o;
        }
        throw new FortnoxException(e);
    }

    public Orders getOrders(String filter) throws Exception {
        Orders r = this.getOrders(filter, 0);
        int currentPage = 1;
        int totalPages = r.getTotalPages();
        while (currentPage < totalPages) {
            Thread.sleep(100L);
            Orders subset = this.getOrders(filter, currentPage + 1);
            r.getOrderSubset().addAll(subset.getOrderSubset());
            currentPage = subset.getCurrentPage();
        }
        return r;
    }

    public Orders getOrders(String filter, int page) throws Exception {
        String getStr = "/orders/" + (filter != null && filter.trim().length() > 0 ? "?filter=" + filter.trim() : "");
        String param = page > 0 ? String.valueOf(filter != null && filter.trim().length() > 0 ? "&" : "?") + "page=" + page : null;
        StringBuffer result = this.callFortnox(getStr, param, null);
        ErrorInformation e = this.checkIfError(result);
        Orders r = new Orders();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            r = (Orders)JAXB.unmarshal((Reader)in, r.getClass());
            return r;
        }
        throw new FortnoxException(e);
    }

    public Invoice getInvoice(String invoiceNo) throws Exception {
        Invoice c = new Invoice();
        String getStr = URLEncoder.encode(invoiceNo, "UTF-8");
        StringBuffer result = this.callFortnox("/invoices/" + getStr, null, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            c = (Invoice)JAXB.unmarshal((Reader)in, Invoice.class);
            return c;
        }
        if (ERROR_CANT_FIND_INVOICE.equals(e.getCode())) {
            return null;
        }
        throw new FortnoxException(e);
    }

    public FinancialYearSubset getFinancialYear(Date forDate) throws Exception {
        String getStr;
        StringBuffer out;
        ErrorInformation e;
        FinancialYearSubset result = null;
        if (forDate == null) {
            forDate = Calendar.getInstance().getTime();
        }
        if ((e = this.checkIfError(out = this.callFortnox("/financialyears/", getStr = "?date=" + URLEncoder.encode(s_dfmt.format(forDate), "UTF-8"), null))) == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toString().getBytes()), "UTF-8"));
            FinancialYears list = (FinancialYears)JAXB.unmarshal((Reader)in, FinancialYears.class);
            if (list.getTotalResources() < 1) {
                throw new Exception("No fiscal year for " + forDate);
            }
            result = list.getFinancialYearSubset().get(0);
            return result;
        }
        throw new FortnoxException(e);
    }

    public Voucher getVoucher(int yearId, String series, int voucherNumber) throws Exception, FortnoxException {
        Voucher result = null;
        String getStr = String.valueOf(URLEncoder.encode(series, "UTF-8")) + "/" + voucherNumber + "?financialyear=" + yearId;
        StringBuffer out = this.callFortnox("/vouchers/", getStr, null);
        ErrorInformation e = this.checkIfError(out);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toString().getBytes()), "UTF-8"));
            result = (Voucher)JAXB.unmarshal((Reader)in, Voucher.class);
            return result;
        }
        throw new FortnoxException(e);
    }

    public Accounts getAccounts(int yearId) throws Exception {
        Accounts r = this.getAccounts(yearId, 0);
        int currentPage = 1;
        int totalPages = r.getTotalPages();
        while (currentPage < totalPages) {
            Thread.sleep(100L);
            Accounts subset = this.getAccounts(yearId, currentPage + 1);
            r.getAccountSubset().addAll(subset.getAccountSubset());
            currentPage = subset.getCurrentPage();
        }
        return r;
    }

    public Accounts getAccounts(int yearId, int page) throws Exception {
        Accounts result = null;
        String getStr = "?financialyear=" + yearId + (page > 1 ? "&page=" + page : "");
        StringBuffer out = this.callFortnox("/accounts", getStr, null);
        ErrorInformation e = this.checkIfError(out);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toString().getBytes()), "UTF-8"));
            result = (Accounts)JAXB.unmarshal((Reader)in, Accounts.class);
            return result;
        }
        throw new FortnoxException(e);
    }

    public PreDefinedAccount getPreDefinedAccount(String pname) throws Exception {
        if (pname == null) {
            return null;
        }
        PreDefinedAccount result = null;
        String getStr = pname.toUpperCase();
        StringBuffer out = this.callFortnox("/predefinedaccounts/", getStr, null);
        ErrorInformation e = this.checkIfError(out);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toString().getBytes()), "UTF-8"));
            result = (PreDefinedAccount)JAXB.unmarshal((Reader)in, PreDefinedAccount.class);
            return result;
        }
        throw new FortnoxException(e);
    }

    public PreDefinedAccounts getPreDefinedAccounts() throws Exception {
        PreDefinedAccounts r = this.getPreDefinedAccounts(0);
        int currentPage = 1;
        int totalPages = r.getTotalPages();
        while (currentPage < totalPages) {
            Thread.sleep(100L);
            PreDefinedAccounts subset = this.getPreDefinedAccounts(currentPage + 1);
            r.getPreDefinedAccountSubset().addAll(subset.getPreDefinedAccountSubset());
            currentPage = subset.getCurrentPage();
        }
        return r;
    }

    public PreDefinedAccounts getPreDefinedAccounts(int page) throws Exception {
        PreDefinedAccounts result = null;
        String getStr = page > 1 ? "?page=" + page : "";
        StringBuffer out = this.callFortnox("/predefinedaccounts", getStr, null);
        ErrorInformation e = this.checkIfError(out);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toString().getBytes()), "UTF-8"));
            result = (PreDefinedAccounts)JAXB.unmarshal((Reader)in, PreDefinedAccounts.class);
            return result;
        }
        throw new FortnoxException(e);
    }

    public Map<String, Integer> getRevenueAccountMap(Date acctDate) throws Exception {
        FinancialYearSubset fy = this.getFinancialYear(acctDate);
        return this.getRevenueAccountMap(fy.getId());
    }

    public Map<String, Integer> getRevenueAccountMap(int year) throws Exception {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        String[] stringArray = PREDEFINED_REV_ACCT;
        int n = PREDEFINED_REV_ACCT.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            PreDefinedAccount pa = this.getPreDefinedAccount(s);
            if (pa != null) {
                result.put(s, pa.getAccount());
            }
            ++n2;
        }
        Accounts accounts = this.getAccounts(year);
        TreeSet<Integer> mp2 = new TreeSet<Integer>();
        TreeSet<Integer> mp3 = new TreeSet<Integer>();
        TreeSet<Integer> mp0 = new TreeSet<Integer>();
        TreeSet<Integer> mpNoVAT = new TreeSet<Integer>();
        TreeSet<Integer> exportServices = new TreeSet<Integer>();
        for (AccountSubset as : accounts.getAccountSubset()) {
            if (!as.getNumber().toString().startsWith("3") || !as.getActive().booleanValue()) continue;
            if ("MP2".equals(as.getVATCode())) {
                mp2.add(as.getNumber());
                continue;
            }
            if ("MP3".equals(as.getVATCode())) {
                mp3.add(as.getNumber());
                continue;
            }
            if ("MF".equals(as.getVATCode())) {
                mp0.add(as.getNumber());
                continue;
            }
            if (as.getVATCode() == null || as.getVATCode().trim().length() == 0) {
                mpNoVAT.add(as.getNumber());
                continue;
            }
            if (!"\u00d6TEU".equals(as.getVATCode())) continue;
            exportServices.add(as.getNumber());
        }
        if (mp2.size() > 0) {
            result.put(PREDEFINED_REVENUE_VAT_ACCT[0], (Integer)mp2.first());
        }
        if (mp3.size() > 0) {
            result.put(PREDEFINED_REVENUE_VAT_ACCT[1], (Integer)mp3.first());
        }
        if (mp0.size() > 0) {
            result.put(PREDEFINED_REVENUE_VAT_ACCT[2], (Integer)mp0.first());
        }
        if (mpNoVAT.size() > 0) {
            result.put(PREDEFINED_REVENUE_VAT_ACCT[3], (Integer)mpNoVAT.first());
        }
        if (exportServices.size() > 0) {
            result.put(PREDEFINED_REVENUE_VAT_ACCT[4], (Integer)exportServices.first());
        }
        return result;
    }

    public String performAction(boolean put, String document, String documentNo, String action) throws Exception {
        if (!document.endsWith("s")) {
            document = String.valueOf(document) + "s";
        }
        String getStr = URLEncoder.encode(documentNo, "UTF-8");
        String url = "/" + document + "/" + getStr + "/" + action;
        StringBuffer result = put ? this.putFortnox(url, null) : this.getFortnox(url, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            return result.toString();
        }
        throw new FortnoxException(e);
    }

    public String invoiceGetAction(String invoiceNo, String action) throws Exception {
        return this.performAction(false, "invoice", invoiceNo, action);
    }

    public Order orderPutAction(String orderNo, String action) throws Exception {
        String result = this.performAction(true, "orders", orderNo, action);
        ErrorInformation e = this.checkIfError(new StringBuffer(result));
        Order r = new Order();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            r = (Order)JAXB.unmarshal((Reader)in, r.getClass());
            return r;
        }
        throw new FortnoxException(e);
    }

    public Invoices getInvoices(String filter) throws Exception {
        Invoices r = this.getInvoices(filter, 0);
        int currentPage = 1;
        int totalPages = r.getTotalPages();
        while (currentPage < totalPages) {
            Thread.sleep(100L);
            Invoices subset = this.getInvoices(filter, currentPage + 1);
            r.getInvoiceSubset().addAll(subset.getInvoiceSubset());
            currentPage = subset.getCurrentPage();
        }
        return r;
    }

    public Invoices getInvoices(String filter, int page) throws Exception {
        String filterWord = filter != null && filter.contains("=") ? "" : "filter=";
        StringBuffer result = this.callFortnox("/invoices/" + (filter != null && filter.trim().length() > 0 ? "?" + filterWord + filter.trim() : ""), page > 1 ? String.valueOf(filter != null && filter.trim().length() > 0 ? "&" : "?") + "page=" + page : null, null);
        ErrorInformation e = this.checkIfError(result);
        Invoices r = new Invoices();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            r = (Invoices)JAXB.unmarshal((Reader)in, r.getClass());
            return r;
        }
        throw new FortnoxException(e);
    }

    public Customers getCustomers() throws Exception {
        Customers r = this.getCustomers(0);
        int currentPage = 1;
        int totalPages = r.getTotalPages();
        while (currentPage < totalPages) {
            Thread.sleep(100L);
            Customers subset = this.getCustomers(currentPage + 1);
            r.getCustomerSubset().addAll(subset.getCustomerSubset());
            currentPage = subset.getCurrentPage();
        }
        return r;
    }

    public Customers getCustomers(int page) throws Exception {
        StringBuffer result = this.callFortnox("/customers/", page > 1 ? "?page=" + page : null, null);
        ErrorInformation e = this.checkIfError(result);
        Customers r = new Customers();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            r = (Customers)JAXB.unmarshal((Reader)in, r.getClass());
            return r;
        }
        throw new FortnoxException(e);
    }

    public Suppliers getSuppliers() throws Exception {
        Suppliers r = this.getSuppliers(0);
        int currentPage = 1;
        int totalPages = r.getTotalPages();
        while (currentPage < totalPages) {
            Thread.sleep(100L);
            Suppliers subset = this.getSuppliers(currentPage + 1);
            r.getSupplierSubset().addAll(subset.getSupplierSubset());
            currentPage = subset.getCurrentPage();
        }
        return r;
    }

    public Suppliers getSuppliers(int page) throws Exception {
        StringBuffer result = this.callFortnox("/suppliers/", page > 1 ? "?page=" + page : null, null);
        ErrorInformation e = this.checkIfError(result);
        Suppliers r = new Suppliers();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            r = (Suppliers)JAXB.unmarshal((Reader)in, r.getClass());
            return r;
        }
        throw new FortnoxException(e);
    }

    public Supplier setSupplier(Supplier supplier, boolean createNew) throws Exception {
        StringWriter result = new StringWriter();
        ClassLoader cl = FortnoxClient3.class.getClassLoader();
        JAXBContext jaxbCtx = JAXBContext.newInstance((String)supplier.getClass().getPackage().getName(), (ClassLoader)cl);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)supplier, (Writer)result);
        StringBuffer output = this.callFortnox("/suppliers" + (!createNew ? "/" + supplier.getSupplierNumber() : ""), null, result.getBuffer(), null, !createNew ? "put" : null);
        ErrorInformation e = this.checkIfError(output);
        Supplier c = new Supplier();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(output.toString().getBytes()), "UTF-8"));
            c = (Supplier)JAXB.unmarshal((Reader)in, c.getClass());
            return c;
        }
        if (ERROR_CANT_FIND_CUSTOMER.equals(e.getCode())) {
            return null;
        }
        throw new FortnoxException(e);
    }

    public Supplier getSupplierBySupplierNo(String supplierNo) throws Exception {
        if (supplierNo == null) {
            return null;
        }
        Supplier c = new Supplier();
        String getStr = URLEncoder.encode(supplierNo, "UTF-8");
        StringBuffer result = this.callFortnox("/suppliers/", getStr, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            c = (Supplier)JAXB.unmarshal((Reader)in, c.getClass());
            return c;
        }
        if (ERROR_CANT_FIND_CUSTOMER.equals(e.getCode())) {
            return null;
        }
        throw new FortnoxException(e);
    }

    public synchronized Supplier getSupplierByTaxId(String taxId, boolean isCompany) throws Exception {
        SupplierSubset contact;
        taxId = this.formatTaxId(taxId, isCompany);
        if (this.m_supplierTaxIdLookupMap == null) {
            this.m_supplierTaxIdLookupMap = new TreeMap<String, SupplierSubset>();
            Suppliers suppliers = this.getSuppliers();
            if (suppliers != null && suppliers.getSupplierSubset() != null) {
                for (SupplierSubset c : suppliers.getSupplierSubset()) {
                    if (c.getOrganisationNumber() == null || c.getOrganisationNumber().trim().length() <= 0) continue;
                    this.m_supplierTaxIdLookupMap.put(c.getOrganisationNumber(), c);
                    this.logger.debug("Adding '" + c.getOrganisationNumber() + "' " + c.getName() + " supplierNo " + c.getSupplierNumber());
                }
            }
            while (suppliers.getTotalPages() > suppliers.getCurrentPage()) {
                Thread.sleep(100L);
                suppliers = this.getSuppliers(suppliers.getCurrentPage() + 1);
                if (suppliers == null || suppliers.getSupplierSubset() == null) continue;
                for (SupplierSubset c : suppliers.getSupplierSubset()) {
                    if (c.getOrganisationNumber() == null || c.getOrganisationNumber().trim().length() <= 0) continue;
                    this.m_supplierTaxIdLookupMap.put(c.getOrganisationNumber(), c);
                    this.logger.debug("Adding '" + c.getOrganisationNumber() + "' " + c.getName() + " supplierno " + c.getSupplierNumber());
                }
            }
        }
        if ((contact = this.m_supplierTaxIdLookupMap.get(taxId)) == null && taxId.length() == 13) {
            contact = this.m_supplierTaxIdLookupMap.get(taxId.substring(2));
        }
        if (contact == null) {
            this.logger.warn("Could not find '" + taxId + "'");
            return null;
        }
        return this.getSupplierBySupplierNo(contact.getSupplierNumber());
    }

    public InvoicePayment setCustomerPayment(InvoicePayment payment) throws Exception {
        StringWriter result = new StringWriter();
        ClassLoader cl = FortnoxClient3.class.getClassLoader();
        JAXBContext jaxbCtx = JAXBContext.newInstance((String)payment.getClass().getPackage().getName(), (ClassLoader)cl);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)payment, (Writer)result);
        StringBuffer output = this.callFortnox("/invoicepayments" + (payment.getNumber() != null && payment.getNumber() > 0 ? "/" + payment.getNumber() : ""), null, result.getBuffer(), null, payment.getNumber() != null && payment.getNumber() > 0 ? "put" : null);
        InvoicePayment out = null;
        if (output.toString().contains("ErrorInformation")) {
            System.err.println(output.toString());
            return null;
        }
        StringReader reader = new StringReader(output.toString());
        if (output != null && output.length() > 0) {
            out = (InvoicePayment)JAXB.unmarshal((Reader)reader, InvoicePayment.class);
        }
        return out;
    }

    public Invoice setInvoice(Invoice invoice) throws Exception {
        StringWriter result = new StringWriter();
        ClassLoader cl = FortnoxClient3.class.getClassLoader();
        JAXBContext jaxbCtx = JAXBContext.newInstance((String)invoice.getClass().getPackage().getName(), (ClassLoader)cl);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        for (InvoiceRow ir : invoice.getInvoiceRows().getInvoiceRow()) {
            ir.setTotal(null);
            if (ir.getDescription() != null) {
                ir.setDescription(ir.getDescription().replace('|', ';'));
                ir.setDescription(ir.getDescription().substring(0, Math.min(ir.getDescription().length(), 50)));
                ir.setDescription(FortnoxUtil.removeNonAllowedCharacters(ir.getDescription()));
            }
            if (this.useArticles) continue;
            ir.setArticleNumber(null);
        }
        marshaller.marshal((Object)invoice, (Writer)result);
        StringBuffer output = this.callFortnox("/invoices" + (invoice.getDocumentNumber() != null && invoice.getDocumentNumber().trim().length() > 0 ? "/" + invoice.getDocumentNumber().trim() : ""), null, result.getBuffer(), null, invoice.getDocumentNumber() != null && invoice.getDocumentNumber().trim().length() > 0 ? "put" : null);
        Invoice out = null;
        if (output.toString().contains("ErrorInformation")) {
            System.err.println(output.toString());
            return null;
        }
        StringReader reader = new StringReader(output.toString());
        if (output != null && output.length() > 0) {
            out = (Invoice)JAXB.unmarshal((Reader)reader, Invoice.class);
        }
        return out;
    }

    public Voucher setVoucher(Voucher voucher) throws FortnoxException, Exception {
        StringWriter result = new StringWriter();
        ClassLoader cl = FortnoxClient3.class.getClassLoader();
        JAXBContext jaxbCtx = JAXBContext.newInstance((String)voucher.getClass().getPackage().getName(), (ClassLoader)cl);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        JAXB.marshal((Object)voucher, (Writer)result);
        StringBuffer output = this.callFortnox("/vouchers" + (voucher.getVoucherNumber() != null && voucher.getVoucherNumber() > 0 ? "/" + voucher.getVoucherNumber() : ""), null, result.getBuffer(), null, voucher.getVoucherNumber() != null && voucher.getVoucherNumber() > 0 ? "put" : null);
        Voucher out = null;
        if (output.toString().contains("ErrorInformation")) {
            throw new FortnoxException(output.toString());
        }
        StringReader reader = new StringReader(output.toString());
        if (output != null && output.length() > 0) {
            out = (Voucher)JAXB.unmarshal((Reader)reader, Voucher.class);
        }
        return out;
    }

    public Customer setCustomer(Customer customer) throws Exception {
        StringWriter result = new StringWriter();
        ClassLoader cl = FortnoxClient3.class.getClassLoader();
        JAXBContext jaxbCtx = JAXBContext.newInstance((String)customer.getClass().getPackage().getName(), (ClassLoader)cl);
        Marshaller marshaller = jaxbCtx.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)customer, (Writer)result);
        StringBuffer output = this.callFortnox("/customers", null, result.getBuffer());
        ErrorInformation e = this.checkIfError(output);
        Customer c = new Customer();
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(output.toString().getBytes()), "UTF-8"));
            c = (Customer)JAXB.unmarshal((Reader)in, c.getClass());
            return c;
        }
        if (ERROR_CANT_FIND_CUSTOMER.equals(e.getCode())) {
            return null;
        }
        throw new FortnoxException(e);
    }

    public Customer getCustomerByCustNo(String custNo) throws Exception {
        if (custNo == null) {
            return null;
        }
        Customer c = new Customer();
        String getStr = URLEncoder.encode(custNo, "UTF-8");
        StringBuffer result = this.callFortnox("/customers/", getStr, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            c = (Customer)JAXB.unmarshal((Reader)in, c.getClass());
            return c;
        }
        if (ERROR_CANT_FIND_CUSTOMER.equals(e.getCode())) {
            return null;
        }
        throw new FortnoxException(e);
    }

    public synchronized Customer getCustomerByTaxId(String taxId, boolean isCompany) throws Exception {
        CustomerSubset contact;
        taxId = this.formatTaxId(taxId, isCompany);
        if (this.m_customerTaxIdLookupMap == null) {
            this.m_customerTaxIdLookupMap = new TreeMap<String, CustomerSubset>();
            Customers contacts = this.getCustomers();
            if (contacts != null && contacts.getCustomerSubset() != null) {
                for (CustomerSubset c : contacts.getCustomerSubset()) {
                    if (c.getOrganisationNumber() == null || c.getOrganisationNumber().trim().length() <= 0) continue;
                    this.m_customerTaxIdLookupMap.put(c.getOrganisationNumber(), c);
                    this.logger.debug("Adding '" + c.getOrganisationNumber() + "' " + c.getName() + " custno " + c.getCustomerNumber());
                }
            }
            while (contacts.getTotalPages() > contacts.getCurrentPage()) {
                Thread.sleep(100L);
                contacts = this.getCustomers(contacts.getCurrentPage() + 1);
                if (contacts == null || contacts.getCustomerSubset() == null) continue;
                for (CustomerSubset c : contacts.getCustomerSubset()) {
                    if (c.getOrganisationNumber() == null || c.getOrganisationNumber().trim().length() <= 0) continue;
                    this.m_customerTaxIdLookupMap.put(c.getOrganisationNumber(), c);
                    this.logger.debug("Adding '" + c.getOrganisationNumber() + "' " + c.getName() + " custno " + c.getCustomerNumber());
                }
            }
        }
        if ((contact = this.m_customerTaxIdLookupMap.get(taxId)) == null && taxId.length() == 13) {
            contact = this.m_customerTaxIdLookupMap.get(taxId.substring(2));
        }
        if (contact == null) {
            this.logger.warn("Could not find '" + taxId + "'");
            throw new Exception("Could not find '" + taxId + "'");
        }
        return this.getCustomerByCustNo(contact.getCustomerNumber());
    }

    public void resetContactMaps() {
        this.resetCustomerMap();
    }

    public void resetCustomerMap() {
        this.m_customerTaxIdLookupMap = null;
    }

    public void resetSupplierMap() {
        this.m_supplierTaxIdLookupMap = null;
    }

    public String formatTaxId(String taxId, boolean isCompany) {
        if (taxId == null) {
            return null;
        }
        if (!taxId.contains("-")) {
            String lastDigits = taxId.substring(taxId.length() - 4, taxId.length());
            String firstDigits = taxId.substring(0, taxId.length() - 4);
            taxId = String.valueOf(firstDigits) + "-" + lastDigits;
        }
        if (taxId.length() == 11 && !isCompany) {
            taxId = taxId.startsWith("0") || taxId.startsWith("1") ? "00" + taxId : "19" + taxId;
        }
        return taxId;
    }

    public ErrorInformation checkIfError(StringBuffer buf) throws Exception {
        ErrorInformation e = null;
        int n = buf.toString().indexOf(10);
        int m = buf.toString().indexOf("<ErrorInformation>", n);
        if (m - n > 0) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buf.toString().getBytes()), "UTF-8"));
            e = new ErrorInformation();
            e = (ErrorInformation)JAXB.unmarshal((Reader)in, ErrorInformation.class);
        }
        return e;
    }

    public String getToken() {
        return this.m_clientSecret;
    }

    public void setToken(String token) {
        this.m_clientSecret = token;
    }

    public String getDatabase() {
        return this.m_authCode;
    }

    public void setDatabase(String database) {
        this.m_authCode = database;
    }

    public String getBaseUrl() {
        return this.m_baseUrl;
    }

    public void setBaseUrl(String m_baseUrl) {
        this.m_baseUrl = m_baseUrl;
    }

    public static XMLGregorianCalendar getXMLDate(Date date) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar();
        XMLGregorianCalendar date2 = null;
        if (date != null) {
            cal.setTime(date);
            date2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        return date2;
    }

    public CompanySetting getCompanySetting() throws Exception {
        CompanySetting cs = new CompanySetting();
        StringBuffer result = this.callFortnox("/settings/company", null, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(result.toString().getBytes()), "UTF-8"));
            cs = (CompanySetting)JAXB.unmarshal((Reader)in, cs.getClass());
            return cs;
        }
        throw new FortnoxException(e);
    }

    public boolean markReminderAsSent(Invoice invoice) throws Exception {
        return this.markReminderAsSent(invoice.getDocumentNumber());
    }

    public boolean markReminderAsSent(String documentNo) throws Exception {
        this.invoiceGetAction(documentNo, ACTION_INVOICE_PRINTREMINDER);
        return true;
    }

    public static void main(String[] args) {
        File configFile;
        if (args == null || args.length != 2) {
            System.out.println("Usage: FortnoxClient3 configfile command");
            System.out.println("");
            System.out.println("Possible commands are: getAccessToken");
            System.exit(1);
        }
        if (!(configFile = new File(args[0])).exists() || configFile.isDirectory()) {
            System.out.println(String.valueOf(args[0]) + " is not a configuration file.");
            System.exit(1);
        }
        if ("getAccessToken".equalsIgnoreCase(args[1])) {
            XMLConfiguration config = new XMLConfiguration();
            try {
                config.load(configFile);
                String clientSecret = config.getString("clientSecret");
                String authCode = config.getString("authCode");
                FortnoxClient3 client = new FortnoxClient3();
                String accessToken = client.getAccessToken(authCode, clientSecret);
                System.out.println("Got access token:");
                System.out.println(accessToken);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(String.valueOf(args[1]) + ": unknown command.");
            System.exit(1);
        }
    }

    public StringBuffer search(String document, String field, String value) throws Exception {
        String fieldStr = URLEncoder.encode(field.toLowerCase(), "UTF-8");
        String valueStr = URLEncoder.encode(value, "UTF-8");
        String callStr = "/" + document + "/?" + fieldStr + "=" + valueStr;
        StringBuffer result = this.getFortnox(callStr, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            return result;
        }
        throw new FortnoxException(e);
    }

    public boolean isUseArticles() {
        return this.useArticles;
    }

    public void setUseArticles(boolean useArticles) {
        this.useArticles = useArticles;
    }

    public StringBuffer retrieveSieFile(int sieType, int financialYear) throws Exception {
        StringBuffer result = this.getFortnox("/sie/" + sieType + "?financialyear=" + financialYear, null);
        ErrorInformation e = this.checkIfError(result);
        if (e == null) {
            return result;
        }
        throw new FortnoxException(e);
    }

    public String retrieveSieAndSaveToFile(int sieType, int financialYear, String dir, String fileName) throws Exception {
        StringBuffer result = this.retrieveSieFile(sieType, financialYear);
        File f = new File(String.valueOf(dir) + File.separator + fileName);
        PrintWriter fr = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        fr.append(result);
        fr.close();
        return f.getAbsolutePath();
    }

    public Invoices getAllCustomerInvoicesByDateRange(Date fromDate, Date untilDate) throws Exception {
        String filter = "fromdate=" + s_dfmt.format(fromDate);
        if (untilDate != null) {
            filter = String.valueOf(filter) + "&todate=" + s_dfmt.format(untilDate);
        }
        Invoices result = this.getInvoices(filter);
        return result;
    }

    public Invoices getUnpaidCustomerInvoices() throws Exception {
        Invoices result = this.getInvoices(FILTER_UNPAID);
        return result;
    }
}

