/*
 * Decompiled with CFR 0.152.
 */
package org.notima.businessobjects.adapter.fortnox;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.notima.api.fortnox.FortnoxClient3;
import org.notima.api.fortnox.FortnoxException;
import org.notima.api.fortnox.entities3.CompanySetting;
import org.notima.api.fortnox.entities3.Customer;
import org.notima.api.fortnox.entities3.CustomerSubset;
import org.notima.api.fortnox.entities3.Customers;
import org.notima.api.fortnox.entities3.DefaultDeliveryTypes;
import org.notima.api.fortnox.entities3.EmailInformation;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.api.fortnox.entities3.InvoiceRow;
import org.notima.api.fortnox.entities3.InvoiceRows;
import org.notima.api.fortnox.entities3.InvoiceSubset;
import org.notima.api.fortnox.entities3.Invoices;
import org.notima.api.fortnox.entities3.Order;
import org.notima.generic.businessobjects.BasicBusinessObjectFactory;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.DunningEntry;
import org.notima.generic.businessobjects.DunningRun;
import org.notima.generic.businessobjects.InvoiceLine;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.PaymentTerm;
import org.notima.generic.businessobjects.Person;
import org.notima.generic.businessobjects.PriceList;
import org.notima.generic.businessobjects.Product;
import org.notima.generic.businessobjects.ProductCategory;
import org.notima.generic.businessobjects.Tax;
import org.notima.generic.ifacebusinessobjects.FactoringReservation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortnoxAdapter
extends BasicBusinessObjectFactory<FortnoxClient3, Invoice, Order, Object, Customer> {
    public static final String LIST_EXTERNAL_INVOICE_REFERENCE2 = "InvoiceSubset-ExternalInvoiceReference2";
    public static final String LIST_UNPOSTED = "InvoiceSubset-Unposted";
    public static final String LIST_UNPAID = "InvoiceSubset-Unpaid";
    public static final String LIST_UNPAIDOVERDUE = "InvoiceSubset-UnPaidOverDue";
    private FortnoxClient3 client = new FortnoxClient3();
    private String exportRevenueAccount = null;
    private String defaultRevenueAccount = "3001";
    private String defaultFreightRevenue = "3591";
    private String defaultFreightExportRevenue = "3590";
    private Date currentDate = null;
    private Map<String, Integer> revenueAccountMap = null;
    protected static Logger logger = LoggerFactory.getLogger(FortnoxAdapter.class);

    public FortnoxAdapter() {
    }

    public FortnoxAdapter(String accessToken, String clientSecret) throws Exception {
        this.client.setAccessToken(accessToken, clientSecret);
    }

    public FortnoxClient3 getClient() {
        return this.client;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        if (this.currentDate == null || !this.currentDate.equals(currentDate)) {
            this.revenueAccountMap = null;
        }
        this.currentDate = currentDate;
    }

    public String getRevenueAccount(String type) throws Exception {
        Integer account;
        if (this.revenueAccountMap == null) {
            this.revenueAccountMap = this.client.getRevenueAccountMap(this.currentDate);
        }
        if ((account = this.revenueAccountMap.get(type)) == null) {
            return null;
        }
        if (account == 0) {
            return null;
        }
        return account.toString();
    }

    public BusinessPartner<Customer> lookupBusinessPartner(String key) throws Exception {
        Customer c = this.client.getCustomerByCustNo(key);
        if (c == null) {
            return null;
        }
        return FortnoxAdapter.convert(c);
    }

    public List<BusinessPartner<Customer>> lookupAllBusinessPartners() throws Exception {
        ArrayList<BusinessPartner<Customer>> result = new ArrayList<BusinessPartner<Customer>>();
        Customers contacts = this.client.getCustomers();
        if (contacts != null && contacts.getCustomerSubset() != null) {
            for (CustomerSubset c : contacts.getCustomerSubset()) {
                result.add(FortnoxAdapter.convert(c));
            }
        }
        while (contacts.getTotalPages() > contacts.getCurrentPage()) {
            Thread.sleep(100L);
            contacts = this.client.getCustomers(contacts.getCurrentPage() + 1);
            if (contacts == null || contacts.getCustomerSubset() == null) continue;
            for (CustomerSubset c : contacts.getCustomerSubset()) {
                result.add(FortnoxAdapter.convert(c));
            }
        }
        return result;
    }

    public String getDefaultRevenueAccount() {
        return this.defaultRevenueAccount;
    }

    public void setDefaultRevenueAccount(String defaultRevenueAccount) {
        this.defaultRevenueAccount = defaultRevenueAccount;
    }

    public String getDefaultFreightRevenue() {
        return this.defaultFreightRevenue;
    }

    public void setDefaultFreightRevenue(String defaultFreightRevenue) {
        this.defaultFreightRevenue = defaultFreightRevenue;
    }

    public String getDefaultFreightExportRevenue() {
        return this.defaultFreightExportRevenue;
    }

    public void setDefaultFreightExportRevenue(String defaultFreightExportRevenue) {
        this.defaultFreightExportRevenue = defaultFreightExportRevenue;
    }

    public String getExportRevenueAccount() {
        return this.exportRevenueAccount;
    }

    public void setExportRevenueAccount(String exportRevenueAccount) {
        this.exportRevenueAccount = exportRevenueAccount;
    }

    public org.notima.generic.businessobjects.Invoice<Invoice> lookupInvoice(String key) throws Exception {
        Invoice src = this.client.getInvoice(key);
        org.notima.generic.businessobjects.Invoice<Invoice> dst = FortnoxAdapter.convert(src);
        dst.setDocumentKey(key);
        return dst;
    }

    public Invoice lookupNativeInvoice(String key) throws Exception {
        Invoice raw = this.client.getInvoice(key);
        return raw;
    }

    public org.notima.generic.businessobjects.Order<Order> lookupOrder(String key) throws Exception {
        return null;
    }

    public Product<Object> lookupProduct(String key) throws Exception {
        return null;
    }

    public Product<Object> lookupRoundingProduct() throws Exception {
        return null;
    }

    public Tax lookupTax(String key) throws Exception {
        return null;
    }

    public PaymentTerm lookupPaymentTerm(String key) throws Exception {
        return null;
    }

    public FactoringReservation lookupFactoringReservation(String key) throws Exception {
        return null;
    }

    public List<FactoringReservation> lookupFactoringReservationForOrder(String orderKey) throws Exception {
        return null;
    }

    public List<FactoringReservation> lookupFactoringReservationForInvoice(String invoiceKey) throws Exception {
        return null;
    }

    public Object persist(Object o) throws Exception {
        if (o instanceof org.notima.generic.businessobjects.Invoice) {
            return this.persist((org.notima.generic.businessobjects.Invoice<Invoice>)((org.notima.generic.businessobjects.Invoice)o));
        }
        if (o instanceof BusinessPartner) {
            return this.persistBusinessPartner((BusinessPartner<Customer>)((BusinessPartner)o));
        }
        return null;
    }

    protected org.notima.generic.businessobjects.Invoice<Invoice> persist(org.notima.generic.businessobjects.Invoice<Invoice> invoice) throws Exception {
        Customer cust = this.client.getCustomerByCustNo(invoice.getBusinessPartner().getIdentityNo());
        if (cust == null) {
            cust = FortnoxAdapter.convert(invoice.getBusinessPartner());
            this.client.setCustomer(cust);
        }
        Invoice dst = this.convert(invoice);
        if ((dst = this.client.setInvoice(dst)) == null) {
            throw new Exception("Invoice not saved: " + invoice.getDocumentKey());
        }
        invoice.setDocumentKey(dst.getDocumentNumber());
        invoice.setInvoiceKey(dst.getDocumentNumber());
        return invoice;
    }

    public org.notima.generic.businessobjects.Invoice<Invoice> persistInvoice(org.notima.generic.businessobjects.Invoice<Invoice> invoice) throws Exception {
        return this.persist(invoice);
    }

    public Invoice persistNativeInvoice(Invoice invoice) throws Exception {
        Invoice dst = invoice;
        dst = this.client.setInvoice(dst);
        return dst;
    }

    public BusinessPartner<Customer> persistBusinessPartner(BusinessPartner<Customer> bpartner) throws Exception {
        if (!bpartner.getIsVendor().booleanValue()) {
            Customer dstContact = FortnoxAdapter.convert(bpartner);
            Customer checkContact = null;
            if (dstContact.getCustomerNumber() != null) {
                try {
                    checkContact = this.client.getCustomerByCustNo(dstContact.getCustomerNumber());
                }
                catch (FortnoxException fe) {
                    checkContact = null;
                }
            }
            if (checkContact != null && checkContact.getCustomerNumber() != null && checkContact.getCustomerNumber().trim().length() > 0) {
                dstContact.setCustomerNumber(checkContact.getCustomerNumber());
            } else {
                dstContact.setPriceList("A");
                dstContact.setTermsOfPayment("15");
            }
            dstContact = this.client.setCustomer(dstContact);
            bpartner.setIdentityNo(dstContact.getCustomerNumber());
        }
        return bpartner;
    }

    public static Customer convert(BusinessPartner<?> bpartner) {
        Location delLoc;
        Location loc;
        Customer dstContact = new Customer();
        dstContact.setCustomerNumber(bpartner.getIdentityNo());
        dstContact.setOrganisationNumber(bpartner.getTaxId());
        dstContact.setName(bpartner.getName());
        dstContact.setType(bpartner.isCompany() ? "COMPANY" : "PRIVATE");
        Person contact = null;
        List contacts = bpartner.getContacts();
        if (contacts != null && contacts.size() > 0) {
            contact = (Person)contacts.get(0);
        }
        if (bpartner.isCompany() && contact != null) {
            dstContact.setYourReference(contact.getName());
        }
        if ((loc = bpartner.getAddressOfficial()) != null) {
            dstContact.setAddress1(loc.getAddress1());
            dstContact.setAddress2(loc.getAddress2());
            if (loc.getAddress1() == null || loc.getAddress1().trim().length() == 0) {
                dstContact.setAddress1(loc.getStreet());
                if (loc.getHouseNo() != null && loc.getHouseNo().trim().length() > 0) {
                    dstContact.setAddress1(String.valueOf(dstContact.getAddress1()) + " " + loc.getHouseNo());
                }
            }
            if (loc.getCo() != null && loc.getCo().trim().length() > 0) {
                dstContact.setAddress2(String.valueOf(dstContact.getAddress1()) + (dstContact.getAddress2() != null && dstContact.getAddress2().trim().length() > 0 ? " " + dstContact.getAddress2() : ""));
                dstContact.setAddress1(loc.getCo());
            }
            dstContact.setCity(loc.getCity());
            dstContact.setZipCode(loc.getPostal());
            dstContact.setCountryCode(loc.getCountryCode());
            if (dstContact.getEmail() == null) {
                dstContact.setEmail(loc.getEmail());
            }
            if (dstContact.getPhone1() == null) {
                dstContact.setPhone1(loc.getPhone());
            }
        }
        if ((delLoc = bpartner.getAddressShipping()) != null) {
            dstContact.setDeliveryAddress1(delLoc.getAddress1());
            dstContact.setDeliveryAddress2(delLoc.getAddress2());
            if (delLoc.getAddress1() == null || delLoc.getAddress1().trim().length() == 0) {
                dstContact.setDeliveryAddress1(delLoc.getStreet());
                if (delLoc.getHouseNo() != null && delLoc.getHouseNo().trim().length() > 0) {
                    dstContact.setDeliveryAddress1(String.valueOf(dstContact.getAddress1()) + " " + delLoc.getHouseNo());
                }
            }
            if (delLoc.getCo() != null && delLoc.getCo().trim().length() > 0) {
                dstContact.setDeliveryAddress2(String.valueOf(dstContact.getDeliveryAddress1()) + (dstContact.getDeliveryAddress2() != null && dstContact.getDeliveryAddress2().trim().length() > 0 ? " " + dstContact.getDeliveryAddress2() : ""));
                dstContact.setDeliveryAddress1(delLoc.getCo());
            }
            dstContact.setCity(delLoc.getCity());
            dstContact.setZipCode(delLoc.getPostal());
            dstContact.setCountryCode(delLoc.getCountryCode());
        }
        return dstContact;
    }

    public Invoice convert(org.notima.generic.businessobjects.Invoice<Invoice> src) throws Exception {
        BusinessPartner bp;
        Invoice dst = new Invoice();
        Customer dstContact = new Customer();
        if (src.getDocumentKey() != null && src.getDocumentKey().trim().length() > 0) {
            dst.setDocumentNumber(src.getDocumentKey());
        }
        BusinessPartner businessPartner = bp = src.getBillBpartner() != null ? src.getBillBpartner() : src.getBusinessPartner();
        if (bp.getIdentityNo() == null) {
            throw new Exception("Can not yet create new invoices without the customer already in Fortnox");
        }
        dstContact.setCustomerNumber(bp.getIdentityNo());
        dstContact.setName(bp.getName());
        dst.setCustomerNumber(bp.getIdentityNo());
        dst.setCustomerName(bp.getName());
        Calendar cal = Calendar.getInstance();
        if (src.getDocumentDate() != null) {
            cal.setTime(src.getDocumentDate());
        }
        dst.setInvoiceDate(FortnoxClient3.s_dfmt.format(cal.getTime()));
        Calendar dueCal = Calendar.getInstance();
        dueCal.setTime(cal.getTime());
        if (src.getDueDate() != null) {
            dueCal.setTime(src.getDueDate());
        } else {
            dueCal.add(6, 10);
        }
        int days = (int)((dueCal.getTimeInMillis() - cal.getTimeInMillis()) / 86400000L);
        if (src.getPaymentTermKey() != null && src.getPaymentTermKey().trim().length() > 0) {
            dst.setTermsOfPayment(src.getPaymentTermKey());
        } else if (days < 2) {
            dst.setTermsOfPayment("0");
        } else if (days < 12) {
            dst.setTermsOfPayment("10");
        } else if (days < 17) {
            dst.setTermsOfPayment("15");
        } else if (days < 25) {
            dst.setTermsOfPayment("20");
        } else {
            dst.setTermsOfPayment("30");
        }
        dst.setDueDate(FortnoxClient3.s_dfmt.format(dueCal.getTime()));
        if (src.getDeliveryDate() != null) {
            dst.setDeliveryDate(FortnoxClient3.s_dfmt.format(src.getDeliveryDate()));
        }
        dst.setCurrency(src.getCurrency());
        if (src.getOrderKey() != null || src.getPoDocumentNo() != null) {
            dst.setYourOrderNumber(src.getOrderKey());
            dst.setExternalInvoiceReference2(src.getOrderKey());
        }
        InvoiceRows rows = new InvoiceRows();
        dst.setInvoiceRows(rows);
        ArrayList<InvoiceRow> rowList = new ArrayList<InvoiceRow>();
        rows.setInvoiceRow(rowList);
        for (InvoiceLine il : src.getLines()) {
            if ("\u00f6resavrundning".equals(il.getName())) {
                dst.setRoundOff(il.getPriceActual());
                continue;
            }
            InvoiceRow row = new InvoiceRow();
            row.setArticleNumber(il.getProductKey());
            row.setDescription(il.getName() != null ? il.getName() : il.getDescription());
            row.setDeliveredQuantity(il.getQtyEntered());
            if (il.getAccountNo() == null || il.getAccountNo().trim().length() == 0) {
                String accountNo = null;
                if ("MP1".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALES");
                } else if ("MP2".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALES_MP2");
                } else if ("MP3".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALES_MP3");
                } else if ("MP0".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALES_MP0");
                } else if ("FTEU".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALESEUREV2");
                } else if ("VTEU".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALESEUREV");
                } else if ("E".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALESEXPORT");
                } else if ("ES".equals(il.getTaxKey())) {
                    accountNo = this.getRevenueAccount("SALESEXPORT2");
                }
                if (accountNo == null) {
                    if (il.getTaxPercent() == 0.0) {
                        accountNo = this.getRevenueAccount("SALES_NOVAT");
                    } else if (il.getTaxPercent() == 6.0) {
                        accountNo = this.getRevenueAccount("SALES_MP3");
                    } else if (il.getTaxPercent() == 12.0) {
                        accountNo = this.getRevenueAccount("SALES_MP2");
                    } else if (il.getTaxPercent() == 25.0) {
                        accountNo = this.getRevenueAccount("SALES");
                    }
                }
                if (accountNo == null) {
                    accountNo = this.defaultRevenueAccount;
                }
                row.setAccountNumber(accountNo);
            } else {
                row.setAccountNumber(il.getAccountNo());
            }
            if (il.getPriceActual() != null) {
                if (il.isPricesIncludeVAT()) {
                    row.setPrice(il.getPriceActual() - il.getTaxAmount() / il.getQtyEntered());
                    row.setPrice((double)Math.round(row.getPrice() * 100.0) / 100.0);
                } else {
                    row.setPrice((double)il.getPriceActual());
                }
                row.setVAT(il.getTaxPercent());
            } else {
                row.setPrice(null);
                row.setVAT(null);
            }
            row.setUnit(il.getUOM());
            rowList.add(row);
        }
        return dst;
    }

    public static org.notima.generic.businessobjects.Invoice<Invoice> convert(Invoice src) throws Exception {
        org.notima.generic.businessobjects.Invoice dst = new org.notima.generic.businessobjects.Invoice();
        dst.setNativeInvoice((Object)src);
        dst.setDocumentKey(src.getDocumentNumber());
        dst.setOrderKey(src.getOrderReference());
        dst.setDocumentDate(FortnoxClient3.s_dfmt.parse(src.getInvoiceDate()));
        if (src.getDeliveryDate() != null && src.getDeliveryDate().trim().length() > 0) {
            try {
                dst.setDeliveryDate(FortnoxClient3.s_dfmt.parse(src.getDeliveryDate()));
            }
            catch (ParseException pe) {
                logger.warn("Can't parse delivery date " + src.getDeliveryDate() + " on invoice " + src.getDocumentNumber());
            }
        }
        dst.setGrandTotal(src.getTotal().doubleValue());
        dst.setOpenAmt(src.getBalance().doubleValue());
        dst.setCurrency(src.getCurrency());
        dst.setDueDate(FortnoxClient3.s_dfmt.parse(src.getDueDate()));
        dst.setOcr(src.getOCR());
        dst.setNetTotal(src.getNet().doubleValue());
        dst.setPoDocumentNo(src.getExternalInvoiceReference2());
        dst.setPaymentTermKey(src.getTermsOfPayment());
        if (src.getInvoicePeriodStart() != null) {
            try {
                dst.setContractStartDate(FortnoxClient3.s_dfmt.parse(src.getInvoicePeriodStart()));
            }
            catch (Exception pe) {
                // empty catch block
            }
        }
        if (src.getInvoicePeriodEnd() != null) {
            try {
                dst.setContractEndDate(FortnoxClient3.s_dfmt.parse(src.getInvoicePeriodEnd()));
            }
            catch (Exception pe) {
                // empty catch block
            }
        }
        BusinessPartner dstBp = new BusinessPartner();
        dstBp.setName(src.getCustomerName());
        String orgNo = src.getOrganisationNumber();
        if (orgNo.length() > 11) {
            orgNo = orgNo.substring(2, orgNo.length());
        }
        dstBp.setTaxId(orgNo);
        dstBp.setIdentityNo(src.getCustomerNumber());
        dstBp.setEmailInvoice(false);
        dstBp.setLanguage("sv_SE");
        dstBp.setCompany(orgNo.startsWith("55"));
        dst.setBusinessPartner(dstBp);
        Person billPerson = new Person(src.getYourReference());
        dst.setBillPerson(billPerson);
        Location billLocation = new Location();
        billLocation.setAddress1(src.getAddress1());
        billLocation.setAddress2(src.getAddress2());
        billLocation.setPostal(src.getZipCode());
        billLocation.setCity(src.getCity());
        if ("Sverige".equalsIgnoreCase(src.getCountry())) {
            billLocation.setCountryCode("SE");
        } else {
            billLocation.setCountryCode(src.getCountry());
        }
        dst.setBillLocation(billLocation);
        dst.setShipLocation(billLocation);
        EmailInformation einfo = src.getEmailInformation();
        if (einfo != null && einfo.getEmailAddressTo() != null && einfo.getEmailAddressTo().contains("@")) {
            dst.getBillLocation().setEmail(einfo.getEmailAddressTo());
            dstBp.setEmailInvoice(true);
        }
        InvoiceRows rows = src.getInvoiceRows();
        for (InvoiceRow r : rows.getInvoiceRow()) {
            dst.addInvoiceLine(FortnoxAdapter.convert(r));
        }
        if (src.getRoundOff() != 0.0) {
            InvoiceRow ir = new InvoiceRow();
            ir.setPrice(src.getRoundOff());
            ir.setDescription("\u00f6resavrundning");
            ir.setDeliveredQuantity(1.0);
            ir.setVAT(0.0);
            ir.setDeliveredQuantity(1.0);
            dst.addInvoiceLine(FortnoxAdapter.convert(ir));
        }
        return dst;
    }

    public static InvoiceLine convert(InvoiceRow src) {
        InvoiceLine dst = new InvoiceLine();
        dst.setKey(src.getArticleNumber());
        dst.setName(src.getDescription());
        dst.setPriceActual(src.getPrice());
        dst.setQtyEntered(src.getDeliveredQuantity().doubleValue());
        dst.setTaxPercent(src.getVAT().doubleValue());
        dst.setUOM(src.getUnit());
        dst.setAccountNo(src.getAccountNumber());
        return dst;
    }

    public static BusinessPartner<Customer> convert(Customer src) {
        BusinessPartner dst = new BusinessPartner();
        dst.setName(src.getName());
        dst.setIdentityNo(src.getCustomerNumber());
        dst.setTaxId(src.getOrganisationNumber());
        Location loc = new Location();
        dst.setAddressOfficial(loc);
        loc.setEmail(src.getEmail());
        loc.setAddress1(src.getAddress1());
        loc.setAddress2(src.getAddress2());
        loc.setCity(src.getCity());
        loc.setPostal(src.getZipCode());
        loc.setPhone(src.getPhone1());
        loc.setCountryCode(src.getCountryCode());
        dst.setCompany("COMPANY".equalsIgnoreCase(src.getType()));
        DefaultDeliveryTypes ddt = src.getDefaultDeliveryTypes();
        if (ddt != null && "EMAIL".equalsIgnoreCase(ddt.getInvoice())) {
            dst.setEmailInvoice(true);
        }
        if (src.getDeliveryAddress1() != null && src.getDeliveryAddress1().trim().length() > 0) {
            loc = new Location();
            dst.setAddressOfficial(loc);
            loc.setAddress1(src.getDeliveryAddress1());
            loc.setAddress2(src.getDeliveryAddress2());
            loc.setCity(src.getDeliveryCity());
            loc.setPostal(src.getDeliveryZipCode());
            loc.setPhone(src.getDeliveryPhone1());
            loc.setCountryCode(src.getDeliveryCountryCode());
        }
        return dst;
    }

    public static BusinessPartner<Customer> convert(CustomerSubset src) {
        BusinessPartner dst = new BusinessPartner();
        dst.setName(src.getName());
        dst.setIdentityNo(src.getCustomerNumber());
        dst.setTaxId(src.getOrganisationNumber());
        Location loc = new Location();
        dst.setAddressOfficial(loc);
        loc.setEmail(src.getEmail());
        loc.setCity(src.getCity());
        loc.setPostal(src.getZipCode());
        loc.setPhone(src.getPhone());
        return dst;
    }

    public Product<Object> lookupProductByEan(String ean) throws Exception {
        return null;
    }

    public List<Product<Object>> lookupProductByName(String name) throws Exception {
        return null;
    }

    public Map<Object, Object> lookupList(String listName) throws Exception {
        if (LIST_EXTERNAL_INVOICE_REFERENCE2.equalsIgnoreCase(listName)) {
            Invoices invoices = this.client.getInvoices(null);
            TreeMap<Object, Object> result = new TreeMap<Object, Object>();
            if (invoices != null && invoices.getInvoiceSubset() != null) {
                for (InvoiceSubset is : invoices.getInvoiceSubset()) {
                    if (is.getExternalInvoiceReference2() == null) continue;
                    result.put(is.getExternalInvoiceReference2(), is);
                }
            }
            return result;
        }
        if (LIST_UNPOSTED.equalsIgnoreCase(listName)) {
            Map<Object, Object> result = this.getFiltered("unbooked");
            return result;
        }
        if (LIST_UNPAIDOVERDUE.equalsIgnoreCase(listName)) {
            Map<Object, Object> result = this.getFiltered("unpaidoverdue");
            return result;
        }
        return null;
    }

    private Map<Object, Object> getFiltered(String filter) throws Exception {
        Invoices invoices = this.client.getInvoices(filter);
        TreeMap<Object, Object> result = new TreeMap<Object, Object>();
        if (invoices != null && invoices.getInvoiceSubset() != null) {
            for (InvoiceSubset is : invoices.getInvoiceSubset()) {
                if (is.getDocumentNumber() == null) continue;
                result.put(is.getDocumentNumber(), is);
            }
        }
        return result;
    }

    public boolean isConnected() throws Exception {
        return false;
    }

    public void destroy() throws Exception {
    }

    public DunningRun<Customer, Invoice> lookupDunningRun(String key) throws Exception {
        DunningRun dr = new DunningRun();
        boolean excludeNegativeOpenAmount = key != null && "excludeNegativeOpenAmount".equalsIgnoreCase(key);
        Map<Object, Object> overdueList = this.lookupList(LIST_UNPAIDOVERDUE);
        CompanySetting cs = this.client.getCompanySetting();
        for (Object o : overdueList.keySet()) {
            org.notima.generic.businessobjects.Invoice<Invoice> invoice = this.lookupInvoice(o.toString());
            DunningEntry de = new DunningEntry();
            de.setCreditor(this.convert(cs));
            de.setBgNo(this.getBgNo(cs));
            de.setDebtor(invoice.getBusinessPartner());
            de.getDebtor().setAddressOfficial(invoice.getBillLocation());
            de.setOcrNo(invoice.getOcr());
            de.setLetterNo(invoice.getDocumentKey());
            invoice.setPaymentTermKey(((InvoiceLine)invoice.getLines().get(0)).getName());
            if (invoice == null || excludeNegativeOpenAmount && invoice.getOpenAmt() < 0.0) continue;
            de.addInvoice(invoice);
            dr.addDunningEntry(de);
        }
        return dr;
    }

    public BusinessPartner<Customer> convert(CompanySetting cs) {
        BusinessPartner creditor = new BusinessPartner();
        Location adress = new Location();
        adress.setAddress1(cs.getAdress());
        adress.setCity(cs.getCity());
        adress.setPostal(cs.getZipCode());
        adress.setCountryCode(cs.getCountryCode());
        adress.setPhone(cs.getPhone1());
        adress.setEmail(cs.getEmail());
        creditor.setAddressOfficial(adress);
        creditor.setName(cs.getName());
        creditor.setTaxId(cs.getOrganizationNumber());
        return creditor;
    }

    public String getBgNo(CompanySetting cs) {
        return cs.getBg();
    }

    public Order lookupNativeOrder(String key) throws Exception {
        return null;
    }

    public Order persistNativeOrder(Order order) throws Exception {
        return null;
    }

    public PriceList lookupPriceForProduct(String productKey, String currency, Boolean salesPriceList) throws Exception {
        return null;
    }

    public List<ProductCategory> lookupProductCategory(String key) throws Exception {
        return null;
    }

    public BusinessPartner<CompanySetting> lookupThisCompanyInformation() throws Exception {
        CompanySetting cs = this.client.getCompanySetting();
        BusinessPartner result = new BusinessPartner();
        result.setName(cs.getName());
        result.setTaxId(cs.getOrganizationNumber());
        result.setVatNo(cs.getVatNumber());
        result.setIdentityNo(cs.getDatabaseNumber());
        result.setNativeBusinessPartner((Object)cs);
        Location officialAddress = new Location();
        officialAddress.setAddress1(cs.getAdress());
        officialAddress.setCity(cs.getCity());
        officialAddress.setCountryCode(cs.getCountryCode());
        officialAddress.setPostal(cs.getZipCode());
        officialAddress.setEmail(cs.getEmail());
        officialAddress.setPhone(cs.getPhone1());
        result.setAddressOfficial(officialAddress);
        Location shipAddress = new Location();
        shipAddress.setAddress1(cs.getVisitAddress());
        shipAddress.setCity(cs.getVisitCity());
        shipAddress.setCountryCode(cs.getVisitCountryCOde());
        shipAddress.setPostal(cs.getVisitZipCode());
        result.setAddressShipping(shipAddress);
        return result;
    }

    public List<BusinessPartner<Customer>> lookupBusinessPartners(int maxCount, boolean customers, boolean suppliers) throws Exception {
        return null;
    }
}

