/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.fortnox;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Header;
import org.notima.api.fortnox.Fortnox4JSettings;
import org.notima.api.fortnox.FortnoxClient3;
import org.notima.api.fortnox.entities3.CompanySetting;
import org.notima.api.fortnox.entities3.Customer;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.api.fortnox.entities3.InvoicePayment;
import org.notima.api.fortnox.entities3.InvoiceSubset;
import org.notima.api.fortnox.entities3.Invoices;
import org.notima.api.fortnox.entities3.Order;
import org.notima.api.fortnox.entities3.OrderSubset;
import org.notima.api.fortnox.entities3.Orders;
import org.notima.api.fortnox.entities3.Supplier;
import org.notima.api.fortnox.entities3.Voucher;
import org.notima.api.fortnox.entities3.WriteOff;
import org.notima.api.fortnox.entities3.WriteOffs;
import org.notima.businessobjects.adapter.fortnox.FortnoxAdapter;
import org.notima.businessobjects.adapter.fortnox.FortnoxConverter;
import org.notima.generic.businessobjects.BasicBusinessObjectConverter;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.Payment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortnoxClient {
    private Map<String, Invoice> invoiceMap;
    private Map<String, Order> orderMap;
    private String mapAccessToken;
    private String clientName;
    private String taxId;
    public static String DEFAULT_NEW_SUPPLIER_NAME = "Supplier created by Fortnox4J";
    private String lastClientSecret;
    private String lastAccessToken;
    private FortnoxAdapter bof;
    private Logger log = LoggerFactory.getLogger(FortnoxClient.class);

    public String retrieveAccessTokenFromApiCode(@Header(value="clientSecret") String clientSecret, @Header(value="apiCode") String apiCode) throws Exception {
        if (clientSecret == null || apiCode == null) {
            return null;
        }
        FortnoxClient3 client = new FortnoxClient3();
        String accessToken = client.getAccessToken(apiCode, clientSecret);
        return accessToken;
    }

    public boolean isLastAccessToken(String accessToken) {
        if (accessToken == null || this.lastAccessToken == null) {
            return false;
        }
        return accessToken.equals(this.lastAccessToken);
    }

    public FortnoxAdapter getFortnoxAdapter(String accessToken, String clientSecret) throws Exception {
        if (this.lastClientSecret == null || this.lastAccessToken == null || !this.lastClientSecret.equals(clientSecret) || !this.lastAccessToken.equals(accessToken)) {
            this.bof = null;
        }
        if (this.bof == null) {
            this.bof = new FortnoxAdapter(accessToken, clientSecret);
            this.lastAccessToken = accessToken;
            this.lastClientSecret = clientSecret;
        }
        return this.bof;
    }

    public List<Invoice> getInvoicesWithPaymentTerm(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="paymentTerm") String pt) throws Exception {
        ArrayList<Invoice> result = new ArrayList<Invoice>();
        if (pt == null) {
            return result;
        }
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        Map unposted = this.bof.lookupList("InvoiceSubset-Unposted");
        for (Object invoiceNo : unposted.keySet()) {
            Invoice finvoice = this.bof.lookupNativeInvoice((String)invoiceNo);
            if (!(pt.equalsIgnoreCase(finvoice.getTermsOfPayment()) & finvoice.isNotCompleted() == false)) continue;
            result.add(finvoice);
        }
        return result;
    }

    public Invoice getFortnoxInvoice(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="invoiceNo") String invoiceNo) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        Invoice finvoice = this.bof.lookupNativeInvoice(invoiceNo);
        return finvoice;
    }

    public CompanySetting getCompanySetting(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        CompanySetting cs = this.bof.getClient().getCompanySetting();
        return cs;
    }

    public String getClientName(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken) throws Exception {
        CompanySetting cs = this.getCompanySetting(clientSecret, accessToken);
        String result = null;
        if (cs != null) {
            result = cs.getName();
        }
        return result;
    }

    public Supplier getSupplierByOrgNo(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="orgNo") String orgNo, @Header(value="createIfNotFound") Boolean createIfNotFound) throws Exception {
        if (createIfNotFound == null) {
            createIfNotFound = Boolean.TRUE;
        }
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        Supplier supplier = this.bof.getClient().getSupplierByTaxId(orgNo, true);
        if (supplier == null) {
            supplier = new Supplier();
            supplier.setSupplierNumber(orgNo);
            supplier.setOrganisationNumber(orgNo);
            supplier.setName(String.valueOf(DEFAULT_NEW_SUPPLIER_NAME) + " : " + orgNo);
            supplier = this.bof.getClient().setSupplier(supplier, true);
        }
        return supplier;
    }

    public List<Invoice> getFortnoxInvoices(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="filter") String filter) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        ArrayList<Invoice> result = null;
        Invoices invoices = this.bof.getClient().getInvoices(filter);
        if (invoices != null && invoices.getInvoiceSubset() != null) {
            result = new ArrayList<Invoice>();
            for (InvoiceSubset ii : invoices.getInvoiceSubset()) {
                Invoice inv = this.bof.getClient().getInvoice(ii.getDocumentNumber());
                result.add(inv);
            }
        }
        return result;
    }

    public List<org.notima.generic.businessobjects.Invoice> getOverdueInvoices(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken) throws Exception {
        ArrayList<org.notima.generic.businessobjects.Invoice> result = new ArrayList<org.notima.generic.businessobjects.Invoice>();
        List<Invoice> finvoices = this.getFortnoxInvoices(clientSecret, accessToken, "unpaidoverdue");
        if (finvoices != null) {
            for (Invoice ii : finvoices) {
                result.add(FortnoxAdapter.convert((Invoice)ii));
            }
        }
        return result;
    }

    public String invoiceAction(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="invoiceNo") String invoiceNo, @Header(value="action") String action) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        String result = this.bof.getClient().invoiceGetAction(invoiceNo, action);
        return result;
    }

    public Map<String, Invoice> getInvoiceMap(String clientSecret, String accessToken, String referenceField, String invoiceRefRegEx) throws Exception {
        if (this.invoiceMap == null || !accessToken.equals(this.mapAccessToken)) {
            this.log.info("Refreshing invoiceMap. This might take some time...");
            this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
            CompanySetting cs = this.bof.getClient().getCompanySetting();
            this.clientName = cs.getName();
            this.taxId = cs.getOrganizationNumber();
            this.invoiceMap = new TreeMap<String, Invoice>();
            Invoices invoices = this.bof.getClient().getInvoices("unpaid");
            Invoices unposted = this.bof.getClient().getInvoices("unbooked");
            List subsetList = invoices.getInvoiceSubset();
            if (subsetList != null) {
                if (unposted.getInvoiceSubset() != null) {
                    subsetList.addAll(unposted.getInvoiceSubset());
                }
            } else {
                subsetList = unposted.getInvoiceSubset();
            }
            if (subsetList == null) {
                return this.invoiceMap;
            }
            this.log.info("{} invoices to map up.", (Object)subsetList.size());
            Pattern re = null;
            Matcher m = null;
            if (invoiceRefRegEx != null && invoiceRefRegEx.trim().length() > 0) {
                re = Pattern.compile(invoiceRefRegEx);
            }
            int invoiceCount = 0;
            Invoice existing = null;
            String refInFortnox = null;
            for (InvoiceSubset ii : subsetList) {
                Invoice i = this.bof.getClient().getInvoice(ii.getDocumentNumber());
                if ("YourOrderNumber".equalsIgnoreCase(referenceField)) {
                    refInFortnox = i.getYourOrderNumber();
                } else if ("ExternalInvoiceReference1".equalsIgnoreCase(referenceField)) {
                    refInFortnox = ii.getExternalInvoiceReference1();
                } else if ("ExternalInvoiceReference2".equalsIgnoreCase(referenceField)) {
                    refInFortnox = ii.getExternalInvoiceReference2();
                } else if ("InvoiceReference".equalsIgnoreCase(referenceField)) {
                    refInFortnox = i.getInvoiceReference();
                } else if ("OCR".equalsIgnoreCase(referenceField)) {
                    refInFortnox = i.getOCR();
                } else if ("OrderReference".equalsIgnoreCase(referenceField)) {
                    refInFortnox = i.getOrderReference();
                } else if ("OurReference".equalsIgnoreCase(referenceField)) {
                    refInFortnox = i.getOurReference();
                } else if ("YourReference".equalsIgnoreCase(referenceField)) {
                    refInFortnox = i.getYourReference();
                }
                if (re != null && refInFortnox != null && (m = re.matcher(refInFortnox)).matches()) {
                    refInFortnox = m.groupCount() > 0 ? m.group(1) : m.group();
                }
                if (refInFortnox != null && refInFortnox.trim().length() > 0) {
                    existing = this.invoiceMap.get(refInFortnox = refInFortnox.trim());
                    if (existing == null) {
                        this.invoiceMap.put(refInFortnox, i);
                    } else {
                        this.log.warn("Duplicate reference for [" + refInFortnox + "] in field " + referenceField + ".");
                        this.log.warn("Keeping invoice # " + existing.getDocumentNumber() + " and skipping invoice # " + i.getDocumentNumber());
                    }
                } else {
                    this.log.info("Fortnox Invoice " + i.getDocumentNumber() + " has no reference in [" + referenceField + "].");
                }
                if (++invoiceCount % 100 != 0) continue;
                this.log.info("{} invoices mapped...", (Object)invoiceCount);
            }
            this.mapAccessToken = accessToken;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cached " + this.invoiceMap.size() + " invoices for " + this.taxId + " : " + this.clientName);
            }
        }
        return this.invoiceMap;
    }

    public Map<String, Order> getOrderMap(String clientSecret, String accessToken, String referenceField, String refRegEx) throws Exception {
        if (this.orderMap == null || !accessToken.equals(this.mapAccessToken)) {
            this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
            CompanySetting cs = this.bof.getClient().getCompanySetting();
            this.clientName = cs.getName();
            this.taxId = cs.getOrganizationNumber();
            this.orderMap = new TreeMap<String, Order>();
            Orders orders = this.bof.getClient().getOrders("invoicenotcreated");
            List subsetList = orders.getOrderSubset();
            if (subsetList == null) {
                return this.orderMap;
            }
            Pattern re = null;
            Matcher m = null;
            if (refRegEx != null && refRegEx.trim().length() > 0) {
                re = Pattern.compile(refRegEx);
            }
            int orderCount = 0;
            String fortnoxRef = null;
            for (OrderSubset ii : subsetList) {
                Order i = this.bof.getClient().getOrder(ii.getDocumentNumber());
                if ("yourOrderNumber".equals(referenceField)) {
                    fortnoxRef = i.getYourOrderNumber();
                }
                if (re != null && fortnoxRef != null && (m = re.matcher(fortnoxRef)).matches()) {
                    fortnoxRef = m.groupCount() > 0 ? m.group(1) : m.group();
                }
                if (fortnoxRef != null) {
                    this.orderMap.put(fortnoxRef, i);
                } else {
                    this.log.debug("No ref found for order " + i.getDocumentNumber());
                }
                if (++orderCount % 100 != 0) continue;
                this.log.info("{} orders mapped...", (Object)orderCount);
            }
            this.mapAccessToken = accessToken;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cached " + this.orderMap.size() + " orders for " + this.taxId + " : " + this.clientName);
            }
        }
        return this.orderMap;
    }

    public FortnoxClient getThis() {
        return this;
    }

    public synchronized Invoice getInvoiceToPay(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="invoiceRef") String invoiceRef, @Header(value="invoiceRefType") String invoiceRefType, @Header(value="reconciliationDate") Date reconciliationDate, @Header(value="refRegEx") String invoiceRefRegEx) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        Invoice invoice = null;
        String invoiceNo = null;
        String orderNo = null;
        if (invoiceRef != null && invoiceRef.trim().length() > 0) {
            Order order = null;
            if (invoiceRefType == null || invoiceRefType.equalsIgnoreCase("invoice") || invoiceRefType.equalsIgnoreCase("DocumentNumber")) {
                invoiceNo = invoiceRef;
            } else if (invoiceRefType.equalsIgnoreCase("order")) {
                orderNo = invoiceRef;
                try {
                    order = this.bof.getClient().getOrder(orderNo);
                    if (order.getInvoiceReference() == null || order.getInvoiceReference().trim().length() == 0) {
                        order = this.createInvoiceFromOrderNo(this.bof, orderNo, reconciliationDate);
                    }
                    invoiceNo = order.getInvoiceReference();
                }
                catch (Exception ee) {
                    this.log.info("Can't lookup order [" + orderNo + "]: " + ee.getMessage());
                }
            } else {
                invoice = this.getInvoiceMap(clientSecret, accessToken, invoiceRefType, invoiceRefRegEx).get(invoiceRef);
                if (invoice == null) {
                    if (!invoiceRefType.toLowerCase().contains("invoice") && !invoiceRefType.toLowerCase().contains("ocr") && (order = this.getOrderMap(clientSecret, accessToken, invoiceRefType, invoiceRefRegEx).get(invoiceRef)) != null) {
                        order = this.createInvoiceFromOrderNo(this.bof, order.getDocumentNumber(), reconciliationDate);
                        invoiceNo = order.getInvoiceReference();
                    }
                } else {
                    invoiceNo = invoice.getDocumentNumber();
                }
            }
        }
        if (invoiceNo != null && invoice == null) {
            invoice = this.bof.getClient().getInvoice(invoiceNo);
        }
        return invoice;
    }

    public InvoicePayment payCustomerInvoice(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="modeOfPayment") String modeOfPayment, @Header(value="invoice") Invoice invoice, @Header(value="bookkeepPayment") Boolean bookkeepPayment, Payment payment) throws Exception {
        Date invoiceDate;
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        InvoicePayment pmt = null;
        if (invoice == null) {
            this.log.warn("No invoice found for payment " + payment.toString());
            return pmt;
        }
        payment.setInvoiceNo(invoice.getDocumentNumber());
        if (bookkeepPayment == null) {
            bookkeepPayment = Boolean.TRUE;
        }
        if ((invoiceDate = FortnoxClient3.s_dfmt.parse(invoice.getInvoiceDate())).after(payment.getPaymentDate())) {
            payment.setPaymentDate(invoiceDate);
        }
        if ((pmt = FortnoxConverter.toFortnoxPayment((Payment)payment)).getCurrency() == null || !pmt.getCurrency().equals("EUR")) {
            double diff;
            double sumWriteOffs = 0.0;
            if (pmt.getWriteOffs() != null && pmt.getWriteOffs().getWriteOff() != null) {
                for (WriteOff wo : pmt.getWriteOffs().getWriteOff()) {
                    sumWriteOffs += wo.getAmount().doubleValue();
                }
            }
            if ((diff = pmt.getAmount() + sumWriteOffs - invoice.getBalance()) != 0.0 && Math.abs(diff) < 1.0) {
                WriteOff wo = new WriteOff();
                wo.setCurrency(pmt.getCurrency());
                wo.setAmount(Double.valueOf(-diff));
                wo.setAccountNumber(this.bof.getRevenueAccount("ROUNDOFF"));
                if (pmt.getWriteOffs() == null) {
                    WriteOffs wofs = new WriteOffs();
                    pmt.setWriteOffs(wofs);
                    ArrayList<WriteOff> wofsl = wofs.getWriteOff();
                    if (wofsl == null) {
                        wofsl = new ArrayList<WriteOff>();
                        wofs.setWriteOff(wofsl);
                    }
                    wofsl.add(wo);
                }
            }
        }
        if (modeOfPayment != null) {
            pmt.setModeOfPayment(modeOfPayment);
        }
        if (!invoice.isBooked().booleanValue()) {
            this.bof.getClient().performAction(true, "invoice", Integer.toString(pmt.getInvoiceNumber()), "bookkeep");
        }
        if (pmt.getAmount() == 0.0 && (pmt.getWriteOffs() == null || pmt.getWriteOffs().getWriteOff() == null || pmt.getWriteOffs().getWriteOff().isEmpty())) {
            this.log.info("Payment for invoice " + pmt.getInvoiceNumber() + " is empty. Not processing.");
            return pmt;
        }
        pmt = this.bof.getClient().setCustomerPayment(pmt);
        if (bookkeepPayment.booleanValue() && pmt != null && pmt.getModeOfPayment() != null && pmt.getModeOfPaymentAccount() != null && pmt.getModeOfPaymentAccount() > 0) {
            this.bof.getClient().performAction(true, "invoicepayment", Integer.toString(pmt.getNumber()), "bookkeep");
        }
        return pmt;
    }

    private Order createInvoiceFromOrderNo(FortnoxAdapter bof, String orderNo, Date invoiceDate) throws Exception {
        Order result = bof.getClient().orderPutAction(orderNo, "createinvoice");
        Invoice invoice = bof.getClient().getInvoice(result.getInvoiceReference());
        invoice.setInvoiceDate(FortnoxClient3.s_dfmt.format(invoiceDate));
        bof.persistNativeInvoice(invoice);
        bof.getClient().performAction(true, "invoice", invoice.getDocumentNumber(), "bookkeep");
        return result;
    }

    public String persistInvoice(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, Invoice invoice) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        Invoice result = this.bof.persistNativeInvoice(invoice);
        return result.getDocumentNumber();
    }

    public org.notima.generic.businessobjects.Invoice persistInvoiceFromCanoncialOrder(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="canonicalOrder") org.notima.generic.businessobjects.Order order, @Header(value="useArticles") Boolean useArticles, @Header(value="invoiceDate") Date invoiceDate, @Header(value="defaultRevenueAccount") String defaultRevenueAccount) throws Exception {
        if (order == null || order.getLines() == null || order.getLines().size() == 0) {
            throw new Exception("Can't persist invoice from order. The order is either null or missing order lines");
        }
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        if (defaultRevenueAccount != null) {
            this.bof.setDefaultRevenueAccount(defaultRevenueAccount);
        }
        BasicBusinessObjectConverter bbc = new BasicBusinessObjectConverter();
        org.notima.generic.businessobjects.Invoice invoice = bbc.toInvoice(order);
        Customer fortnoxCustomer = this.persistCustomerFromCanonical(clientSecret, accessToken, order.getBusinessPartner());
        invoice.setBusinessPartner(FortnoxAdapter.convert((Customer)fortnoxCustomer));
        if (invoiceDate != null) {
            invoice.setInvoiceDate(invoiceDate);
        }
        this.bof.getClient().setUseArticles(useArticles != null && useArticles != false);
        org.notima.generic.businessobjects.Invoice result = (org.notima.generic.businessobjects.Invoice)this.bof.persist((Object)invoice);
        return result;
    }

    public Customer persistCustomerFromCanonical(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="businessPartner") BusinessPartner bp) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        Customer result = null;
        if (bp.getbPartnerId() != 0) {
            result = this.bof.getClient().getCustomerByCustNo(Integer.toString(bp.getbPartnerId()));
            if (bp.getTaxId() != null && bp.getTaxId().trim().length() > 0 && result.getOrganisationNumber() != null && result.getOrganisationNumber().trim().length() > 0 && !this.bof.getClient().formatTaxId(bp.getTaxId(), bp.isCompany()).equals(this.bof.getClient().formatTaxId(result.getOrganisationNumber(), bp.isCompany()))) {
                this.log.warn("Customer number " + bp.getbPartnerId() + " and org no " + bp.getTaxId() + " doesn't match. Lookup using tax id");
                try {
                    result = this.bof.getClient().getCustomerByTaxId(bp.getTaxId(), bp.isCompany());
                    bp.setbPartnerId(Integer.parseInt(result.getCustomerNumber()));
                }
                catch (Exception e) {
                    if (!e.getMessage().contains(this.bof.getClient().formatTaxId(bp.getTaxId(), bp.isCompany()))) {
                        throw e;
                    }
                    result = null;
                }
            }
        } else if (bp.getIdentityNo() != null && bp.getIdentityNo().trim().length() > 0) {
            result = this.bof.getClient().getCustomerByCustNo(bp.getIdentityNo());
        }
        if (result == null && bp.getTaxId() != null && bp.getTaxId().trim().length() > 0) {
            try {
                result = this.bof.getClient().getCustomerByTaxId(bp.getTaxId(), bp.isCompany());
            }
            catch (Exception e) {
                if (!e.getMessage().contains(this.bof.getClient().formatTaxId(bp.getTaxId(), bp.isCompany()))) {
                    throw e;
                }
                result = null;
            }
        }
        if (result == null) {
            result = this.bof.getClient().setCustomer(FortnoxAdapter.convert((BusinessPartner)bp));
        }
        return result;
    }

    public String accountTransfer(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="reconciliationDate") Date acctDate, @Header(value="totalAmount") Double totalAmount, @Header(value="creditAcct") String creditAcct, @Header(value="debitAcct") String debitAcct, @Header(value="transferDescription") String description, @Header(value="voucherSeries") String voucherSeries) throws Exception {
        Date trxDate = null;
        trxDate = acctDate == null ? Calendar.getInstance().getTime() : acctDate;
        FortnoxConverter ftx = new FortnoxConverter();
        Voucher voucher = ftx.createSingleTransactionVoucher(voucherSeries, trxDate, creditAcct, debitAcct, totalAmount.doubleValue(), description);
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        FortnoxClient3 client = this.bof.getClient();
        voucher = client.setVoucher(voucher);
        return String.valueOf(voucher.getVoucherSeries()) + voucher.getVoucherNumber();
    }

    public String accountFee(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="reconciliationDate") Date acctDate, @Header(value="feeTotal") Double totalAmount, @Header(value="feeVat") Double vatAmount, @Header(value="feeAccount") String feeAccount, @Header(value="srcAccount") String srcAccount, @Header(value="vatAccount") String vatAccount, @Header(value="feeDescription") String description, @Header(value="voucherSeries") String voucherSeries) throws Exception {
        Date trxDate = null;
        trxDate = acctDate == null ? Calendar.getInstance().getTime() : acctDate;
        FortnoxConverter ftx = new FortnoxConverter();
        Voucher voucher = ftx.createSingleCostWithVatTransactionVoucher(voucherSeries, trxDate, srcAccount, feeAccount, vatAccount, totalAmount.doubleValue(), vatAmount.doubleValue(), description);
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        FortnoxClient3 client = this.bof.getClient();
        voucher = client.setVoucher(voucher);
        return String.valueOf(voucher.getVoucherSeries()) + voucher.getVoucherNumber();
    }

    public String getSettingFromSupplier(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="supplierOrgNo") String supplierOrgNo, @Header(value="settingKey") String settingKey) throws Exception {
        Map<String, String> map = this.getSettingsFromSupplier(clientSecret, accessToken, supplierOrgNo);
        if (map != null) {
            return map.get(settingKey);
        }
        return null;
    }

    public Map<String, String> getSettingsFromSupplier(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="supplierOrgNo") String supplierOrgNo) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        FortnoxClient3 client = this.bof.getClient();
        Fortnox4JSettings settings = new Fortnox4JSettings(client);
        return settings.getSettingsFromSupplierByOrgNo(supplierOrgNo);
    }

    public Supplier writeSettingToSupplier(@Header(value="clientSecret") String clientSecret, @Header(value="accessToken") String accessToken, @Header(value="supplierOrgNo") String supplierOrgNo, @Header(value="settingKey") String settingKey, @Header(value="settingValue") String settingValue) throws Exception {
        this.bof = this.getFortnoxAdapter(accessToken, clientSecret);
        FortnoxClient3 client = this.bof.getClient();
        Fortnox4JSettings settings = new Fortnox4JSettings(client);
        return settings.writeSettingToSupplierByOrgNo(supplierOrgNo, settingKey, settingValue);
    }
}

