/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.fortnox;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Header;
import org.notima.api.fortnox.Fortnox4JSettings;
import org.notima.api.fortnox.FortnoxClient3;
import org.notima.api.fortnox.FortnoxException;
import org.notima.api.fortnox.FortnoxInvoiceException;
import org.notima.api.fortnox.FortnoxScopeException;
import org.notima.api.fortnox.clients.FortnoxCredentials;
import org.notima.api.fortnox.entities3.CompanySetting;
import org.notima.api.fortnox.entities3.Currency;
import org.notima.api.fortnox.entities3.Customer;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.api.fortnox.entities3.InvoicePayment;
import org.notima.api.fortnox.entities3.InvoiceSubset;
import org.notima.api.fortnox.entities3.Invoices;
import org.notima.api.fortnox.entities3.Order;
import org.notima.api.fortnox.entities3.OrderSubset;
import org.notima.api.fortnox.entities3.Orders;
import org.notima.api.fortnox.entities3.Supplier;
import org.notima.api.fortnox.entities3.Voucher;
import org.notima.api.fortnox.entities3.WriteOff;
import org.notima.api.fortnox.entities3.WriteOffs;
import org.notima.api.fortnox.oauth2.FortnoxOAuth2Client;
import org.notima.businessobjects.adapter.fortnox.FortnoxAdapter;
import org.notima.businessobjects.adapter.fortnox.FortnoxConverter;
import org.notima.businessobjects.adapter.fortnox.FortnoxExtendedClient;
import org.notima.generic.businessobjects.BasicBusinessObjectConverter;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.Payment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortnoxClient {
    private Map<String, Invoice> invoiceMap;
    private Map<String, List<Invoice>> invoiceReferenceMap;
    private Map<String, Order> orderMap;
    private String mapOrgNo;
    private String clientName;
    private String taxId;
    private String referenceField;
    public static String DEFAULT_NEW_SUPPLIER_NAME = "Supplier created by Fortnox4J";
    private String lastClientOrgNo;
    private FortnoxAdapter bof;
    private Logger log = LoggerFactory.getLogger(FortnoxClient.class);
    private Map<String, Currency> currencies = new TreeMap<String, Currency>();

    public FortnoxCredentials retrieveAccessTokenFromApiCode(@Header(value="clientId") String clientId, @Header(value="clientSecret") String clientSecret, @Header(value="apiCode") String apiCode, @Header(value="redirectUri") String redirectUri) throws Exception {
        if (clientId == null || clientSecret == null || apiCode == null) {
            return null;
        }
        FortnoxCredentials key = FortnoxOAuth2Client.getAccessToken((String)clientId, (String)clientSecret, (String)apiCode, (String)redirectUri);
        return key;
    }

    public boolean isLastAccessToken(String accessToken) {
        if (accessToken == null || this.lastClientOrgNo == null) {
            return false;
        }
        return accessToken.equals(this.lastClientOrgNo);
    }

    public FortnoxAdapter getFortnoxAdapter(String orgNo) throws Exception {
        if (this.lastClientOrgNo == null || !this.lastClientOrgNo.equals(orgNo)) {
            this.bof = null;
        }
        if (this.bof == null) {
            this.bof = new FortnoxAdapter(orgNo);
            this.lastClientOrgNo = orgNo;
        }
        return this.bof;
    }

    public FortnoxClient3 getCurrentFortnoxClient() {
        return this.bof.getClient();
    }

    public List<Invoice> getInvoicesWithPaymentTerm(@Header(value="orgNo") String orgNo, @Header(value="paymentTerm") String pt) throws Exception {
        ArrayList<Invoice> result = new ArrayList<Invoice>();
        if (pt == null) {
            return result;
        }
        this.bof = this.getFortnoxAdapter(orgNo);
        Map unposted = this.bof.lookupList("InvoiceSubset-Unposted");
        for (Object invoiceNo : unposted.keySet()) {
            Invoice finvoice = this.bof.lookupNativeInvoice((String)invoiceNo);
            if (!(pt.equalsIgnoreCase(finvoice.getTermsOfPayment()) & finvoice.isNotCompleted() == false)) continue;
            result.add(finvoice);
        }
        return result;
    }

    public Invoice getFortnoxInvoice(@Header(value="orgNo") String orgNo, @Header(value="invoiceNo") String invoiceNo) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        Invoice finvoice = this.bof.lookupNativeInvoice(invoiceNo);
        return finvoice;
    }

    public CompanySetting getCompanySetting(@Header(value="orgNo") String orgNo) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        CompanySetting cs = this.bof.getClient().getCompanySetting();
        return cs;
    }

    public String getClientName(@Header(value="orgNo") String orgNo) throws Exception {
        CompanySetting cs = this.getCompanySetting(orgNo);
        String result = null;
        if (cs != null) {
            result = cs.getName();
        }
        return result;
    }

    public Supplier getSupplierByOrgNo(@Header(value="orgNo") String orgNo, @Header(value="createIfNotFound") Boolean createIfNotFound) throws Exception {
        if (createIfNotFound == null) {
            createIfNotFound = Boolean.TRUE;
        }
        this.bof = this.getFortnoxAdapter(orgNo);
        Supplier supplier = this.bof.getClient().getSupplierByTaxId(orgNo, true);
        if (supplier == null) {
            supplier = new Supplier();
            supplier.setSupplierNumber(orgNo);
            supplier.setOrganisationNumber(orgNo);
            supplier.setName(DEFAULT_NEW_SUPPLIER_NAME + " : " + orgNo);
            supplier = this.bof.getClient().setSupplier(supplier, true);
        }
        return supplier;
    }

    public List<Invoice> getFortnoxInvoices(@Header(value="orgNo") String orgNo, @Header(value="filter") String filter) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        ArrayList<Invoice> result = null;
        Invoices invoices = this.bof.getClient().getInvoices(filter);
        if (invoices != null && invoices.getInvoiceSubset() != null) {
            result = new ArrayList<Invoice>();
            for (InvoiceSubset ii : invoices.getInvoiceSubset()) {
                Invoice inv = this.bof.getClient().getInvoice(ii.getDocumentNumber());
                result.add(inv);
            }
        }
        return result;
    }

    public List<org.notima.generic.businessobjects.Invoice> getOverdueInvoices(@Header(value="orgNo") String orgNo) throws Exception {
        ArrayList<org.notima.generic.businessobjects.Invoice> result = new ArrayList<org.notima.generic.businessobjects.Invoice>();
        List<Invoice> finvoices = this.getFortnoxInvoices(orgNo, "unpaidoverdue");
        if (finvoices != null) {
            for (Invoice ii : finvoices) {
                result.add(FortnoxAdapter.convertToCanonicalInvoice((Invoice)ii));
            }
        }
        return result;
    }

    public String invoiceAction(@Header(value="orgNo") String orgNo, @Header(value="invoiceNo") String invoiceNo, @Header(value="action") String action) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        String result = this.bof.getClient().invoiceGetAction(invoiceNo, action);
        return result;
    }

    public Map<String, List<Invoice>> getInvoiceMap(String orgNo, String referenceField, String invoiceRefRegEx) throws Exception {
        if (this.invoiceReferenceMap == null || !orgNo.equals(this.mapOrgNo)) {
            this.referenceField = referenceField;
            this.log.info("Refreshing invoiceMap using " + referenceField + ". This might take some time...");
            this.bof = this.getFortnoxAdapter(orgNo);
            CompanySetting cs = this.bof.getClient().getCompanySetting();
            this.clientName = cs.getName();
            this.taxId = cs.getOrganizationNumber();
            this.invoiceReferenceMap = new TreeMap<String, List<Invoice>>();
            this.invoiceMap = new TreeMap<String, Invoice>();
            Invoices invoices = this.bof.getClient().getInvoices("unpaid");
            Invoices unposted = this.bof.getClient().getInvoices("unbooked");
            List subsetList = invoices.getInvoiceSubset();
            if (subsetList != null) {
                if (unposted.getInvoiceSubset() != null) {
                    subsetList.addAll(unposted.getInvoiceSubset());
                }
            } else {
                subsetList = unposted.getInvoiceSubset();
            }
            if (subsetList == null) {
                return this.invoiceReferenceMap;
            }
            this.log.info("{} invoices to map up.", (Object)subsetList.size());
            Pattern re = null;
            Matcher m = null;
            if (invoiceRefRegEx != null && invoiceRefRegEx.trim().length() > 0) {
                re = Pattern.compile(invoiceRefRegEx);
            }
            int invoiceCount = 0;
            List<Invoice> existing = null;
            String refInFortnox = null;
            for (InvoiceSubset ii : subsetList) {
                Invoice i = this.bof.getClient().getInvoice(ii.getDocumentNumber());
                if (i.getBalance() != null && i.getBalance().equals(0.0)) {
                    this.log.info("Fortnox Invoice " + i.getDocumentNumber() + " has no open balance. Skipping.");
                    continue;
                }
                refInFortnox = this.getInvoiceReference(i);
                if (re != null && refInFortnox != null && (m = re.matcher(refInFortnox)).matches()) {
                    refInFortnox = m.groupCount() > 0 ? m.group(1) : m.group();
                }
                if (refInFortnox != null && refInFortnox.trim().length() > 0) {
                    existing = this.invoiceReferenceMap.get(refInFortnox = refInFortnox.trim());
                    if (existing == null) {
                        existing = new ArrayList<Invoice>();
                        this.invoiceReferenceMap.put(refInFortnox, existing);
                    }
                    existing.add(i);
                } else {
                    this.log.info("Fortnox Invoice " + i.getDocumentNumber() + " has no reference in [" + referenceField + "].");
                }
                this.invoiceMap.put(i.getDocumentNumber(), i);
                if (++invoiceCount % 100 != 0) continue;
                this.log.info("{} invoices mapped...", (Object)invoiceCount);
            }
            this.mapOrgNo = orgNo;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cached " + this.invoiceReferenceMap.size() + " invoices for " + this.taxId + " : " + this.clientName);
            }
        }
        return this.invoiceReferenceMap;
    }

    public String getInvoiceReference(Invoice i) {
        String refInFortnox = null;
        if ("YourOrderNumber".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getYourOrderNumber();
        } else if ("ExternalInvoiceReference1".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getExternalInvoiceReference1();
        } else if ("ExternalInvoiceReference2".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getExternalInvoiceReference2();
        } else if ("InvoiceReference".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getInvoiceReference();
        } else if ("OCR".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getOCR();
        } else if ("OrderReference".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getOrderReference();
        } else if ("OurReference".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getOurReference();
        } else if ("YourReference".equalsIgnoreCase(this.referenceField)) {
            refInFortnox = i.getYourReference();
        }
        return refInFortnox;
    }

    public Map<String, Order> getOrderMap(String orgNo, String referenceField, String refRegEx) throws Exception {
        if (this.orderMap == null || !orgNo.equals(this.mapOrgNo)) {
            this.bof = this.getFortnoxAdapter(orgNo);
            CompanySetting cs = this.bof.getClient().getCompanySetting();
            this.clientName = cs.getName();
            this.taxId = cs.getOrganizationNumber();
            this.orderMap = new TreeMap<String, Order>();
            Orders orders = this.bof.getClient().getOrders("invoicenotcreated");
            List subsetList = orders.getOrderSubset();
            if (subsetList == null) {
                return this.orderMap;
            }
            Pattern re = null;
            Matcher m = null;
            if (refRegEx != null && refRegEx.trim().length() > 0) {
                re = Pattern.compile(refRegEx);
            }
            int orderCount = 0;
            String fortnoxRef = null;
            for (OrderSubset ii : subsetList) {
                Order i = this.bof.getClient().getOrder(ii.getDocumentNumber());
                if ("yourOrderNumber".equals(referenceField)) {
                    fortnoxRef = i.getYourOrderNumber();
                }
                if (re != null && fortnoxRef != null && (m = re.matcher(fortnoxRef)).matches()) {
                    fortnoxRef = m.groupCount() > 0 ? m.group(1) : m.group();
                }
                if (fortnoxRef != null) {
                    this.orderMap.put(fortnoxRef, i);
                } else {
                    this.log.debug("No ref found for order " + i.getDocumentNumber());
                }
                if (++orderCount % 100 != 0) continue;
                this.log.info("{} orders mapped...", (Object)orderCount);
            }
            this.mapOrgNo = orgNo;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cached " + this.orderMap.size() + " orders for " + this.taxId + " : " + this.clientName);
            }
        }
        return this.orderMap;
    }

    public FortnoxClient getThis() {
        return this;
    }

    public synchronized List<Invoice> getInvoiceToPay(@Header(value="orgNo") String orgNo, @Header(value="invoiceRef") String invoiceRef, @Header(value="invoiceRefType") String invoiceRefType, @Header(value="reconciliationDate") Date reconciliationDate, @Header(value="refRegEx") String invoiceRefRegEx) throws Exception {
        Invoice invoice;
        this.bof = this.getFortnoxAdapter(orgNo);
        List<Invoice> invoices = null;
        String invoiceNo = null;
        String orderNo = null;
        if (invoiceRef != null && invoiceRef.trim().length() > 0) {
            Order order = null;
            if (invoiceRefType == null || invoiceRefType.equalsIgnoreCase("invoice") || invoiceRefType.equalsIgnoreCase("DocumentNumber")) {
                invoiceNo = invoiceRef;
            } else if (invoiceRefType.equalsIgnoreCase("order")) {
                this.log.debug("Looking up invoice for order " + orderNo);
                orderNo = invoiceRef;
                try {
                    order = this.bof.getClient().getOrder(orderNo);
                    if (order.getInvoiceReference() == null || order.getInvoiceReference().trim().length() == 0) {
                        order = this.createInvoiceFromOrderNo(this.bof, orderNo, reconciliationDate);
                    }
                    invoiceNo = order.getInvoiceReference();
                }
                catch (Exception ee) {
                    this.log.info("Can't lookup order [" + orderNo + "]: " + ee.getMessage());
                }
            } else {
                invoices = this.getInvoiceMap(orgNo, invoiceRefType, invoiceRefRegEx).get(invoiceRef);
                if (invoices == null && !invoiceRefType.toLowerCase().contains("invoice") && !invoiceRefType.toLowerCase().contains("ocr") && (order = this.getOrderMap(orgNo, invoiceRefType, invoiceRefRegEx).get(invoiceRef)) != null) {
                    order = this.createInvoiceFromOrderNo(this.bof, order.getDocumentNumber(), reconciliationDate);
                    invoiceNo = order.getInvoiceReference();
                }
            }
        }
        if (invoiceNo != null && invoices == null && (invoice = this.bof.getClient().getInvoice(invoiceNo)) != null) {
            invoices = new ArrayList<Invoice>();
            invoices.add(invoice);
        }
        return invoices;
    }

    public InvoicePayment payCustomerInvoice(@Header(value="orgNo") String orgNo, @Header(value="modeOfPayment") String modeOfPayment, @Header(value="invoice") Invoice invoice, @Header(value="bookkeepPayment") Boolean bookkeepPayment, Payment payment) throws Exception {
        Date invoiceDate;
        this.bof = this.getFortnoxAdapter(orgNo);
        InvoicePayment pmt = null;
        if (invoice == null) {
            this.log.warn("No invoice found for payment " + payment.toString());
            return pmt;
        }
        payment.setInvoiceNo(invoice.getDocumentNumber());
        if (bookkeepPayment == null) {
            bookkeepPayment = Boolean.TRUE;
        }
        if ((invoiceDate = FortnoxClient3.s_dfmt.parse(invoice.getInvoiceDate())).after(payment.getPaymentDate())) {
            payment.setPaymentDate(invoiceDate);
        }
        if ((pmt = FortnoxConverter.toFortnoxPayment((Payment)payment)).getCurrency() == null || !pmt.getCurrency().equals("EUR")) {
            double diff;
            double sumWriteOffs = 0.0;
            if (pmt.getWriteOffs() != null && pmt.getWriteOffs().getWriteOff() != null) {
                for (WriteOff wo : pmt.getWriteOffs().getWriteOff()) {
                    sumWriteOffs += wo.getAmount().doubleValue();
                }
            }
            if ((diff = pmt.getAmount() + sumWriteOffs - invoice.getBalance()) != 0.0 && Math.abs(diff) < 1.0) {
                WriteOff wo = new WriteOff();
                wo.setCurrency(pmt.getCurrency());
                wo.setAmount(Double.valueOf(-diff));
                wo.setAccountNumber(this.bof.getRevenueAccount("ROUNDOFF"));
                if (pmt.getWriteOffs() == null) {
                    WriteOffs wofs = new WriteOffs();
                    pmt.setWriteOffs(wofs);
                    ArrayList<WriteOff> wofsl = wofs.getWriteOff();
                    if (wofsl == null) {
                        wofsl = new ArrayList<WriteOff>();
                        wofs.setWriteOff(wofsl);
                    }
                    wofsl.add(wo);
                }
            }
        }
        if (modeOfPayment != null) {
            pmt.setModeOfPayment(modeOfPayment);
        }
        if (!invoice.isBooked().booleanValue()) {
            this.bof.getClient().performAction(true, "invoice", Integer.toString(pmt.getInvoiceNumber()), "bookkeep");
        }
        if (pmt.getAmount() == 0.0 && (pmt.getWriteOffs() == null || pmt.getWriteOffs().getWriteOff() == null || pmt.getWriteOffs().getWriteOff().isEmpty())) {
            this.log.info("Payment for invoice " + pmt.getInvoiceNumber() + " is empty. Not processing.");
            return pmt;
        }
        if (!pmt.isDefaultAccountingCurrency()) {
            Currency currency;
            if (!pmt.hasCurrencyRate() && (currency = this.getCurrency(pmt.getCurrency())) != null) {
                pmt.setCurrencyRate(Double.valueOf(currency.getBuyRate()));
            }
            pmt.currencyConvertBeforeCreation();
        }
        pmt.setCurrency(null);
        pmt = this.bof.getClient().setCustomerPayment(pmt);
        if (bookkeepPayment.booleanValue() && pmt != null && pmt.getModeOfPayment() != null && pmt.getModeOfPaymentAccount() != null && pmt.getModeOfPaymentAccount() > 0) {
            this.bof.getClient().performAction(true, "invoicepayment", Integer.toString(pmt.getNumber()), "bookkeep");
            this.removeFromInvoiceMapIfFullyPaid(pmt.getInvoiceNumber().toString());
        }
        return pmt;
    }

    private Currency getCurrency(String code) throws Exception {
        Currency currency = this.currencies.get(code = code.toUpperCase());
        if (currency == null && (currency = this.getCurrentFortnoxClient().getCurrency(code)) != null) {
            this.currencies.put(code, currency);
        }
        return currency;
    }

    private void removeFromInvoiceMapIfFullyPaid(String invoiceNumber) {
        if (this.invoiceMap == null || this.invoiceMap.isEmpty()) {
            return;
        }
        try {
            Invoice invoice = this.bof.getClient().getInvoice(invoiceNumber);
            if (invoice != null && invoice.getBalance() == 0.0) {
                this.invoiceMap.remove(invoice.getDocumentNumber());
                this.removeFromReferenceMap(invoice);
            }
            if (invoice == null) {
                this.log.warn("Invoice " + invoiceNumber + " not found when trying to remove from invoice map.");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void removeFromReferenceMap(Invoice invoice) {
        String reference = this.getInvoiceReference(invoice);
        List<Invoice> invoices = this.invoiceReferenceMap.get(reference);
        if (invoices != null && invoices.size() > 0) {
            int removeIdx = -1;
            for (int i = 0; i < invoices.size(); ++i) {
                if (!invoice.getDocumentNumber().equals(invoices.get(i).getDocumentNumber())) continue;
                removeIdx = i;
                break;
            }
            if (removeIdx >= 0) {
                invoices.remove(removeIdx);
                this.log.info("Invoice " + invoice.getDocumentNumber() + " with external reference " + reference + " was fully paid and removed from reference map.");
            }
        }
    }

    private Order createInvoiceFromOrderNo(FortnoxAdapter bof, String orderNo, Date invoiceDate) throws Exception {
        Order result = bof.getClient().orderPutAction(orderNo, "createinvoice");
        Invoice invoice = bof.getClient().getInvoice(result.getInvoiceReference());
        invoice.setInvoiceDate(FortnoxClient3.s_dfmt.format(invoiceDate));
        bof.persistNativeInvoice(invoice);
        bof.getClient().performAction(true, "invoice", invoice.getDocumentNumber(), "bookkeep");
        return result;
    }

    public String persistInvoice(@Header(value="orgNo") String orgNo, Invoice invoice) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        Invoice result = this.bof.persistNativeInvoice(invoice);
        return result.getDocumentNumber();
    }

    public org.notima.generic.businessobjects.Invoice persistInvoiceFromCanoncialOrder(@Header(value="orgNo") String orgNo, @Header(value="canonicalOrder") org.notima.generic.businessobjects.Order order, @Header(value="useArticles") Boolean useArticles, @Header(value="invoiceDate") Date invoiceDate, @Header(value="defaultRevenueAccount") String defaultRevenueAccount) throws FortnoxInvoiceException, FortnoxScopeException, Exception {
        if (order == null || order.getLines() == null || order.getLines().size() == 0) {
            throw new Exception("Can't persist invoice from order. The order is either null or missing order lines");
        }
        this.bof = this.getFortnoxAdapter(orgNo);
        if (defaultRevenueAccount != null) {
            this.bof.setDefaultRevenueAccount(defaultRevenueAccount);
        }
        BasicBusinessObjectConverter bbc = new BasicBusinessObjectConverter();
        org.notima.generic.businessobjects.Invoice invoice = bbc.toInvoice(order);
        Customer fortnoxCustomer = this.persistCustomerFromCanonical(orgNo, order.getBusinessPartner());
        invoice.setBusinessPartner(FortnoxConverter.convertToBusinessPartner((Customer)fortnoxCustomer));
        if (invoiceDate != null) {
            invoice.setInvoiceDate(invoiceDate);
        }
        this.bof.getClient().setUseArticles(useArticles != null && useArticles != false);
        org.notima.generic.businessobjects.Invoice result = (org.notima.generic.businessobjects.Invoice)this.bof.persist((Object)invoice);
        return result;
    }

    public Customer persistCustomerFromCanonical(@Header(value="orgNo") String orgNo, @Header(value="businessPartner") BusinessPartner bp) throws Exception {
        Customer result = this.lookupExistingCustomerUsingCanonical(orgNo, bp);
        if (result == null) {
            result = this.bof.getClient().setCustomer(FortnoxAdapter.convertFromBusinessPartner((BusinessPartner)bp));
        }
        return result;
    }

    public Customer lookupExistingCustomerUsingCanonical(@Header(value="orgNo") String orgNo, @Header(value="businessPartner") BusinessPartner bp) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        Customer result = null;
        if (bp.getbPartnerId() != 0) {
            result = this.bof.getClient().getCustomerByCustNo(Integer.toString(bp.getbPartnerId()));
            if (bp.getTaxId() != null && bp.getTaxId().trim().length() > 0 && result.getOrganisationNumber() != null && result.getOrganisationNumber().trim().length() > 0) {
                this.bof.getClient();
                String string = FortnoxClient3.formatTaxId((String)bp.getTaxId(), (boolean)bp.isCompany());
                this.bof.getClient();
                if (!string.equals(FortnoxClient3.formatTaxId((String)result.getOrganisationNumber(), (boolean)bp.isCompany()))) {
                    this.log.warn("Customer number " + bp.getbPartnerId() + " and org no " + bp.getTaxId() + " doesn't match. Lookup using tax id");
                    try {
                        result = this.bof.getClient().getCustomerByTaxId(bp.getTaxId(), bp.isCompany());
                        bp.setbPartnerId(Integer.parseInt(result.getCustomerNumber()));
                    }
                    catch (Exception e) {
                        String string2 = e.getMessage();
                        this.bof.getClient();
                        if (!string2.contains(FortnoxClient3.formatTaxId((String)bp.getTaxId(), (boolean)bp.isCompany()))) {
                            throw e;
                        }
                        result = null;
                    }
                }
            }
        } else if (bp.getIdentityNo() != null && bp.getIdentityNo().trim().length() > 0) {
            result = this.bof.getClient().getCustomerByCustNo(bp.getIdentityNo());
        }
        if (result == null && bp.getTaxId() != null && bp.getTaxId().trim().length() > 0) {
            try {
                result = this.bof.getClient().getCustomerByTaxId(bp.getTaxId(), bp.isCompany());
            }
            catch (Exception e) {
                if (e.getMessage() == null || !e.getMessage().contains(FortnoxClient3.formatTaxId((String)bp.getTaxId(), (boolean)bp.isCompany()))) {
                    throw e;
                }
                result = null;
            }
        }
        return result;
    }

    public String accountTransfer(@Header(value="orgNo") String orgNo, @Header(value="reconciliationDate") Date acctDate, @Header(value="totalAmount") Double totalAmount, @Header(value="creditAcct") String creditAcct, @Header(value="debitAcct") String debitAcct, @Header(value="transferDescription") String description, @Header(value="voucherSeries") String voucherSeries, @Header(value="srcCurrency") String srcCurrency) throws Exception, FortnoxException, FortnoxScopeException {
        Date trxDate = null;
        trxDate = acctDate == null ? Calendar.getInstance().getTime() : acctDate;
        FortnoxConverter ftx = new FortnoxConverter();
        Voucher voucher = ftx.createSingleTransactionVoucher(voucherSeries, trxDate, creditAcct, debitAcct, totalAmount.doubleValue(), description);
        this.bof = this.getFortnoxAdapter(orgNo);
        FortnoxExtendedClient fec = new FortnoxExtendedClient(this.bof);
        voucher = fec.accountFortnoxVoucher(voucher, srcCurrency, 0.0);
        return voucher.getVoucherSeries() + voucher.getVoucherNumber();
    }

    public String accountFee(@Header(value="orgNo") String orgNo, @Header(value="reconciliationDate") Date acctDate, @Header(value="feeTotal") Double totalAmount, @Header(value="feeVat") Double vatAmount, @Header(value="feeAccount") String feeAccount, @Header(value="srcAccount") String srcAccount, @Header(value="vatAccount") String vatAccount, @Header(value="feeDescription") String description, @Header(value="voucherSeries") String voucherSeries, @Header(value="costCenter") String costCenter, @Header(value="srcCurrency") String srcCurrency) throws FortnoxException, FortnoxScopeException, Exception {
        Date trxDate = null;
        trxDate = acctDate == null ? Calendar.getInstance().getTime() : acctDate;
        FortnoxConverter ftx = new FortnoxConverter();
        Voucher voucher = ftx.createSingleCostWithVatTransactionVoucher(voucherSeries, trxDate, srcAccount, feeAccount, vatAccount, totalAmount.doubleValue(), vatAmount.doubleValue(), description, costCenter);
        this.bof = this.getFortnoxAdapter(orgNo);
        FortnoxExtendedClient fec = new FortnoxExtendedClient(this.bof);
        voucher = fec.accountFortnoxVoucher(voucher, srcCurrency, 0.0);
        return voucher.getVoucherSeries() + voucher.getVoucherNumber();
    }

    public String getSettingFromSupplier(@Header(value="orgNo") String orgNo, @Header(value="supplierOrgNo") String supplierOrgNo, @Header(value="settingKey") String settingKey) throws Exception {
        Map<String, String> map = this.getSettingsFromSupplier(orgNo, supplierOrgNo);
        if (map != null) {
            return map.get(settingKey);
        }
        return null;
    }

    public Map<String, String> getSettingsFromSupplier(@Header(value="orgNo") String orgNo, @Header(value="supplierOrgNo") String supplierOrgNo) throws Exception {
        this.bof = this.getFortnoxAdapter(orgNo);
        FortnoxClient3 client = this.bof.getClient();
        Fortnox4JSettings settings = new Fortnox4JSettings(client);
        return settings.getSettingsFromSupplierByOrgNo(supplierOrgNo);
    }

    public Supplier writeSettingToSupplier(@Header(value="clientOrgNo") String clientOrgNo, @Header(value="accessToken") String accessToken, @Header(value="supplierOrgNo") String supplierOrgNo, @Header(value="settingKey") String settingKey, @Header(value="settingValue") String settingValue) throws Exception {
        this.bof = this.getFortnoxAdapter(clientOrgNo);
        FortnoxClient3 client = this.bof.getClient();
        Fortnox4JSettings settings = new Fortnox4JSettings(client);
        return settings.writeSettingToSupplierByOrgNo(supplierOrgNo, settingKey, settingValue);
    }
}

