/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.fortnox;

import java.util.ArrayList;
import java.util.List;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.api.fortnox.entities3.InvoiceSubset;
import org.notima.api.fortnox.entities3.Invoices;
import org.notima.businessobjects.adapter.fortnox.FortnoxAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceListReader {
    private Logger log = LoggerFactory.getLogger(InvoiceListReader.class);
    private FortnoxAdapter bof;
    private List<InvoiceSubset> subsetList;
    private List<Invoice> invoiceList;
    private int invoiceCount = 0;

    public InvoiceListReader(FortnoxAdapter bof) {
        this.bof = bof;
    }

    public boolean isEmpty() {
        return this.subsetList == null || this.subsetList.size() == 0;
    }

    public int subsetCount() {
        return this.subsetList == null ? 0 : this.subsetList.size();
    }

    public void populateSubSetList() throws Exception {
        Invoices invoices = this.bof.getClient().getInvoices("unpaid");
        Invoices unposted = this.bof.getClient().getInvoices("unbooked");
        this.subsetList = invoices.getInvoiceSubset();
        if (this.subsetList != null) {
            if (unposted.getInvoiceSubset() != null) {
                this.subsetList.addAll(unposted.getInvoiceSubset());
            }
        } else {
            this.subsetList = unposted.getInvoiceSubset();
        }
        if (this.subsetList == null) {
            this.subsetList = new ArrayList<InvoiceSubset>();
        }
    }

    public void populateInvoiceListFromSubset() throws Exception {
        this.invoiceList = new ArrayList<Invoice>();
        if (this.subsetList == null) {
            return;
        }
        for (InvoiceSubset ii : this.subsetList) {
            Invoice i = this.bof.getClient().getInvoice(ii.getDocumentNumber());
            if (i.getBalance() != null && i.getBalance().equals(0.0)) {
                this.log.info("Fortnox Invoice " + i.getDocumentNumber() + " has no open balance. Skipping.");
                continue;
            }
            this.invoiceList.add(i);
            ++this.invoiceCount;
            if (this.invoiceCount % 100 != 0) continue;
            this.log.info("{} invoices retrieved...", (Object)this.invoiceCount);
        }
    }

    public List<InvoiceSubset> getSubsetList() {
        return this.subsetList;
    }

    public List<Invoice> getInvoiceList() {
        return this.invoiceList;
    }
}

