/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.fortnox;

import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.businessobjects.adapter.fortnox.FortnoxAdapter;
import org.notima.camel.fortnox.InvoiceListReader;
import org.notima.camel.fortnox.InvoiceReferenceMap;
import org.notima.camel.fortnox.TaxSubjectInvoiceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceReferenceMapper {
    private FortnoxAdapter bof;
    private String orgNo;
    private Map<String, InvoiceReferenceMap> referenceMapsByReferenceField = new TreeMap<String, InvoiceReferenceMap>();
    private InvoiceListReader invoiceListReader;
    private InvoiceReferenceMap selectedReferenceMap;
    private TaxSubjectInvoiceMapper taxSubjectInvoiceMapper;
    private Logger log = LoggerFactory.getLogger(InvoiceReferenceMapper.class);

    public InvoiceReferenceMapper(FortnoxAdapter bof) {
        this.orgNo = bof.getCurrentTenant().getTaxId();
        this.bof = bof;
        this.taxSubjectInvoiceMapper = new TaxSubjectInvoiceMapper(this.orgNo);
    }

    public boolean isFortnoxClientOrgNo(String orgNo) {
        if (orgNo == null) {
            orgNo = "";
        }
        return this.orgNo.equals(orgNo.trim());
    }

    private void populateInvoiceReader() throws Exception {
        if (this.invoiceListReader == null) {
            this.invoiceListReader = new InvoiceListReader(this.bof);
            this.log.info("Populating invoice list for " + this.orgNo + ". This might take some time...");
            this.invoiceListReader.populateSubSetList();
            this.log.info("{} invoices to map up.", (Object)this.invoiceListReader.subsetCount());
            this.invoiceListReader.populateInvoiceListFromSubset();
        }
    }

    public InvoiceReferenceMap selectInvoiceMap(String referenceField, String invoiceRefRegEx) throws Exception {
        this.selectedReferenceMap = this.referenceMapsByReferenceField.get(referenceField);
        if (this.selectedReferenceMap == null) {
            this.selectedReferenceMap = new InvoiceReferenceMap(referenceField);
            this.referenceMapsByReferenceField.put(referenceField, this.selectedReferenceMap);
            this.log.info("Added invoiceMap using " + referenceField + ". This might take some time...");
            this.populateInvoiceReader();
            if (this.invoiceListReader.isEmpty()) {
                return this.selectedReferenceMap;
            }
            Pattern re = null;
            Matcher m = null;
            if (invoiceRefRegEx != null && invoiceRefRegEx.trim().length() > 0) {
                re = Pattern.compile(invoiceRefRegEx);
            }
            String refInFortnox = null;
            for (Invoice i : this.invoiceListReader.getInvoiceList()) {
                this.taxSubjectInvoiceMapper.addInvoice(i);
                refInFortnox = this.getInvoiceReference(referenceField, i);
                if (re != null && refInFortnox != null && (m = re.matcher(refInFortnox)).matches()) {
                    refInFortnox = m.groupCount() > 0 ? m.group(1) : m.group();
                }
                if (refInFortnox != null && refInFortnox.trim().length() > 0) {
                    refInFortnox = refInFortnox.trim();
                    this.selectedReferenceMap.addInvoiceToMap(refInFortnox, i);
                    continue;
                }
                this.log.info("Fortnox Invoice " + i.getDocumentNumber() + " has no reference in [" + referenceField + "].");
            }
        }
        return this.selectedReferenceMap;
    }

    private String getInvoiceReference(String referenceField, Invoice i) {
        String refInFortnox = null;
        if ("YourOrderNumber".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getYourOrderNumber();
        } else if ("ExternalInvoiceReference1".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getExternalInvoiceReference1();
        } else if ("ExternalInvoiceReference2".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getExternalInvoiceReference2();
        } else if ("InvoiceReference".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getInvoiceReference();
        } else if ("OCR".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getOCR();
        } else if ("OrderReference".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getOrderReference();
        } else if ("OurReference".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getOurReference();
        } else if ("YourReference".equalsIgnoreCase(referenceField)) {
            refInFortnox = i.getYourReference();
        }
        return refInFortnox;
    }
}

