/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.fortnox;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.notima.api.fortnox.entities3.Invoice;
import org.notima.generic.businessobjects.TaxSubjectIdentifier;

public class TaxSubjectInvoiceMapper {
    private String fortnoxClientOrgNo;
    private Map<TaxSubjectIdentifier, List<Invoice>> invoiceTaxSubjectMap = new TreeMap<TaxSubjectIdentifier, List<Invoice>>();

    public TaxSubjectInvoiceMapper(String fortnoxClientOrgNo) {
        if (fortnoxClientOrgNo == null) {
            this.fortnoxClientOrgNo = "";
        }
        this.fortnoxClientOrgNo = fortnoxClientOrgNo.trim();
    }

    public boolean isFortnoxClientOrgNo(String orgNo) {
        if (orgNo == null) {
            orgNo = "";
        }
        return this.fortnoxClientOrgNo.equals(orgNo.trim());
    }

    public void addInvoice(Invoice invoice) {
        TaxSubjectIdentifier tsi;
        List<Invoice> invoices;
        String country = "SE";
        if (invoice.getCountry() != null && invoice.getCountry().trim().length() > 0) {
            country = invoice.getCountry().toUpperCase();
        }
        if ((invoices = this.invoiceTaxSubjectMap.get(tsi = TaxSubjectIdentifier.createBusinessTaxSubject((String)invoice.getOrganisationNumber(), (String)country, (String)invoice.getCustomerName()))) == null) {
            invoices = new ArrayList<Invoice>();
            this.invoiceTaxSubjectMap.put(tsi, invoices);
        }
        invoices.add(invoice);
    }

    public List<Invoice> getInvoicesForTaxSubject(TaxSubjectIdentifier tsi) {
        List<Invoice> result = this.invoiceTaxSubjectMap.get(tsi);
        if (result == null) {
            return new ArrayList<Invoice>();
        }
        return result;
    }
}

