/*
 * Decompiled with CFR 0.152.
 */
package com.svea.businessobjects.pmtadmin;

import java.text.ParseException;
import java.util.ArrayList;
import org.notima.api.webpay.pmtapi.PmtApiUtil;
import org.notima.api.webpay.pmtapi.entity.Address;
import org.notima.api.webpay.pmtapi.entity.Delivery;
import org.notima.api.webpay.pmtapi.entity.Order;
import org.notima.api.webpay.pmtapi.entity.OrderRow;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.OrderLine;
import org.notima.generic.businessobjects.Person;

public class SveaPmtAdminConverter {
    public static org.notima.generic.businessobjects.Order<Order> convert(Order src) throws ParseException {
        OrderLine ll;
        if (src == null) {
            return null;
        }
        org.notima.generic.businessobjects.Order dst = new org.notima.generic.businessobjects.Order();
        BusinessPartner bp = new BusinessPartner();
        dst.setBpartner(bp);
        bp.setTaxId(src.getNationalId());
        bp.setCompany(src.isCompany());
        dst.setDocumentKey(Long.toString(src.getId()));
        dst.setOrderKey(src.getMerchantOrderId());
        dst.setCurrency(src.getCurrency());
        dst.setDateOrdered(PmtApiUtil.dateTimeFmt.parse(src.getCreatationDate()));
        Person person = new Person();
        if (src.isCompany()) {
            person.setName(src.getCustomerReference());
        } else {
            person.setName(src.getBillingAddress().getFullName());
        }
        person.setPhone(src.getPhoneNumber());
        person.setEmail(src.getEmailAddress());
        if ((person.getName() == null || person.getName().trim().length() == 0) && src.getBillingAddress() != null) {
            person.setName(src.getBillingAddress().getFullName());
        }
        dst.setBillPerson(person);
        dst.setBillLocation(SveaPmtAdminConverter.convert(src.getBillingAddress()));
        dst.getBillLocation().setEmail(src.getEmailAddress());
        dst.getBillLocation().setPhone(src.getPhoneNumber());
        dst.setShipLocation(SveaPmtAdminConverter.convert(src.getShippingAddress()));
        if (dst.getShipLocation() != null) {
            dst.getShipLocation().setEmail(src.getEmailAddress());
        }
        if (src.getBillingAddress() == null || src.getBillingAddress().getFullName() == null && src.getBillingAddress().getStreetAddress() == null) {
            dst.setBillLocation(dst.getShipLocation());
        }
        bp.setAddressOfficial(dst.getBillLocation());
        bp.setName(src.getBillingAddress().getFullName() != null ? src.getBillingAddress().getFullName() : src.getShippingAddress().getFullName());
        if (bp.isCompany()) {
            ArrayList<Person> contacts = new ArrayList<Person>();
            contacts.add(person);
            bp.setContacts(contacts);
        }
        dst.setPaymentRule(src.getPaymentType());
        ArrayList<OrderLine> ol = new ArrayList<OrderLine>();
        if (src.getDeliveries() != null) {
            for (Delivery d : src.getDeliveries()) {
                dst.setDateDelivered(PmtApiUtil.dateTimeFmt.parse(d.getCreationDate()));
                if (d.getOrderRows() == null) continue;
                for (OrderRow r : d.getOrderRows()) {
                    ll = SveaPmtAdminConverter.convert(r);
                    ll.setQtyDelivered(ll.getQtyEntered());
                    ol.add(ll);
                }
            }
        }
        if (src.getOrderRows() != null) {
            for (OrderRow r : src.getOrderRows()) {
                ll = SveaPmtAdminConverter.convert(r);
                ol.add(ll);
            }
        }
        dst.setLines(ol);
        return dst;
    }

    public static Location convert(Address src) {
        if (src == null) {
            return null;
        }
        Location result = new Location();
        result.setStreet(src.getStreetAddress());
        result.setCo(src.getCoAddress());
        result.setPostal(src.getPostalCode());
        result.setCity(src.getCity());
        result.setCountryCode(src.getCountryCode());
        result.setCustomerReference(src.getFullName());
        return result;
    }

    public static OrderLine convert(OrderRow src) {
        OrderLine dst = new OrderLine();
        dst.setLineNo(Integer.valueOf(Long.toString(src.getOrderRowId())).intValue());
        dst.setKey(src.getArticleNumber());
        dst.setProductKey(src.getArticleNumber());
        dst.setName(src.getName());
        dst.setQtyEntered(src.getQuantity() / 100.0);
        dst.setPriceActual(Double.valueOf(src.getUnitPrice() / 100.0));
        dst.setPricesIncludeVAT(true);
        dst.setTaxPercent(src.getVatPercent() / 100.0);
        dst.setUOM(src.getUnit());
        return dst;
    }
}

