/*
 * Decompiled with CFR 0.152.
 */
package com.svea.businessobjects.sveaadmin;

import com.svea.businessobjects.sveaadmin.SveaAdminConverter;
import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadminservice.client.ArrayOfDeliverOrderInformation;
import com.svea.webpayadminservice.client.ArrayOfGetOrderInformation;
import com.svea.webpayadminservice.client.ArrayOfOrder;
import com.svea.webpayadminservice.client.ArrayOfOrderDeliveryStatus;
import com.svea.webpayadminservice.client.ArrayOfOrderListItem;
import com.svea.webpayadminservice.client.ArrayOfOrderStatus;
import com.svea.webpayadminservice.client.ArrayOflong;
import com.svea.webpayadminservice.client.CreateOrderRequest;
import com.svea.webpayadminservice.client.CreateOrderResponse2;
import com.svea.webpayadminservice.client.CreatePaymentPlanDetails;
import com.svea.webpayadminservice.client.DeliverOrderInformation;
import com.svea.webpayadminservice.client.DeliveryRequest;
import com.svea.webpayadminservice.client.DeliveryResponse;
import com.svea.webpayadminservice.client.GetOrderInformation;
import com.svea.webpayadminservice.client.GetOrdersRequest;
import com.svea.webpayadminservice.client.GetOrdersResponse2;
import com.svea.webpayadminservice.client.IAdminService;
import com.svea.webpayadminservice.client.Order;
import com.svea.webpayadminservice.client.OrderDeliveryStatus;
import com.svea.webpayadminservice.client.OrderListItem;
import com.svea.webpayadminservice.client.OrderStatus;
import com.svea.webpayadminservice.client.OrderType;
import com.svea.webpayadminservice.client.SearchOrderFilter;
import com.svea.webpayadminservice.client.SearchOrdersRequest;
import com.svea.webpayadminservice.client.SearchOrdersResponse2;
import com.svea.webpayadminservice.client.TextMatchType3;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.notima.factoring.AbstractAddress;
import org.notima.factoring.FactoringEngine;
import org.notima.factoring.FactoringReply;
import org.notima.generic.businessobjects.BasicBusinessObjectConverter;
import org.notima.generic.businessobjects.BasicBusinessObjectFactory;
import org.notima.generic.businessobjects.BasicFactoringReservation;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.Currency;
import org.notima.generic.businessobjects.DunningRun;
import org.notima.generic.businessobjects.Invoice;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.PaymentTerm;
import org.notima.generic.businessobjects.Person;
import org.notima.generic.businessobjects.PriceList;
import org.notima.generic.businessobjects.Product;
import org.notima.generic.businessobjects.ProductCategory;
import org.notima.generic.businessobjects.Tax;
import org.notima.generic.ifacebusinessobjects.FactoringReservation;
import org.notima.generic.ifacebusinessobjects.OrderInvoice;

public class SveaAdminBusinessObjectFactory
extends BasicBusinessObjectFactory<IAdminService, Object, Order, Object, Object>
implements FactoringEngine {
    protected IAdminService adminServicePort;
    private WebpayAdminBase webpayAdminBase = new WebpayAdminBase();

    public SveaAdminBusinessObjectFactory() {
        this.adminServicePort = this.webpayAdminBase.getAdminServicePort();
    }

    public IAdminService getAdminClient() {
        return this.adminServicePort;
    }

    public void initCredentials(SveaCredential aCre) {
        this.webpayAdminBase.initCredentials(aCre);
    }

    public CreateOrderResponse2 createOrder(CreateOrderRequest request) {
        CreateOrderResponse2 response = this.adminServicePort.createOrder(request);
        return response;
    }

    public OrderType getOrderType() {
        switch (this.webpayAdminBase.getCredentials().getAccountType()) {
            case "invoice": {
                return OrderType.INVOICE;
            }
            case "paymentplan": {
                return OrderType.PAYMENT_PLAN;
            }
            case "loan": {
                return OrderType.LOAN;
            }
            case "account-credit": {
                return OrderType.ACCOUNT_CREDIT;
            }
        }
        return null;
    }

    public CreateOrderRequest toSveaCreateOrderRequest(OrderInvoice orderInvoice, CreatePaymentPlanDetails cpp) throws Exception {
        org.notima.generic.businessobjects.Order src = null;
        if (!(orderInvoice instanceof org.notima.generic.businessobjects.Order)) {
            throw new Exception("Can't yet convert invoice to order");
        }
        src = (org.notima.generic.businessobjects.Order)orderInvoice;
        CreateOrderRequest dst = SveaAdminConverter.convert((org.notima.generic.businessobjects.Order<CreateOrderRequest>)src, this.getOrderType(), cpp);
        dst.setAuthentication(this.webpayAdminBase.getAuth());
        dst.setClientId(Long.parseLong(this.webpayAdminBase.getCredentials().getAccountNo()));
        return dst;
    }

    public DeliveryResponse deliverOrder(Long sveaOrderId, OrderType ot) {
        DeliveryRequest req = new DeliveryRequest();
        req.setAuthentication(this.webpayAdminBase.getAuth());
        ArrayOfDeliverOrderInformation orders = new ArrayOfDeliverOrderInformation();
        List<DeliverOrderInformation> olist = orders.getDeliverOrderInformation();
        DeliverOrderInformation order = new DeliverOrderInformation();
        order.setClientId(Long.parseLong(this.webpayAdminBase.getCredentials().getAccountNo()));
        order.setSveaOrderId(sveaOrderId);
        order.setOrderType(ot);
        olist.add(order);
        req.setOrdersToDeliver(orders);
        DeliveryResponse response = this.adminServicePort.deliverOrders(req);
        return response;
    }

    public BusinessPartner<Object> lookupBusinessPartner(String key) throws Exception {
        return null;
    }

    public List<BusinessPartner<Object>> lookupAllBusinessPartners() throws Exception {
        return null;
    }

    public DunningRun lookupDunningRun(String key) throws Exception {
        return null;
    }

    public IAdminService getClient() {
        return null;
    }

    public Object lookupNativeInvoice(String key) throws Exception {
        return null;
    }

    public Object persistNativeInvoice(Object invoice) throws Exception {
        return null;
    }

    public Order lookupNativeOrder(String key) throws Exception {
        return null;
    }

    public Order persistNativeOrder(Order order) throws Exception {
        return null;
    }

    public Invoice<Object> lookupInvoice(String key) throws Exception {
        return null;
    }

    public org.notima.generic.businessobjects.Order<Order> lookupOrder(String key) throws Exception {
        IAdminService client = this.getAdminClient();
        GetOrdersRequest req = new GetOrdersRequest();
        ArrayOfGetOrderInformation aog = new ArrayOfGetOrderInformation();
        req.setOrdersToRetrieve(aog);
        List<GetOrderInformation> ogl = aog.getGetOrderInformation();
        GetOrderInformation oi = new GetOrderInformation();
        oi.setSveaOrderId(Integer.parseInt(key));
        ogl.add(oi);
        req.setAuthentication(this.webpayAdminBase.getAuth());
        OrderType ot = null;
        if ("invoice".equals(this.webpayAdminBase.getCredentials().getAccountType())) {
            ot = OrderType.INVOICE;
        } else if ("paymentplan".equals(this.webpayAdminBase.getCredentials().getAccountType())) {
            ot = OrderType.PAYMENT_PLAN;
        } else if ("account-credit".equals(this.webpayAdminBase.getCredentials().getAccountType())) {
            ot = OrderType.ACCOUNT_CREDIT;
        } else if ("loan".equals(this.webpayAdminBase.getCredentials().getAccountType())) {
            ot = OrderType.LOAN;
        }
        oi.setClientId(Long.parseLong(this.webpayAdminBase.getCredentials().getAccountNo()));
        oi.setOrderType(ot);
        GetOrdersResponse2 response = client.getOrders(req);
        if (response.getErrorMessage() != null) {
            throw new Exception(response.toString());
        }
        ArrayOfOrder result = response.getOrders();
        Order resultOrder = null;
        if (result.getOrder() != null && !result.getOrder().isEmpty()) {
            resultOrder = result.getOrder().get(0);
        }
        return SveaAdminConverter.convert(resultOrder);
    }

    public org.notima.generic.businessobjects.Order<Order> findByClientOrderId(String clientOrderId) throws Exception {
        org.notima.generic.businessobjects.Order<Order> order;
        block2: {
            IAdminService client = this.getAdminClient();
            SearchOrdersRequest req = new SearchOrdersRequest();
            req.setAuthentication(this.webpayAdminBase.getAuth());
            SearchOrderFilter sof = new SearchOrderFilter();
            req.setSearchOrderFilter(sof);
            ArrayOfOrderDeliveryStatus aods = new ArrayOfOrderDeliveryStatus();
            sof.setAcceptedDeliveryStatus(aods);
            aods.getOrderDeliveryStatus().add(OrderDeliveryStatus.CREATED);
            aods.getOrderDeliveryStatus().add(OrderDeliveryStatus.DELIVERED);
            aods.getOrderDeliveryStatus().add(OrderDeliveryStatus.PARTIALLY_DELIVERED);
            ArrayOfOrderStatus aoos = new ArrayOfOrderStatus();
            sof.setAcceptedOrderStatus(aoos);
            aoos.getOrderStatus().add(OrderStatus.ACTIVE);
            aoos.getOrderStatus().add(OrderStatus.CREATED);
            aoos.getOrderStatus().add(OrderStatus.PENDING);
            aoos.getOrderStatus().add(OrderStatus.CLOSED);
            aoos.getOrderStatus().add(OrderStatus.DENIED);
            aoos.getOrderStatus().add(OrderStatus.ERROR);
            ArrayOflong clientIds = new ArrayOflong();
            sof.setClientIds(clientIds);
            clientIds.getLong().add(Long.parseLong(this.webpayAdminBase.getCredentials().getAccountNo()));
            sof.setTextMatchType(TextMatchType3.CLIENT_ORDER_NUMBER);
            sof.setTextMatch(clientOrderId);
            SearchOrdersResponse2 response = client.searchOrders(req);
            order = null;
            if (response == null) break block2;
            if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
                throw new Exception(response.getErrorMessage());
            }
            ArrayOfOrderListItem result = response.getOrderListItems();
            Iterator<OrderListItem> iterator = result.getOrderListItem().iterator();
            if (iterator.hasNext()) {
                OrderListItem oli = iterator.next();
                order = this.lookupOrder(Long.toString(oli.getSveaOrderId()));
            }
        }
        return order;
    }

    public Product<Object> lookupProduct(String key) throws Exception {
        return null;
    }

    public Product<Object> lookupProductByEan(String ean) throws Exception {
        return null;
    }

    public List<Product<Object>> lookupProductByName(String name) throws Exception {
        return null;
    }

    public Map<Object, Object> lookupList(String listName) throws Exception {
        return null;
    }

    public Product<Object> lookupRoundingProduct() throws Exception {
        return null;
    }

    public Tax lookupTax(String key) throws Exception {
        return null;
    }

    public PaymentTerm lookupPaymentTerm(String key) throws Exception {
        return null;
    }

    public FactoringReservation lookupFactoringReservation(String key) throws Exception {
        return null;
    }

    public List<FactoringReservation> lookupFactoringReservationForOrder(String orderKey) throws Exception {
        return null;
    }

    public List<FactoringReservation> lookupFactoringReservationForInvoice(String invoiceKey) throws Exception {
        return null;
    }

    public Object persist(Object o) throws Exception {
        return null;
    }

    public boolean isConnected() throws Exception {
        return false;
    }

    public void destroy() throws Exception {
    }

    public FactoringReservation reserveForFactoring(org.notima.generic.businessobjects.Order order, BusinessPartner factoringCompany) throws Exception {
        CreateOrderRequest req = this.toSveaCreateOrderRequest((OrderInvoice)order, null);
        CreateOrderResponse2 result = this.createOrder(req);
        BasicFactoringReservation fr = new BasicFactoringReservation();
        if (result.getErrorMessage() != null) {
            fr.setInfoText(result.getErrorMessage());
            fr.setReservationResponseCode("Z");
        } else {
            fr.setOrderNo(Long.toString(result.getOrderResult().getSveaOrderId()));
            if (result.getOrderResult().isSveaWillBuyOrder().booleanValue()) {
                fr.setReservationResponseCode("E");
            } else {
                fr.setReservationResponseCode("F");
            }
        }
        return fr;
    }

    public FactoringReservation reserveForFactoring(Invoice invoice, BusinessPartner factoringCompany) throws Exception {
        BasicBusinessObjectConverter converter = new BasicBusinessObjectConverter();
        org.notima.generic.businessobjects.Order order = converter.toOrder(invoice);
        return this.reserveForFactoring(order, factoringCompany);
    }

    public FactoringReservation cancelReservation(org.notima.generic.businessobjects.Order order, FactoringReservation reservation) throws Exception {
        return null;
    }

    public double getPossibleFactoringAmount(BusinessPartner customer, Currency currency, BusinessPartner factoringCompany) throws Exception {
        return 0.0;
    }

    public FactoringReply sendToFactoring(BusinessPartner factoringCompany, Invoice invoice) throws Exception {
        return null;
    }

    public void afterSendToFactoring(BusinessPartner factoringCompany, Invoice invoice, FactoringReply reply) throws Exception {
    }

    public AbstractAddress makeAddressFromLocation(BusinessPartner customer, Person user, Location location) throws Exception {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public FactoringReply returnToFactoring(BusinessPartner factoringCompany, Invoice invoice) throws Exception {
        return null;
    }

    public void setFactoringProperties(Properties props) {
    }

    public PriceList lookupPriceForProduct(String productKey, String currency, Boolean salesPriceList) throws Exception {
        return null;
    }

    public List<ProductCategory> lookupProductCategory(String key) throws Exception {
        return null;
    }

    public BusinessPartner<?> lookupThisCompanyInformation() throws Exception {
        return null;
    }

    public List<BusinessPartner<Object>> lookupBusinessPartners(int maxCount, boolean customers, boolean suppliers) throws Exception {
        return null;
    }
}

