/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.auth;

import com.svea.webpay.common.auth.ListOfSveaCredentials;
import com.svea.webpay.common.conv.JsonUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SveaCredential {
    public static final String ACCOUNTTYPE_ADMIN = "admin";
    public static final String ACCOUNTTYPE_INVOICE = "invoice";
    public static final String ACCOUNTTYPE_PAYMENTPLAN = "paymentplan";
    public static final String ACCOUNTTYPE_CREDITCARD = "creditcard";
    public static final String ACCOUNTTYPE_LOAN = "loan";
    public static final String ACCOUNTTYPE_ACCOUNT_CREDIT = "account-credit";
    public static final String ACCOUNTTYPE_DIRECT_BANK = "direct-bank";
    public static final Map<Integer, String> AGREEMENT_TYPE_MAP = new TreeMap<Integer, String>();
    private String accountNo;
    private String username;
    private String password;
    private String accountType;
    private String merchantId;
    private String cardMerchantId;
    private String secretWord;
    private String orgNo;
    private String orgName;
    private String vatNo;
    private String sveaCustomerNumber;
    private String server;
    private String currency;
    private String countryCode;
    private boolean company;
    private boolean enrichFromInvoice = false;
    private boolean skipTaxId = true;
    private boolean skipEmail = true;
    private boolean includeCardPayments = false;
    private boolean includeKickbacks = true;
    private boolean active = true;
    private boolean ignoreFees;
    private Map<String, String> accountMap;
    private Map<String, String> accountRemap;

    static {
        AGREEMENT_TYPE_MAP.put(1, ACCOUNTTYPE_ADMIN);
        AGREEMENT_TYPE_MAP.put(21, ACCOUNTTYPE_INVOICE);
        AGREEMENT_TYPE_MAP.put(24, ACCOUNTTYPE_PAYMENTPLAN);
        AGREEMENT_TYPE_MAP.put(25, ACCOUNTTYPE_ACCOUNT_CREDIT);
    }

    public SveaCredential() {
    }

    public SveaCredential(String accountNo, String username, String password, String accountType) {
        this.accountNo = accountNo;
        this.username = username;
        this.password = password;
        this.accountType = accountType;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getCardMerchantId() {
        return this.cardMerchantId;
    }

    public void setCardMerchantId(String cardMerchantId) {
        this.cardMerchantId = cardMerchantId;
    }

    public String getSecretWord() {
        return this.secretWord;
    }

    public void setSecretWord(String secretWord) {
        this.secretWord = secretWord;
    }

    public String getOrgNo() {
        return this.orgNo;
    }

    public void setOrgNo(String orgNo) {
        this.orgNo = orgNo;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getVatNo() {
        return this.vatNo;
    }

    public void setVatNo(String vatNo) {
        this.vatNo = vatNo;
    }

    public String getSveaCustomerNumber() {
        return this.sveaCustomerNumber;
    }

    public void setSveaCustomerNumber(String sveaCustomerNumber) {
        this.sveaCustomerNumber = sveaCustomerNumber;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isIncludeCardPayments() {
        return this.includeCardPayments;
    }

    public void setIncludeCardPayments(boolean includeCardPayments) {
        this.includeCardPayments = includeCardPayments;
    }

    public boolean isIncludeKickbacks() {
        return this.includeKickbacks;
    }

    public void setIncludeKickbacks(boolean includeKickbacks) {
        this.includeKickbacks = includeKickbacks;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.accountNo != null) {
            buf.append("AcctNo: " + this.accountNo);
        }
        if (this.merchantId != null) {
            buf.append("MerchId: " + this.merchantId);
        }
        if (this.accountType != null) {
            buf.append(" / " + this.accountType);
        }
        if (buf.length() == 0) {
            return super.toString();
        }
        return buf.toString();
    }

    public Map<String, String> getAccountMap() {
        return this.accountMap;
    }

    public void setAccountMap(Map<String, String> accountMap) {
        this.accountMap = accountMap;
    }

    public void addAccountMapping(String type, String account) {
        if (type == null) {
            return;
        }
        if (this.accountMap == null) {
            this.accountMap = new TreeMap<String, String>();
        }
        if (account == null || account.trim().length() == 0) {
            return;
        }
        this.accountMap.put(type, account);
    }

    public Map<String, String> createDefaultAccountMap() {
        if (this.accountMap == null) {
            this.accountMap = new TreeMap<String, String>();
        }
        this.accountMap.put("cash", "1930");
        this.accountMap.put("reconcile", "1580");
        this.accountMap.put("deposit", "1974");
        this.accountMap.put("receivables", "1510");
        this.accountMap.put("debt", "2419");
        this.accountMap.put("vat", "2641");
        this.accountMap.put("rounding", "3740");
        this.accountMap.put("revenue-reminder", "3990");
        this.accountMap.put("adm", "6532");
        this.accountMap.put("credit", "6590");
        this.accountMap.put("reminder", "6533");
        this.accountMap.put("collection", "6533");
        this.accountMap.put("interest", "6534");
        this.accountMap.put("postage", "6250");
        this.accountMap.put("interest-income", "8313");
        this.accountMap.put("deviations", "9999");
        return this.accountMap;
    }

    public Map<String, String> getReverseAccountMap() {
        if (this.accountMap == null) {
            this.createDefaultAccountMap();
        }
        TreeMap<String, String> reverseMap = new TreeMap<String, String>();
        for (String feeType : this.accountMap.keySet()) {
            String acctNr = this.accountMap.get(feeType);
            reverseMap.put(acctNr, feeType);
        }
        return reverseMap;
    }

    public Map<String, String> getAccountRemap() {
        return this.accountRemap;
    }

    public void setAccountRemap(Map<String, String> accountRemap) {
        this.accountRemap = accountRemap;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void addAccountRemap(String src, String dst) {
        if (src == null) {
            return;
        }
        if (this.accountRemap == null) {
            this.accountRemap = new TreeMap<String, String>();
        }
        if (dst == null) {
            this.accountRemap.remove(src);
            return;
        }
        this.accountRemap.put(src, dst);
    }

    public boolean isCompany() {
        return this.company;
    }

    public void setCompany(boolean company) {
        this.company = company;
    }

    public boolean isIgnoreFees() {
        return this.ignoreFees;
    }

    public void setIgnoreFees(boolean ignoreFees) {
        this.ignoreFees = ignoreFees;
    }

    public boolean isEnrichFromInvoice() {
        return this.enrichFromInvoice;
    }

    public void setEnrichFromInvoice(boolean enrichFromInvoice) {
        this.enrichFromInvoice = enrichFromInvoice;
    }

    public boolean isSkipTaxId() {
        return this.skipTaxId;
    }

    public void setSkipTaxId(boolean skipTaxId) {
        this.skipTaxId = skipTaxId;
    }

    public boolean isSkipEmail() {
        return this.skipEmail;
    }

    public void setSkipEmail(boolean skipEmail) {
        this.skipEmail = skipEmail;
    }

    public String getRemappedAccountFor(String acctType) {
        if (this.accountMap == null) {
            return null;
        }
        String sveaAcct = this.accountMap.get(acctType);
        if (sveaAcct != null) {
            if (this.accountRemap == null) {
                return sveaAcct;
            }
            String clientAcct = this.accountRemap.get(sveaAcct);
            if (clientAcct != null) {
                return clientAcct;
            }
        }
        return sveaAcct;
    }

    public static List<SveaCredential> loadCredentialsFromXmlFile(String configfile) throws MalformedURLException, XPathExpressionException, ConfigurationException {
        Configurations configs = new Configurations();
        ArrayList<SveaCredential> result = new ArrayList<SveaCredential>();
        URL url = null;
        File cf = new File(configfile);
        url = !cf.exists() ? ClassLoader.getSystemResource(configfile) : new URL("file://" + cf.getAbsolutePath());
        if (url == null) {
            System.err.println("Can't find configfile: " + configfile);
            System.exit(-1);
        }
        XMLConfiguration fc = configs.xml(url);
        Document xmlDoc = fc.getDocument();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath path = xpathFactory.newXPath();
        String configOrgNo = path.evaluate("//configuration/orgNo", xmlDoc);
        String configOrgName = path.evaluate("//configuration/orgName", xmlDoc);
        NodeList list = (NodeList)path.evaluate("//configuration/accounts/account", xmlDoc, XPathConstants.NODESET);
        SveaCredential cre = null;
        int i = 0;
        while (i < list.getLength()) {
            NodeList remaps;
            NodeList alist;
            String includeCardPayments;
            String skipEmail;
            String skipTaxId;
            String enrichFromInvoice;
            String countryCodeTmp;
            String ignoreFees;
            Node node = list.item(i);
            cre = new SveaCredential();
            NodeList clist = node.getChildNodes();
            String onr = path.evaluate("orgNo", clist);
            if (onr != null && onr.trim().length() > 0) {
                cre.setOrgNo(onr);
            } else if (configOrgNo != null) {
                cre.setOrgNo(configOrgNo);
            }
            String oname = path.evaluate("orgName", clist);
            if (oname != null && oname.trim().length() > 0) {
                cre.setOrgName(oname);
            } else if (configOrgName != null) {
                cre.setOrgName(configOrgName);
            }
            cre.setAccountNo(path.evaluate("accountNo", clist));
            cre.setUsername(path.evaluate("username", clist));
            cre.setPassword(path.evaluate("password", clist));
            cre.setAccountType(path.evaluate("accountType", clist));
            cre.setCurrency(path.evaluate("currency", clist));
            String company = path.evaluate("company", clist);
            if (company != null) {
                cre.setCompany(Boolean.parseBoolean(company));
            }
            if ((ignoreFees = path.evaluate("ignoreFees", clist)) != null) {
                cre.setIgnoreFees(Boolean.parseBoolean(ignoreFees));
            }
            if ((countryCodeTmp = path.evaluate("countryCode", clist)) != null) {
                cre.setCountryCode(countryCodeTmp);
            }
            if ((enrichFromInvoice = path.evaluate("enrichFromInvoice", clist)) != null) {
                cre.setEnrichFromInvoice(Boolean.parseBoolean(enrichFromInvoice));
            }
            if ((skipTaxId = path.evaluate("skipTaxId", clist)) != null && skipTaxId.trim().length() > 0) {
                cre.setSkipTaxId(Boolean.parseBoolean(skipTaxId));
            }
            if ((skipEmail = path.evaluate("skipEmail", clist)) != null && skipEmail.trim().length() > 0) {
                cre.setSkipEmail(Boolean.parseBoolean(skipEmail));
            }
            if ((includeCardPayments = path.evaluate("includeCardPayments", clist)) != null && includeCardPayments.trim().length() > 0) {
                cre.setIncludeCardPayments(Boolean.parseBoolean(includeCardPayments));
            }
            cre.setSecretWord(path.evaluate("secretWord", clist));
            cre.setServer(path.evaluate("server", clist));
            cre.setMerchantId(path.evaluate("merchantId", clist));
            cre.setCardMerchantId(path.evaluate("cardMerchantId", clist));
            Node aNode = (Node)path.evaluate("accountMappings", clist, XPathConstants.NODE);
            if (cre.getAccountMap() == null) {
                cre.createDefaultAccountMap();
            }
            if (aNode != null && (alist = aNode.getChildNodes()) != null) {
                cre.addAccountMapping("cash", (String)path.evaluate("accountMap/cash", alist, XPathConstants.STRING));
                cre.addAccountMapping("reconcile", path.evaluate("accountMap/reconcile", alist));
                cre.addAccountMapping("deposit", path.evaluate("accountMap/deposit", alist));
                cre.addAccountMapping("receivables", path.evaluate("accountMap/receivables", alist));
                cre.addAccountMapping("debt", path.evaluate("accountMap/debt", alist));
                cre.addAccountMapping("vat", path.evaluate("accountMap/vat", alist));
                cre.addAccountMapping("adm", path.evaluate("accountMap/adm", alist));
                cre.addAccountMapping("collection", path.evaluate("accountMap/collection", alist));
                cre.addAccountMapping("credit", path.evaluate("accountMap/credit", alist));
                cre.addAccountMapping("interest", path.evaluate("accountMap/interest", alist));
                cre.addAccountMapping("postage", path.evaluate("accountMap/postage", alist));
                cre.addAccountMapping("reminder", path.evaluate("accountMap/reminder", alist));
                cre.addAccountMapping("rounding", path.evaluate("accountMap/rounding", alist));
            }
            if ((remaps = (NodeList)path.evaluate("accountMappings/accountRemap", clist, XPathConstants.NODESET)) != null) {
                int j = 0;
                while (j < remaps.getLength()) {
                    Node remap = remaps.item(j);
                    NamedNodeMap attr = remap.getAttributes();
                    cre.addAccountRemap(attr.getNamedItem("from").getNodeValue(), attr.getNamedItem("to").getNodeValue());
                    ++j;
                }
            }
            result.add(cre);
            ++i;
        }
        return result;
    }

    public static List<SveaCredential> loadCredentialsFromJsonFile(String configfile) throws Exception {
        FileReader fr;
        ListOfSveaCredentials result;
        File cf = new File(configfile);
        URL url = !cf.exists() ? ClassLoader.getSystemResource(configfile) : new URL("file://" + cf.getAbsolutePath());
        if (url == null) {
            System.err.println("Can't find configfile: " + configfile);
            System.exit(-1);
        }
        if ((result = (ListOfSveaCredentials)JsonUtil.gson.fromJson((Reader)(fr = new FileReader(url.getFile())), ListOfSveaCredentials.class)) != null) {
            return result.getCredentials();
        }
        return null;
    }

    public static void saveCredentialsAsJson(List<SveaCredential> credentials, String filename) throws Exception {
        if (credentials == null) {
            return;
        }
        ListOfSveaCredentials result = new ListOfSveaCredentials();
        for (SveaCredential cr : credentials) {
            result.addCredential(cr);
        }
        FileWriter fr = new FileWriter(filename);
        fr.write("{ \"credentials\": \n");
        fr.write(JsonUtil.gson.toJson(credentials));
        fr.write("}\n");
        fr.close();
    }
}

