/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.conv;

import com.svea.webpay.common.conv.InvalidTaxIdFormatException;
import com.svea.webpay.common.conv.TaxIdStructure;
import com.svea.webpay.common.conv.UnknownTaxIdFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaxIdFormatter {
    private static Pattern se10 = Pattern.compile("^(\\d{2})(\\d{2})(\\d{2})(\\d{4})$");
    private static Pattern se11 = Pattern.compile("^(\\d{2})(\\d{2})(\\d{2})\\-(\\d{4})$");
    private static Pattern se12 = Pattern.compile("^(\\d{4})(\\d{2})(\\d{2})(\\d{4})$");
    private static Pattern se14 = Pattern.compile("^SE(\\d{2})(\\d{2})(\\d{2})(\\d{4})01$");
    private static Pattern no09 = Pattern.compile("^(\\d{3})(\\d{3})(\\d{3}).*");
    private static Pattern no11 = Pattern.compile("^(\\d{3})\\s*?(\\d{3})\\s*?(\\d{3}).*");
    private static Pattern fi08 = Pattern.compile(".*?(\\d{7})(\\d)$");
    private static Pattern fi09 = Pattern.compile(".*?(\\d{7})\\-(\\d)$");

    public static String toDigitsOnly(String cleanUp) {
        if (cleanUp == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cleanUp.length()) {
            char c = cleanUp.charAt(i);
            if (c >= '0' && c <= '9') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasDigitsOnly(String ref) {
        if (ref == null || ref.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < ref.length()) {
            char c = ref.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String removeBlanks(String cleanUp) {
        if (cleanUp == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < cleanUp.length()) {
            char c = cleanUp.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String printTaxId(String srcFormat, String taxId, String dstFormat) throws UnknownTaxIdFormatException, InvalidTaxIdFormatException {
        Matcher m;
        if (dstFormat == null) {
            throw new UnknownTaxIdFormatException("Destination format can't be null.");
        }
        taxId = TaxIdFormatter.removeBlanks(taxId);
        if (srcFormat == null || srcFormat.trim().length() == 0) {
            srcFormat = TaxIdFormatter.determineFormat(null, taxId);
        }
        if (srcFormat == null || srcFormat.equals(TaxIdStructure.FMT_UNKNOWN)) {
            throw new UnknownTaxIdFormatException("Source format: " + srcFormat);
        }
        TaxIdStructure t = null;
        if (!srcFormat.substring(0, 2).equals(dstFormat.substring(0, 2))) {
            throw new InvalidTaxIdFormatException("You can't convert between different countries tax id format. " + srcFormat + " => " + dstFormat);
        }
        if (TaxIdStructure.FMT_SE10.equalsIgnoreCase(srcFormat)) {
            m = se10.matcher(taxId);
        } else if (TaxIdStructure.FMT_SE11.equalsIgnoreCase(srcFormat)) {
            m = se11.matcher(taxId);
        } else if (TaxIdStructure.FMT_SE12.equalsIgnoreCase(srcFormat)) {
            m = se12.matcher(taxId);
        } else if (TaxIdStructure.FMT_SE14.equalsIgnoreCase(srcFormat)) {
            m = se14.matcher(taxId);
        } else if (TaxIdStructure.FMT_FI08.equalsIgnoreCase(srcFormat)) {
            m = fi08.matcher(taxId);
        } else if (TaxIdStructure.FMT_FI09.equalsIgnoreCase(srcFormat)) {
            m = fi09.matcher(taxId);
        } else if (TaxIdStructure.FMT_NO09.equalsIgnoreCase(srcFormat)) {
            m = no09.matcher(taxId);
        } else if (TaxIdStructure.FMT_NO11.equalsIgnoreCase(srcFormat)) {
            m = no11.matcher(taxId);
        } else {
            throw new UnknownTaxIdFormatException("Source format: " + srcFormat);
        }
        if (!m.matches()) {
            throw new InvalidTaxIdFormatException("Taxid " + taxId + " doesn't conform to source format " + srcFormat + ".");
        }
        t = TaxIdFormatter.createTaxIdStructureFromMatcher(m, srcFormat);
        return t.printTaxId(dstFormat);
    }

    private static TaxIdStructure createTaxIdStructureFromMatcher(Matcher m, String taxIdFormat) {
        TaxIdStructure t = new TaxIdStructure(taxIdFormat);
        if ("SE".equalsIgnoreCase(t.getCountryCode())) {
            t.setPrefix(m.group(1));
            t.setLeftmiddle(m.group(2));
            t.setRightmiddle(m.group(3));
            t.setSuffix(m.group(4));
        } else if ("NO".equalsIgnoreCase(t.getCountryCode())) {
            t.setPrefix(m.group(1));
            t.setLeftmiddle(m.group(2));
            t.setSuffix(m.group(3));
        } else if ("FI".equalsIgnoreCase(t.getCountryCode())) {
            t.setPrefix(m.group(1));
            t.setSuffix(m.group(2));
        }
        return t;
    }

    public static String determineFormat(String countryCode, String taxId) {
        if (taxId == null) {
            return null;
        }
        taxId = TaxIdFormatter.removeBlanks(taxId);
        if (countryCode == null || countryCode.trim().length() == 0 || "SE".equalsIgnoreCase(countryCode)) {
            Matcher m10 = se10.matcher(taxId);
            if (m10.matches()) {
                return TaxIdStructure.FMT_SE10;
            }
            Matcher m11 = se11.matcher(taxId);
            if (m11.matches()) {
                return TaxIdStructure.FMT_SE11;
            }
            Matcher m12 = se12.matcher(taxId);
            if (m12.matches()) {
                return TaxIdStructure.FMT_SE12;
            }
            Matcher m14 = se14.matcher(taxId);
            if (m14.matches()) {
                return TaxIdStructure.FMT_SE14;
            }
        }
        if (countryCode == null || countryCode.trim().length() == 0 || "NO".equalsIgnoreCase(countryCode)) {
            Matcher mno09 = no09.matcher(taxId);
            if (mno09.matches()) {
                return TaxIdStructure.FMT_NO09;
            }
            Matcher mno11 = no11.matcher(taxId);
            if (mno11.matches()) {
                return TaxIdStructure.FMT_NO11;
            }
        }
        if (countryCode == null || countryCode.trim().length() == 0 || "FI".equalsIgnoreCase(countryCode)) {
            Matcher mfi08 = fi08.matcher(taxId);
            if (mfi08.matches()) {
                return TaxIdStructure.FMT_FI08;
            }
            Matcher mfi09 = fi09.matcher(taxId);
            if (mfi09.matches()) {
                return TaxIdStructure.FMT_FI09;
            }
        }
        return TaxIdStructure.FMT_UNKNOWN;
    }
}

