/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation;

import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import java.beans.Transient;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PaymentReportGroup {
    private String dstAcct;
    private String reconcileAcct;
    private String paymentType;
    private String paymentTypeReference;
    private String taxId;
    private String reconciliationDate;
    private String currency;
    private String dstBankAcct;
    private String dstBankAcctType;
    private Double openingBalance = 0.0;
    private Double endingBalance = 0.0;
    private Double totalPaidAmt = 0.0;
    private Double totalReceivedAmt = 0.0;
    private Double totalVatAmt = 0.0;
    private String vatAcct;
    private Boolean createAccountingRecords = Boolean.TRUE;
    private Boolean processRetryPaymentsOnly = Boolean.FALSE;
    private List<PaymentReportDetail> paymentReportDetail;
    private List<FeeDetail> totalInvoiceFees;
    private List<FeeDetail> totalOtherFees;
    private transient Map<String, FeeDetail> invoiceFeeMap;
    private transient Map<String, FeeDetail> otherFeeMap;

    public String getDstAcct() {
        return this.dstAcct;
    }

    public void setDstAcct(String dstAcct) {
        this.dstAcct = dstAcct;
    }

    public String getReconcileAcct() {
        return this.reconcileAcct;
    }

    public void setReconcileAcct(String reconcileAcct) {
        this.reconcileAcct = reconcileAcct;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentTypeReference() {
        return this.paymentTypeReference;
    }

    public void setPaymentTypeReference(String paymentTypeReference) {
        this.paymentTypeReference = paymentTypeReference;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public String getReconciliationDate() {
        return this.reconciliationDate;
    }

    public void setReconciliationDate(Date date) {
        this.reconciliationDate = date != null ? JsonUtil.dfmt.format(date) : null;
    }

    @Transient
    public Date getReconciliationDateAsDate() throws ParseException {
        if (this.reconciliationDate == null) {
            return null;
        }
        return JsonUtil.dfmt.parse(this.reconciliationDate);
    }

    public void setReconciliationDate(String reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDstBankAcct() {
        return this.dstBankAcct;
    }

    public void setDstBankAcct(String dstBankAcct) {
        this.dstBankAcct = dstBankAcct;
    }

    public String getDstBankAcctType() {
        return this.dstBankAcctType;
    }

    public void setDstBankAcctType(String dstBankAcctType) {
        this.dstBankAcctType = dstBankAcctType;
    }

    public List<PaymentReportDetail> getPaymentReportDetail() {
        return this.paymentReportDetail;
    }

    public void setPaymentReportDetail(List<PaymentReportDetail> paymentReportDetail) {
        this.paymentReportDetail = paymentReportDetail;
    }

    public Double getTotalPaidAmt() {
        return this.totalPaidAmt;
    }

    public void setTotalPaidAmt(Double totalPaidAmt) {
        this.totalPaidAmt = totalPaidAmt;
    }

    public Double getTotalReceivedAmt() {
        return this.totalReceivedAmt;
    }

    public void setTotalReceivedAmt(Double totalReceivedAmt) {
        this.totalReceivedAmt = totalReceivedAmt;
    }

    public Double getOpeningBalance() {
        return this.openingBalance;
    }

    public void setOpeningBalance(Double openingBalance) {
        this.openingBalance = openingBalance;
    }

    public Double getEndingBalance() {
        return this.endingBalance;
    }

    public void setEndingBalance(Double endingBalance) {
        this.endingBalance = endingBalance;
    }

    public String getVatAcct() {
        return this.vatAcct;
    }

    public void setVatAcct(String vatAcct) {
        this.vatAcct = vatAcct;
    }

    public Boolean getCreateAccountingRecords() {
        return this.createAccountingRecords;
    }

    public void setCreateAccountingRecords(Boolean createAccountingRecords) {
        this.createAccountingRecords = createAccountingRecords;
    }

    public Boolean getProcessRetryPaymentsOnly() {
        return this.processRetryPaymentsOnly;
    }

    public void setProcessRetryPaymentsOnly(Boolean processRetryPaymentsOnly) {
        this.processRetryPaymentsOnly = processRetryPaymentsOnly;
    }

    public void addDetail(PaymentReportDetail d) {
        if (this.paymentReportDetail == null) {
            this.paymentReportDetail = new ArrayList<PaymentReportDetail>();
        }
        this.paymentReportDetail.add(d);
        this.totalPaidAmt = this.totalPaidAmt + d.getPaidAmt();
        this.totalReceivedAmt = this.totalReceivedAmt + d.getReceivedAmt();
        this.totalReceivedAmt = (double)Math.round(this.totalReceivedAmt * 100.0) / 100.0;
        if (d.getFees() != null) {
            for (FeeDetail f : d.getFees()) {
                this.addInvoiceFee(f);
            }
        }
    }

    public PaymentReportDetail findDetailWithFeeAmount(String feeType, Double amount) {
        if (this.paymentReportDetail == null) {
            return null;
        }
        if (feeType == null) {
            return null;
        }
        PaymentReportDetail result = null;
        for (PaymentReportDetail d : this.paymentReportDetail) {
            if (d.getFees() == null) continue;
            for (FeeDetail f : d.getFees()) {
                if (!feeType.equals(f.getFeeType()) || !amount.equals(d.getReceivedAmt())) continue;
                result = d;
                break;
            }
            if (result != null) break;
        }
        return result;
    }

    public void removeDetail(PaymentReportDetail d) {
        if (this.paymentReportDetail == null) {
            return;
        }
        if (this.paymentReportDetail.contains(d)) {
            this.paymentReportDetail.remove(d);
            this.totalPaidAmt = this.totalPaidAmt - d.getPaidAmt();
            this.totalReceivedAmt = this.totalReceivedAmt - d.getReceivedAmt();
            this.totalReceivedAmt = (double)Math.round(this.totalReceivedAmt * 100.0) / 100.0;
            if (d.getFees() != null) {
                for (FeeDetail f : d.getFees()) {
                    if (!"deviations".equalsIgnoreCase(f.getFeeType())) {
                        this.removeInvoiceFee(f);
                        continue;
                    }
                    this.removeOtherFee(f);
                }
            }
        }
    }

    public FeeDetail getRoundingRecord() {
        FeeDetail roundingFee = null;
        if (this.otherFeeMap != null) {
            roundingFee = this.otherFeeMap.get("rounding");
        }
        return roundingFee;
    }

    private void addInvoiceFee(FeeDetail f) {
        FeeDetail src;
        if (f == null) {
            return;
        }
        if (this.invoiceFeeMap == null) {
            this.invoiceFeeMap = new TreeMap<String, FeeDetail>();
        }
        if ((src = this.invoiceFeeMap.get(f.getFeeType())) == null) {
            this.invoiceFeeMap.put(f.getFeeType(), new FeeDetail(f));
        } else {
            src.add(f);
        }
    }

    private void removeInvoiceFee(FeeDetail f) {
        if (f == null) {
            return;
        }
        if (this.invoiceFeeMap == null) {
            return;
        }
        FeeDetail src = this.invoiceFeeMap.get(f.getFeeType());
        if (src == null) {
            return;
        }
        src.subtract(f);
    }

    private void removeOtherFee(FeeDetail f) {
        if (f == null) {
            return;
        }
        if (this.otherFeeMap == null) {
            return;
        }
        FeeDetail src = this.otherFeeMap.get(f.getFeeType());
        if (src == null) {
            return;
        }
        src.subtract(f);
    }

    public void clearFees() {
        this.setTotalReceivedAmt(this.getTotalPaidAmt());
        this.setTotalVatAmt(0.0);
        if (this.paymentReportDetail != null) {
            for (PaymentReportDetail d : this.paymentReportDetail) {
                d.setFees(null);
                d.setReceivedAmt(d.getPaidAmt());
            }
        }
        this.totalInvoiceFees = null;
        this.totalOtherFees = null;
        this.invoiceFeeMap = null;
        this.otherFeeMap = null;
    }

    public void addOtherFee(FeeDetail f) {
        FeeDetail src;
        if (f == null) {
            return;
        }
        if (this.otherFeeMap == null) {
            this.otherFeeMap = new TreeMap<String, FeeDetail>();
        }
        if (f.getFeeType() == null) {
            f.setFeeType("deviations");
        }
        if ((src = this.otherFeeMap.get(f.getFeeType())) == null) {
            this.otherFeeMap.put(f.getFeeType(), f);
        } else {
            src.add(f);
        }
    }

    public void updateTotalFees() {
        ArrayList<FeeDetail> zeroFees = new ArrayList<FeeDetail>();
        if (this.invoiceFeeMap != null) {
            this.totalInvoiceFees = new ArrayList<FeeDetail>(this.invoiceFeeMap.values());
            for (FeeDetail f : this.totalInvoiceFees) {
                f.roundAll();
                if (f.getFeeTotal() != 0.0) continue;
                zeroFees.add(f);
            }
            for (FeeDetail f : zeroFees) {
                this.totalInvoiceFees.remove(f);
                this.invoiceFeeMap.remove(f.getFeeType());
            }
        }
        if (this.otherFeeMap != null) {
            zeroFees.clear();
            this.totalOtherFees = new ArrayList<FeeDetail>(this.otherFeeMap.values());
            for (FeeDetail f : this.totalOtherFees) {
                f.roundAll();
                if (f.getFeeTotal() != 0.0) continue;
                zeroFees.add(f);
            }
            for (FeeDetail f : zeroFees) {
                this.totalOtherFees.remove(f);
                this.otherFeeMap.remove(f.getFeeType());
            }
        }
    }

    public List<FeeDetail> getTotalInvoiceFees() {
        return this.totalInvoiceFees;
    }

    public void setTotalInvoiceFees(List<FeeDetail> totalFees) {
        this.totalInvoiceFees = totalFees;
    }

    public Double getTotalVatAmt() {
        return this.totalVatAmt;
    }

    public void setTotalVatAmt(Double totalVatAmt) {
        this.totalVatAmt = totalVatAmt;
    }

    public List<FeeDetail> getTotalOtherFees() {
        return this.totalOtherFees;
    }

    @Transient
    public FeeDetail calculateRoundingFee(double actualReceivedAmt, List<PaymentReportGroup> includedGroups) {
        double amt = this.calculateReceivedAmt();
        if (includedGroups != null) {
            for (PaymentReportGroup g : includedGroups) {
                amt += g.calculateReceivedAmt();
            }
        }
        amt = FeeDetail.roundFee(amt, 2);
        FeeDetail roundFee = null;
        if (actualReceivedAmt != amt) {
            double roundingAmt = amt - actualReceivedAmt;
            String feeType = "rounding";
            roundFee = new FeeDetail();
            if ("EUR".equalsIgnoreCase(this.getCurrency())) {
                if (Math.abs(roundingAmt) > 0.5) {
                    feeType = "deviations";
                }
            } else if (Math.abs(roundingAmt) > 5.0) {
                feeType = "deviations";
            }
            roundFee.setFeeType(feeType);
            roundFee.setFee(roundingAmt);
        }
        return roundFee;
    }

    @Transient
    public double calculateReceivedAmt() {
        double amt = this.openingBalance;
        if (this.paymentReportDetail == null) {
            return amt;
        }
        for (PaymentReportDetail d : this.paymentReportDetail) {
            amt += d.calculateReceivedAmt().doubleValue();
        }
        double otherFees = -FeeDetail.getTotalSum(this.getTotalOtherFees()).doubleValue();
        return amt += otherFees;
    }

    public void cancelOtherFees(String feeType, String[] cancelCandidates) {
        if (this.otherFeeMap == null) {
            return;
        }
        FeeDetail src = this.otherFeeMap.get(feeType);
        if (src == null) {
            return;
        }
        String[] stringArray = cancelCandidates;
        int n = cancelCandidates.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            FeeDetail candidate = this.otherFeeMap.get(c);
            if (candidate != null) {
                double diff = 0.0;
                diff = src.getFeeTotal() + candidate.getFeeTotal();
                if (("SEK".equalsIgnoreCase(this.currency) || "NOK".equalsIgnoreCase(this.currency) || "DKK".equalsIgnoreCase(this.currency)) && Math.abs(diff) <= 0.25 || "EUR".equalsIgnoreCase(this.currency) && Math.abs(diff) <= 0.025) {
                    this.otherFeeMap.remove(src.getFeeType());
                    this.otherFeeMap.remove(candidate.getFeeType());
                    if (diff != 0.0) {
                        FeeDetail f = new FeeDetail();
                        f.setFee(diff);
                        f.setFeeType("rounding");
                        f.roundAll();
                        this.addOtherFee(f);
                    }
                    this.updateTotalFees();
                }
            }
            ++n2;
        }
    }

    public void replaceDeviationsAsRounding() {
        if (this.otherFeeMap == null) {
            return;
        }
        FeeDetail existingRounding = this.otherFeeMap.get("rounding");
        FeeDetail deviation = this.otherFeeMap.get("deviations");
        if (deviation == null) {
            return;
        }
        if ("EUR".equalsIgnoreCase(this.getCurrency()) && Math.abs(deviation.getFeeTotal()) < 0.5 || ("SEK".equalsIgnoreCase(this.getCurrency()) || "NOK".equalsIgnoreCase(this.getCurrency())) && Math.abs(deviation.getFeeTotal()) < 2.0) {
            this.otherFeeMap.remove("deviations");
            if (existingRounding != null) {
                existingRounding.add(deviation);
            } else {
                deviation.setFeeType("rounding");
                this.otherFeeMap.put("rounding", deviation);
            }
            this.updateTotalFees();
        }
    }

    public void roundVatToGroupValue() {
        ArrayList<FeeDetail> allFees = new ArrayList<FeeDetail>();
        if (this.getTotalInvoiceFees() != null) {
            allFees.addAll(this.getTotalInvoiceFees());
        }
        if (this.getTotalOtherFees() != null) {
            allFees.addAll(this.getTotalOtherFees());
        }
        double vatSum = FeeDetail.getVatSum(allFees);
        FeeDetail roundingFee = null;
        double diff = vatSum - this.getTotalVatAmt();
        boolean newFee = false;
        if (diff != 0.0) {
            roundingFee = this.getRoundingRecord();
            if (roundingFee == null) {
                roundingFee = new FeeDetail();
                roundingFee.setFeeType("rounding");
                newFee = true;
            }
            roundingFee.setFeeVat(roundingFee.getFeeVat() - diff);
            roundingFee.setFee(roundingFee.getFee() + diff);
            if (newFee) {
                this.addOtherFee(roundingFee);
            }
            this.updateTotalFees();
        }
    }

    public void combineTotalOtherFees(List<FeeDetail> totalOtherFees, String[] invoiceFeeTypes, boolean invoiceFeesIncludedInTotal) {
        if (totalOtherFees == null) {
            return;
        }
        if (this.totalOtherFees == null) {
            this.totalOtherFees = totalOtherFees;
        } else if (this.totalOtherFees != totalOtherFees) {
            this.totalOtherFees.addAll(totalOtherFees);
        }
        if (invoiceFeesIncludedInTotal && this.invoiceFeeMap != null && invoiceFeeTypes != null) {
            String[] stringArray = invoiceFeeTypes;
            int n = invoiceFeeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String invoiceFeeType = stringArray[n2];
                FeeDetail f = this.invoiceFeeMap.get(invoiceFeeType);
                if (f != null) {
                    FeeDetail.subtract(this.totalOtherFees, invoiceFeeTypes, false, f);
                    for (FeeDetail fi : this.totalOtherFees) {
                        fi.roundAll();
                    }
                }
                ++n2;
            }
        }
        if (this.otherFeeMap != null) {
            this.otherFeeMap.clear();
        }
        for (FeeDetail f : this.totalOtherFees) {
            this.addOtherFee(f);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("{");
        if (this.dstAcct != null) {
            if (this.dstAcct != null) {
                str.append("DstAcct: " + this.dstAcct);
            }
            if (this.reconcileAcct != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append("ReconcileAcct: " + this.reconcileAcct);
            }
            if (this.paymentType != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append("PaymentType: " + this.paymentType);
            }
            if (this.paymentTypeReference != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append("PaymentTypeRef: " + this.paymentTypeReference);
            }
            if (this.reconciliationDate != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                String dateStr = null;
                try {
                    dateStr = JsonUtil.dfmt.format(this.reconciliationDate);
                }
                catch (Exception e) {
                    dateStr = this.reconciliationDate;
                }
                str.append("Date: " + dateStr);
            }
            if (this.currency != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append("Currency: " + this.currency);
            }
            if (this.totalPaidAmt != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append("Total Paid: " + this.totalPaidAmt);
            }
            if (this.totalReceivedAmt != null) {
                if (str.length() > 1) {
                    str.append(", ");
                }
                str.append("Total Received: " + this.totalReceivedAmt);
            }
        }
        str.append("}");
        return str.toString();
    }

    @Transient
    public boolean isEmpty() {
        boolean noAmounts;
        boolean noFees = this.totalInvoiceFees == null || this.totalInvoiceFees.isEmpty();
        boolean noOtherFees = this.totalOtherFees == null || this.totalOtherFees.isEmpty();
        boolean noDetails = this.paymentReportDetail == null || this.paymentReportDetail.isEmpty();
        boolean bl = noAmounts = !(this.totalPaidAmt != null && this.totalPaidAmt != 0.0 || this.totalReceivedAmt != null && this.totalReceivedAmt != 0.0 || this.totalVatAmt != null && this.totalVatAmt != 0.0);
        return noFees && noOtherFees && noDetails && noAmounts;
    }
}

